/*
 * Decompiled with CFR 0.152.
 */
package com.mediatek.mcs.domain;

import com.android.volley.Request;
import com.google.gson.Gson;
import com.mediatek.mcs.McsLog;
import com.mediatek.mcs.Utils.UIUtils;
import com.mediatek.mcs.domain.DataPointFormatter;
import com.mediatek.mcs.domain.a;
import com.mediatek.mcs.domain.b;
import com.mediatek.mcs.entity.DataChannelEntity;
import com.mediatek.mcs.entity.DataPointEntity;
import com.mediatek.mcs.entity.DataPointsUploadEntity;
import com.mediatek.mcs.entity.api.DeviceInfoEntity;
import com.mediatek.mcs.event.DataPointEvent;
import com.mediatek.mcs.exception.InvalidDataPointException;
import com.mediatek.mcs.net.McsJsonRequest;
import com.mediatek.mcs.net.RequestApi;
import com.mediatek.mcs.net.RequestManager;
import com.mediatek.mcs.socket.McsSocketListener;
import de.greenrobot.event.EventBus;
import org.json.JSONException;
import org.json.JSONObject;

public class McsDataChannel {
    String mDeviceId;
    String mDeviceKey;
    DataChannelEntity mDataChannelEntity;
    McsSocketListener socketListener;

    public McsDataChannel(DeviceInfoEntity device, DataChannelEntity channelEntity, McsSocketListener listener) {
        this.mDeviceId = device.getDeviceId();
        this.mDeviceKey = device.getDeviceKey();
        this.mDataChannelEntity = channelEntity;
        this.socketListener = listener;
    }

    public McsDataChannel(DeviceInfoEntity device, DataChannelEntity channelEntity) {
        this(device, channelEntity, null);
        this.socketListener = new McsSocketListener(a.a(this));
    }

    public McsSocketListener getMcsSocketListener() {
        return this.socketListener;
    }

    public String getDeviceId() {
        return this.mDeviceId;
    }

    public String getDeviceKey() {
        return this.mDeviceKey;
    }

    public String getChannelId() {
        return this.mDataChannelEntity.getDataChnId();
    }

    public String getChannelName() {
        return this.mDataChannelEntity.getName();
    }

    public boolean isControllable() {
        return this.mDataChannelEntity.isControllable();
    }

    public DataChannelEntity getDataChannelEntity() {
        return this.mDataChannelEntity;
    }

    public DataPointEntity getDataPointEntity() {
        return this.mDataChannelEntity.getDataPoint();
    }

    public void setDataPointEntity(DataPointEntity dp) {
        if (dp != null) {
            this.mDataChannelEntity.setDataPoint(dp);
            EventBus.getDefault().post((Object)new DataPointEvent(this.getChannelId(), dp));
        }
    }

    public void submitCurrentDataPoint() {
        this.submitDataPoint(this.getDataPointEntity().getValues());
    }

    public void submitDataPoint(DataPointEntity.Values values) {
        try {
            DataPointEntity.Values values2 = DataPointFormatter.formatValues(this.getDataChannelEntity(), values);
            String string2 = new Gson().toJson((Object)new DataPointsUploadEntity(new DataPointsUploadEntity.DataPoint(this.getChannelId(), values2)));
            this.requestUploadDataPointForBase(string2);
        }
        catch (InvalidDataPointException invalidDataPointException) {
            UIUtils.toast(invalidDataPointException.getMessage());
        }
    }

    public void requestUploadDataPointForBase(String requestBody) {
        RequestManager.sendInBackground((Request)new McsJsonRequest(1, RequestApi.UPLOAD_DATA_POINT.replace("{deviceId}", this.mDeviceId), requestBody, b.a()));
    }

    private static /* synthetic */ void lambda$requestUploadDataPointForBase$1(JSONObject response) {
        McsLog.d(response.toString(), new Object[0]);
    }

    private /* synthetic */ void lambda$new$0(JSONObject response) {
        try {
            JSONObject jSONObject = response.getJSONObject("updateDatapoint");
            DataPointEntity dataPointEntity = (DataPointEntity)new Gson().fromJson(jSONObject.toString(), DataPointEntity.class);
            this.setDataPointEntity(dataPointEntity);
        }
        catch (JSONException jSONException) {
            McsLog.e(jSONException.toString(), new Object[0]);
        }
    }

    static /* synthetic */ void access$lambda$0(McsDataChannel mcsDataChannel, JSONObject jSONObject) {
        mcsDataChannel.lambda$new$0(jSONObject);
    }

    static /* synthetic */ void access$lambda$1(JSONObject jSONObject) {
        McsDataChannel.lambda$requestUploadDataPointForBase$1(jSONObject);
    }
}

