package com.mediatek.mcs.pref;

import android.content.SharedPreferences;
import android.content.SharedPreferences.Editor;
import android.preference.PreferenceManager;
import com.google.gson.Gson;
import com.mediatek.mcs.Mcs;
import com.mediatek.mcs.entity.McsUserInfoEntity;
import org.json.JSONObject;

public final class McsUserInfo implements McsPreferences {

  private static final String USER_INFO_NICKNAME = "USER_INFO_NICKNAME";
  private static final String USER_INFO_IMAGE_URL = "USER_INFO_IMAGE_URL";
  private static McsUserInfo INSTANCE = new McsUserInfo();
  private Gson gson = new Gson();
  private SharedPreferences pref;
  private String userImageURL;
  private String nickname;
  private McsUserInfo() {
    pref = PreferenceManager.getDefaultSharedPreferences(Mcs.getApplicationContext());

    this.nickname = pref.getString(USER_INFO_NICKNAME, "");
    this.userImageURL = pref.getString(USER_INFO_IMAGE_URL, "");
  }

  public static McsUserInfo getInstance() {
    return INSTANCE;
  }

  public void clearPref() {
    this.nickname = "";
    this.userImageURL = "";
    savePref();
  }

  public void savePref() {
    Editor editor = pref.edit();
    editor.putString(USER_INFO_NICKNAME, this.nickname);
    editor.putString(USER_INFO_IMAGE_URL, this.userImageURL);
    editor.commit();
  }

  public void saveToPref(JSONObject response) {
    saveUserInfo(gson.fromJson(response.toString(), McsUserInfoEntity.class));
  }

  private void saveUserInfo(McsUserInfoEntity info) {
    this.setNickname(info.getNickname());
    this.setUserImageURL(info.getUserImageURL());
    this.savePref();
  }

  public String getUserImageURL() {
    return userImageURL;
  }

  public void setUserImageURL(String userImageURL) {
    this.userImageURL = userImageURL;
  }

  public String getNickname() {
    return nickname;
  }

  public void setNickname(String nickname) {
    this.nickname = nickname;
  }
}
