package com.mediatek.mcs.entity;

import com.google.gson.annotations.SerializedName;

public class AuthEntity extends McsEntity {
  /**
   * /oauth/login/thirdparty
   */
  public static class Token {
    private String token;
    @SerializedName("access_token") private String accessToken;

    public String getToken() {
      return token;
    }

    public String getAccessToken() {
      return accessToken;
    }
  }

  /**
   * /oauth/login/thirdparty/refresh
   */
  public static class AccessToken {
    private Results results;

    public Results getResults() {
      return results;
    }

    public static class Results {
      private String token;
      @SerializedName("access_token") private String accessToken;
      private String email;
      private String timezone;
      private String nickname;
      private String userImageURL;

      public String getAccessToken() {
        return accessToken;
      }

      public String getEmail() {
        return email;
      }

      public String getTimezone() {
        return timezone;
      }

      public String getNickname() {
        return nickname;
      }

      public String getUserImageURL() {
        return userImageURL;
      }

      public String getToken() {
        return token;
      }
    }
  }

  /**
   * /oauth/token/info
   */
  public static class Info {
    private String userId;
    private String email;
    private String timezone;
    private String nickname;
    private String userImageURL;

    public String getUserId() {
      return userId;
    }

    public String getEmail() {
      return email;
    }

    public String getTimezone() {
      return timezone;
    }

    public String getNickname() {
      return nickname;
    }

    public String getUserImageURL() {
      return userImageURL;
    }
  }
}
