package com.mediatek.mcs.domain;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import android.util.DisplayMetrics;
import com.google.gson.Gson;
import com.mediatek.mcs.BuildConfig;
import com.mediatek.mcs.Mcs;
import com.mediatek.mcs.entity.RegisterMobileEntity;

public class McsRegisterMobile {
  String manufacturer;
  String model;
  String name;
  String appName;
  String applicationId;
  String versionName;
  int versionCode;
  int sdkInt;

  String regId;
  String APP_KEY;
  String mcsAppId;
  String mcsClientKey;

  public McsRegisterMobile() {
    Context context = Mcs.getApplicationContext();

    this.manufacturer = Build.MANUFACTURER.toUpperCase();
    this.model = Build.MODEL;
    this.name = manufacturer + " " + model;
    this.sdkInt = Build.VERSION.SDK_INT;

    this.appName = context.getString(context.getApplicationInfo().labelRes);
    this.applicationId = Mcs.getApplicationContext().getPackageName();
    this.mcsAppId = Mcs.MCS_APP_KEY;
    this.mcsClientKey = Mcs.MCS_APP_SECRET;

    try {
      this.versionName = context.getPackageManager().getPackageInfo(applicationId, 0).versionName;
      this.versionCode = context.getPackageManager().getPackageInfo(applicationId, 0).versionCode;
    } catch (PackageManager.NameNotFoundException e) {
      this.versionName = BuildConfig.VERSION_NAME;
      this.versionCode = BuildConfig.VERSION_CODE;
    }

    this.regId = McsPushInstallation.getInstance().getRegId();
    this.APP_KEY = McsPushInstallation.getInstance().getAppKey();
  }

  public String toString() {
    return new Gson().toJson(new RegisterMobileEntity(name, regId, APP_KEY,
        new RegisterMobileEntity.Info(mcsAppId, mcsClientKey, manufacturer, model,
            applicationId, appName, versionName, versionCode, sdkInt, getScreenMetrics())),
        RegisterMobileEntity.class);
  }

  private RegisterMobileEntity.Info.ScreenMetrics getScreenMetrics() {
    DisplayMetrics metrics = Mcs.getApplicationContext().getResources().getDisplayMetrics();

    final float density = metrics.density;
    final int widthPixels = metrics.widthPixels;
    final int heightPixels = metrics.heightPixels;

    float widthDpi = metrics.xdpi;
    float heightDpi = metrics.ydpi;
    float widthInches = widthPixels / widthDpi;
    float heightInches = heightPixels / heightDpi;

    final double diagonalInches =
        Math.sqrt((widthInches * widthInches) + (heightInches * heightInches));

    return new RegisterMobileEntity.Info.ScreenMetrics(density, widthPixels, heightPixels,
        diagonalInches);
  }
}
