package com.mediatek.mcs;

import android.util.Log;
import com.android.volley.VolleyLog;

public class McsLog {
  public static String TAG = "Mcs";

  public static void init() {
    //        Logger.init(TAG)
    //                .hideThreadInfo()
    //                .setLogLevel((isDebuggable) ? LogLevel.FULL : LogLevel.NONE);
  }

  public static void setLogLevel(boolean isDebuggable) {
    if (!isDebuggable) VolleyLog.DEBUG = false;
  }

  public static void v(String format, Object... args) {
    if (Mcs.isDebuggable()) Log.v(TAG, buildMessage(format, args));
  }

  public static void d(String format, Object... args) {
    if (Mcs.isDebuggable()) Log.d(TAG, buildMessage(format, args));
  }

  public static void e(String format, Object... args) {
    if (Mcs.isDebuggable()) Log.e(TAG, buildMessage(format, args));
  }

  public static void e(Throwable tr, String format, Object... args) {
    if (Mcs.isDebuggable()) Log.e(TAG, buildMessage(format, args), tr);
  }

  private static String buildMessage(String format, Object... args) {
    return format;
  }
}
