/*
 * Decompiled with CFR 0.152.
 */
package com.medallia.word2vec.util;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.medallia.word2vec.util.Common;
import com.medallia.word2vec.util.Compare;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class Pair<K, V>
implements Map.Entry<K, V>,
Serializable {
    private static final long serialVersionUID = 1L;
    public final K first;
    public final V second;

    protected Pair(K first, V second) {
        this.first = first;
        this.second = second;
    }

    public static <X, Y> Pair<X, Y> cons(X x, Y y) {
        return new Pair<X, Y>(x, y);
    }

    public static <X> Pair<X, X> cons(X x, X y, boolean swapped) {
        return swapped ? new Pair<X, X>(y, x) : new Pair<X, X>(x, y);
    }

    @Override
    public int hashCode() {
        return (this.first == null ? 0 : this.first.hashCode() * 13) + (this.second == null ? 0 : this.second.hashCode() * 17);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        Pair op = (Pair)o;
        return Objects.equals(op.first, this.first) && Objects.equals(op.second, this.second);
    }

    public K getOne() {
        return this.first;
    }

    public K getFirst() {
        return this.first;
    }

    public V getSecond() {
        return this.second;
    }

    public String toString() {
        return "Pair<" + this.first + "," + this.second + ">";
    }

    public List<Object> asList() {
        return Lists.newArrayList((Object[])new Object[]{this.first, this.second});
    }

    @SafeVarargs
    public static <X> List<Pair<X, X>> fromPairs(X ... args) {
        if (Common.isOdd(args.length)) {
            throw new IllegalArgumentException("Array length must be even: " + args.length);
        }
        ArrayList<Pair<X, X>> l = new ArrayList<Pair<X, X>>(args.length / 2);
        for (int i = 0; i < args.length; i += 2) {
            l.add(Pair.cons(args[i], args[i + 1]));
        }
        return l;
    }

    public static <X, Y> List<Pair<X, Y>> fromMap(Map<X, Y> m) {
        ArrayList<Pair<X, Y>> l = new ArrayList<Pair<X, Y>>();
        for (Map.Entry<X, Y> me : m.entrySet()) {
            l.add(Pair.cons(me.getKey(), me.getValue()));
        }
        return l;
    }

    private static <X, Y, C extends Collection<Pair<X, Y>>> C fromMapFlatten(C c, Map<? extends X, ? extends Collection<? extends Y>> m) {
        for (Map.Entry<X, Collection<Y>> me : m.entrySet()) {
            for (Y y : me.getValue()) {
                c.add(Pair.cons(me.getKey(), y));
            }
        }
        return c;
    }

    @Override
    public K getKey() {
        return this.first;
    }

    @Override
    public V getValue() {
        return this.second;
    }

    @Override
    public V setValue(V value) {
        throw new UnsupportedOperationException();
    }

    public String getName() {
        return String.valueOf(this.second);
    }

    public Pair<V, K> swapped() {
        return Pair.cons(this.second, this.first);
    }

    public static <K, V> Function<Pair<K, V>, Pair<V, K>> swappedFunction() {
        return new Function<Pair<K, V>, Pair<V, K>>(){

            public Pair<V, K> apply(Pair<K, V> p) {
                return p.swapped();
            }
        };
    }

    public static <X extends Comparable<? super X>> Ordering<Pair<X, ?>> firstComparator() {
        return new Ordering<Pair<X, ?>>(){

            public int compare(Pair<X, ?> o1, Pair<X, ?> o2) {
                return Compare.compare((Comparable)o1.first, (Comparable)o2.first);
            }
        };
    }

    public static <Y extends Comparable<? super Y>> Ordering<Pair<?, Y>> secondComparator() {
        return new Ordering<Pair<?, Y>>(){

            public int compare(Pair<?, Y> o1, Pair<?, Y> o2) {
                return Compare.compare((Comparable)o1.second, (Comparable)o2.second);
            }
        };
    }

    public static <X extends Comparable<? super X>, Y extends Comparable<? super Y>> Ordering<Pair<X, Y>> firstThenSecondComparator() {
        return new Ordering<Pair<X, Y>>(){

            public int compare(Pair<X, Y> o1, Pair<X, Y> o2) {
                int k = Compare.compare((Comparable)o1.first, (Comparable)o2.first);
                if (k == 0) {
                    k = Compare.compare((Comparable)o1.second, (Comparable)o2.second);
                }
                return k;
            }
        };
    }

    public static <X extends Comparable<? super X>, Y extends Comparable<? super Y>> Ordering<Pair<X, Y>> secondThenFirstComparator() {
        return new Ordering<Pair<X, Y>>(){

            public int compare(Pair<X, Y> o1, Pair<X, Y> o2) {
                int k = Compare.compare((Comparable)o1.second, (Comparable)o2.second);
                if (k == 0) {
                    k = Compare.compare((Comparable)o1.first, (Comparable)o2.first);
                }
                return k;
            }
        };
    }

    public static <X, Y> Comparator<Pair<X, Y>> firstComparator(final Comparator<? super X> comp) {
        return new Comparator<Pair<X, Y>>(){

            @Override
            public int compare(Pair<X, Y> o1, Pair<X, Y> o2) {
                return comp.compare(o1.first, o2.first);
            }
        };
    }

    public static <X, Y> Comparator<Pair<X, Y>> secondComparator(final Comparator<? super Y> comp) {
        return new Comparator<Pair<X, Y>>(){

            @Override
            public int compare(Pair<X, Y> o1, Pair<X, Y> o2) {
                return comp.compare(o1.second, o2.second);
            }
        };
    }

    public static <X extends Comparable<? super X>, Y extends Comparable<? super Y>> Comparator<Pair<X, Y>> bothFirstReversedComparator() {
        return new Comparator<Pair<X, Y>>(){

            @Override
            public int compare(Pair<X, Y> o1, Pair<X, Y> o2) {
                int k = Compare.compare((Comparable)o2.first, (Comparable)o1.first);
                if (k == 0) {
                    k = Compare.compare((Comparable)o1.second, (Comparable)o2.second);
                }
                return k;
            }
        };
    }

    private static <X, Y> Map<X, Y> fillMap(Map<X, Y> m, Iterable<? extends Pair<? extends X, ? extends Y>> pairs) {
        for (Pair<X, Y> pair : pairs) {
            m.put(pair.first, pair.second);
        }
        return m;
    }

    public static <X, Y> List<Pair<X, Y>> cartesianProduct(Collection<X> c1, Collection<Y> c2) {
        return FluentIterable.from((Iterable)Sets.cartesianProduct((Set[])new Set[]{ImmutableSet.copyOf(c1), ImmutableSet.copyOf(c2)})).transform(new Function<List<Object>, Pair<X, Y>>(){

            public Pair<X, Y> apply(List<Object> objs) {
                Object x = objs.get(0);
                Object y = objs.get(1);
                return Pair.cons(x, y);
            }
        }).toList();
    }

    public static <X, Y> List<Pair<X, Y>> zip(Collection<X> c1, Collection<Y> c2) {
        return Pair.zip(c1, c2, new ArrayList<Pair<X, Y>>(c1.size()), false);
    }

    public static <X, Y> List<Pair<X, Y>> zip(X[] a1, Y[] a2) {
        return Pair.zip(ImmutableList.copyOf((Object[])a1), ImmutableList.copyOf((Object[])a2));
    }

    public static <X, Y> List<Pair<X, Y>> zipUnique(Collection<X> c1, Collection<Y> c2) {
        return Pair.zip(c1, c2, new ArrayList<Pair<X, Y>>(), true);
    }

    private static <X, Y> List<Pair<X, Y>> zip(Collection<X> c1, Collection<Y> c2, List<Pair<X, Y>> output, boolean uniqueKeys) {
        int size = c1.size();
        if (size != c2.size()) {
            throw new IllegalArgumentException("Collections must be of same size: " + size + ", " + c2.size());
        }
        HashSet<X> set = uniqueKeys ? new HashSet<X>() : null;
        Iterator<X> it1 = c1.iterator();
        Iterator<Y> it2 = c2.iterator();
        while (it1.hasNext() && it2.hasNext()) {
            X x = it1.next();
            Y y = it2.next();
            if (set != null && !set.add(x)) continue;
            output.add(Pair.cons(x, y));
        }
        return output;
    }

    public static <X, Y> Iterable<Pair<X, Y>> zipInner(final Iterable<X> first, final Iterable<Y> second) {
        return new Iterable<Pair<X, Y>>(){

            @Override
            public Iterator<Pair<X, Y>> iterator() {
                final Iterator x = first.iterator();
                final Iterator y = second.iterator();
                return new Iterator<Pair<X, Y>>(){

                    @Override
                    public boolean hasNext() {
                        return x.hasNext() && y.hasNext();
                    }

                    @Override
                    public Pair<X, Y> next() {
                        return Pair.cons(x.next(), y.next());
                    }

                    @Override
                    public void remove() {
                        x.remove();
                        y.remove();
                    }
                };
            }
        };
    }

    public static <V> Function<Pair<?, V>, V> retrieveSecondFunction() {
        return new Function<Pair<?, V>, V>(){

            public V apply(Pair<?, V> p) {
                return p.second;
            }
        };
    }

    public static <K, V> Iterable<V> unzipSecond(Iterable<Pair<K, V>> pairs) {
        return Iterables.transform(pairs, Pair.retrieveSecondFunction());
    }

    public static <K, V, V2> Function<Pair<K, V>, Pair<K, V2>> mapValues(final Function<? super V, V2> func) {
        return new Function<Pair<K, V>, Pair<K, V2>>(){

            public Pair<K, V2> apply(Pair<K, V> p) {
                return Pair.cons(p.first, func.apply(p.second));
            }
        };
    }

    public static <K> K firstOrNull(Pair<K, ?> pair) {
        return pair != null ? (K)pair.first : null;
    }

    public static <V> V secondOrNull(Pair<?, V> pair) {
        return pair != null ? (V)pair.second : null;
    }

    public static <K, V> Predicate<Pair<K, V>> getFirstPredicate(final Predicate<? super K> pred) {
        return new Predicate<Pair<K, V>>(){

            public boolean apply(Pair<K, V> pair) {
                return pred.apply(pair.first);
            }
        };
    }

    public static <K, V> Predicate<Pair<K, V>> getSecondPredicate(final Predicate<? super V> pred) {
        return new Predicate<Pair<K, V>>(){

            public boolean apply(Pair<K, V> pair) {
                return pred.apply(pair.second);
            }
        };
    }

    public static <K, V> Predicate<Pair<K, V>> getAndPredicate(final Predicate<? super K> firstPred, final Predicate<? super V> secondPred) {
        return new Predicate<Pair<K, V>>(){

            public boolean apply(Pair<K, V> pair) {
                return firstPred.apply(pair.first) && secondPred.apply(pair.second);
            }
        };
    }

    public static <K, V> Predicate<Pair<K, V>> getOrPredicate(final Predicate<? super K> firstPred, final Predicate<? super V> secondPred) {
        return new Predicate<Pair<K, V>>(){

            public boolean apply(Pair<K, V> pair) {
                return firstPred.apply(pair.first) || secondPred.apply(pair.second);
            }
        };
    }

    public static <X, Y> ImmutableList<Pair<X, Y>> toPairList(Iterable<X> values, Function<X, Y> func) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (X x : values) {
            result.add(Pair.cons(x, func.apply(x)));
        }
        return result.build();
    }
}

