/*
 * Decompiled with CFR 0.152.
 */
package com.medallia.word2vec.util;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.IOUtils;

public final class IO {
    public static final Comparator<File> FILE_LAST_MODIFIED_COMPARATOR = new Comparator<File>(){

        @Override
        public int compare(File o1, File o2) {
            return Long.compare(o1.lastModified(), o2.lastModified());
        }
    };
    private static final int DEFAULT_BUFFER_SIZE = 8192;

    private IO() {
    }

    public static File getOldestFileOrNull(Collection<File> files) {
        if (files.isEmpty()) {
            return null;
        }
        return Collections.min(files, FILE_LAST_MODIFIED_COMPARATOR);
    }

    public static long copyAndCloseOutput(InputStream input, OutputStream output) throws IOException {
        try (OutputStream outputStream = output;){
            long l = IO.copy(input, outputStream);
            return l;
        }
    }

    public static long copyAndCloseBoth(InputStream input, OutputStream output) throws IOException {
        try (InputStream inputStream = input;){
            long l = IO.copyAndCloseOutput(inputStream, output);
            return l;
        }
    }

    public static byte[] toByteArray(InputStream is) throws IOException {
        ByteArrayOutputStream bao = new ByteArrayOutputStream();
        IO.copyAndCloseBoth(is, bao);
        return bao.toByteArray();
    }

    public static long copy(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[8192];
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static int copy(Reader input, Writer output) throws IOException {
        char[] buffer = new char[8192];
        int count = 0;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += n;
        }
        return count;
    }

    public static int copyAndCloseOutput(Reader input, Writer output) throws IOException {
        try {
            int n = IO.copy(input, output);
            return n;
        }
        finally {
            output.close();
        }
    }

    public static int copyAndCloseBoth(Reader input, Writer output) throws IOException {
        try {
            int n = IO.copyAndCloseOutput(input, output);
            return n;
        }
        finally {
            input.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <X> X runWithFile(InputStream stream, Function<File, X> function) throws IOException {
        File f = File.createTempFile("run-with-file", null);
        try {
            try (FileOutputStream out = new FileOutputStream(f);){
                IOUtils.copy((InputStream)stream, (OutputStream)out);
            }
            Object object = function.apply((Object)f);
            return (X)object;
        }
        finally {
            f.delete();
        }
    }

    public static byte[] gzip(byte[] in) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            GZIPOutputStream gz = new GZIPOutputStream(bos);
            gz.write(in);
            gz.close();
            return bos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to compress bytes", e);
        }
    }

    public static byte[] gunzip(byte[] in) {
        try {
            GZIPInputStream gis = new GZIPInputStream(new ByteArrayInputStream(in));
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            IO.copyAndCloseOutput(gis, bos);
            return bos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to decompress data", e);
        }
    }

    /*
     * Exception decompiling
     */
    public static byte[] gzipObject(Object object) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Object gunzipObject(byte[] in) {
        try {
            return new ObjectInputStream(new GZIPInputStream(new ByteArrayInputStream(in))).readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException("Failed to decompress data", e);
        }
    }

    public static ObjectInputStream gullibleObjectInputStream(InputStream is) throws IOException {
        return new ObjectInputStream(is){

            @Override
            protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
                ObjectStreamClass oc = super.readClassDescriptor();
                try {
                    Class<?> c = Class.forName(oc.getName());
                    if (!c.isInterface()) {
                        Field f = oc.getClass().getDeclaredField("suid");
                        f.setAccessible(true);
                        f.set(oc, ObjectStreamClass.lookup(c).getSerialVersionUID());
                    }
                }
                catch (Exception e) {
                    System.err.println("Couldn't fake class descriptor for " + oc + ": " + e);
                }
                return oc;
            }
        };
    }

    public static void close(Closeable stream) {
        try {
            stream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static File createDirIfNotExists(File directory) throws IOException {
        if (!directory.isDirectory() && !directory.mkdirs()) {
            throw new IOException("Failed to create directory: " + directory.getAbsolutePath());
        }
        return directory;
    }

    public static boolean deleteIfPresent(File f) {
        return f == null || !f.exists() || f.delete();
    }

    public static File createTempFile(byte[] fileContents, String namePrefix, String extension) throws IOException {
        Preconditions.checkNotNull((Object)fileContents, (Object)"file contents missing");
        File tempFile = File.createTempFile(namePrefix, extension);
        try (FileOutputStream fos = new FileOutputStream(tempFile);){
            fos.write(fileContents);
        }
        return tempFile;
    }
}

