/*
 * Decompiled with CFR 0.152.
 */
package com.medallia.word2vec.util;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.UUID;

public final class FileUtils {
    public static final int ONE_KB = 1024;
    public static final int ONE_MB = 0x100000;
    public static final Function<File, String> FILE_TO_NAME = new Function<File, String>(){

        public String apply(File file) {
            return file.getName();
        }
    };

    public static File getDir(File parent, String item) {
        File dir = new File(parent, item);
        return dir.exists() && dir.isDirectory() ? dir : null;
    }

    private static File getOrCreateDir(File f) throws IOException {
        if (!f.exists()) {
            if (!f.mkdirs()) {
                throw new IOException(f.getName() + ": Unable to create directory: " + f.getAbsolutePath());
            }
        } else if (!f.isDirectory()) {
            throw new IOException(f.getName() + ": Exists and is not a directory: " + f.getAbsolutePath());
        }
        return f;
    }

    public static File getOrCreateDir(String dirName) throws IOException {
        return FileUtils.getOrCreateDir(new File(dirName));
    }

    public static File getOrCreateDir(File parent, String dirName) throws IOException {
        return FileUtils.getOrCreateDir(new File(parent, dirName));
    }

    public static File getOrCreateDir(File parent, String ... dirNames) throws IOException {
        return FileUtils.getOrCreateDir(Paths.get(parent.getPath(), dirNames).toFile());
    }

    public static boolean deleteRecursive(File file) {
        boolean result = true;
        if (file.isDirectory()) {
            for (File inner : file.listFiles()) {
                result &= FileUtils.deleteRecursive(inner);
            }
        }
        return result & file.delete();
    }

    private FileUtils() {
        throw new AssertionError((Object)"Do not instantiate.");
    }

    public static File getRandomTemporaryFolder(String prefix, String suffix) {
        return new File(System.getProperty("java.io.tmpdir"), Strings.nullToEmpty((String)prefix) + UUID.randomUUID().toString() + Strings.nullToEmpty((String)suffix));
    }
}

