/*
 * Decompiled with CFR 0.152.
 */
package com.medallia.word2vec.util;

import com.google.common.base.Preconditions;
import com.medallia.word2vec.util.Common;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Appender;
import org.apache.log4j.Logger;
import org.apache.log4j.varia.NullAppender;

public final class AutoLog {
    private AutoLog() {
    }

    public static Log getLog() {
        return AutoLog.getLog(2);
    }

    public static Log getLog(int distance) {
        Preconditions.checkState((boolean)InitializeOnDemand.INIT);
        String callerClassName = Common.myCaller(distance).getClassName();
        try {
            return LogFactory.getLog(Class.forName(callerClassName));
        }
        catch (ClassNotFoundException t) {
            String err = "Class.forName on " + callerClassName + " failed";
            System.err.println(err);
            throw new IllegalStateException(err, t);
        }
    }

    private static class InitializeOnDemand {
        private static final boolean INIT = InitializeOnDemand.init();

        private InitializeOnDemand() {
        }

        private static boolean init() {
            if (!Logger.getRootLogger().getAllAppenders().hasMoreElements()) {
                Logger.getRootLogger().addAppender((Appender)new NullAppender());
            }
            return true;
        }
    }
}

