/*
 * Decompiled with CFR 0.152.
 */
package com.medallia.word2vec.neuralnetwork;

import com.google.common.collect.Multiset;
import com.medallia.word2vec.Word2VecTrainerBuilder;
import com.medallia.word2vec.huffman.HuffmanCoding;
import com.medallia.word2vec.neuralnetwork.NeuralNetworkConfig;
import com.medallia.word2vec.neuralnetwork.NeuralNetworkTrainer;
import java.util.List;
import java.util.Map;

class SkipGramModelTrainer
extends NeuralNetworkTrainer {
    SkipGramModelTrainer(NeuralNetworkConfig config, Multiset<String> counts, Map<String, HuffmanCoding.HuffmanNode> huffmanNodes, Word2VecTrainerBuilder.TrainingProgressListener listener) {
        super(config, counts, huffmanNodes, listener);
    }

    @Override
    NeuralNetworkTrainer.Worker createWorker(int randomSeed, int iter, Iterable<List<String>> batch) {
        return new SkipGramWorker(randomSeed, iter, batch);
    }

    private class SkipGramWorker
    extends NeuralNetworkTrainer.Worker {
        private SkipGramWorker(int randomSeed, int iter, Iterable<List<String>> batch) {
            super(randomSeed, iter, batch);
        }

        @Override
        void trainSentence(List<String> sentence) {
            int sentenceLength = sentence.size();
            for (int sentencePosition = 0; sentencePosition < sentenceLength; ++sentencePosition) {
                int b;
                int c;
                String word = sentence.get(sentencePosition);
                HuffmanCoding.HuffmanNode huffmanNode = (HuffmanCoding.HuffmanNode)SkipGramModelTrainer.this.huffmanNodes.get(word);
                for (c = 0; c < SkipGramModelTrainer.this.layer1_size; ++c) {
                    this.neu1[c] = 0.0;
                }
                for (c = 0; c < SkipGramModelTrainer.this.layer1_size; ++c) {
                    this.neu1e[c] = 0.0;
                }
                this.nextRandom = NeuralNetworkTrainer.incrementRandom(this.nextRandom);
                for (int a = b = (int)((this.nextRandom % (long)SkipGramModelTrainer.this.window + this.nextRandom) % (long)SkipGramModelTrainer.this.window); a < SkipGramModelTrainer.this.window * 2 + 1 - b; ++a) {
                    int d;
                    int c2;
                    if (a == SkipGramModelTrainer.this.window || (c2 = sentencePosition - SkipGramModelTrainer.this.window + a) < 0 || c2 >= sentenceLength) continue;
                    for (int d2 = 0; d2 < SkipGramModelTrainer.this.layer1_size; ++d2) {
                        this.neu1e[d2] = 0.0;
                    }
                    int l1 = ((HuffmanCoding.HuffmanNode)SkipGramModelTrainer.this.huffmanNodes.get((Object)sentence.get((int)c2))).idx;
                    if (SkipGramModelTrainer.this.config.useHierarchicalSoftmax) {
                        for (d = 0; d < huffmanNode.code.length; ++d) {
                            int e;
                            double f = 0.0;
                            int l2 = huffmanNode.point[d];
                            for (int e2 = 0; e2 < SkipGramModelTrainer.this.layer1_size; ++e2) {
                                f += SkipGramModelTrainer.this.syn0[l1][e2] * SkipGramModelTrainer.this.syn1[l2][e2];
                            }
                            if (f <= -6.0 || f >= 6.0) continue;
                            f = NeuralNetworkTrainer.EXP_TABLE[(int)((f + 6.0) * 83.0)];
                            double g = ((double)(1 - huffmanNode.code[d]) - f) * SkipGramModelTrainer.this.alpha;
                            for (e = 0; e < SkipGramModelTrainer.this.layer1_size; ++e) {
                                int n = e;
                                this.neu1e[n] = this.neu1e[n] + g * SkipGramModelTrainer.this.syn1[l2][e];
                            }
                            for (e = 0; e < SkipGramModelTrainer.this.layer1_size; ++e) {
                                double[] dArray = SkipGramModelTrainer.this.syn1[l2];
                                int n = e;
                                dArray[n] = dArray[n] + g * SkipGramModelTrainer.this.syn0[l1][e];
                            }
                        }
                    }
                    this.handleNegativeSampling(huffmanNode);
                    for (d = 0; d < SkipGramModelTrainer.this.layer1_size; ++d) {
                        double[] dArray = SkipGramModelTrainer.this.syn0[l1];
                        int n = d;
                        dArray[n] = dArray[n] + this.neu1e[d];
                    }
                }
            }
        }
    }
}

