/*
 * Decompiled with CFR 0.152.
 */
package com.medallia.word2vec.huffman;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Multiset;
import com.medallia.word2vec.Word2VecTrainerBuilder;
import java.util.ArrayList;
import java.util.Map;

public class HuffmanCoding {
    private final ImmutableMultiset<String> vocab;
    private final Word2VecTrainerBuilder.TrainingProgressListener listener;

    public HuffmanCoding(ImmutableMultiset<String> vocab, Word2VecTrainerBuilder.TrainingProgressListener listener) {
        this.vocab = vocab;
        this.listener = listener;
    }

    public Map<String, HuffmanNode> encode() throws InterruptedException {
        int numTokens = this.vocab.elementSet().size();
        int[] parentNode = new int[numTokens * 2 + 1];
        byte[] binary = new byte[numTokens * 2 + 1];
        long[] count = new long[numTokens * 2 + 1];
        int i = 0;
        for (Multiset.Entry e : this.vocab.entrySet()) {
            count[i] = e.getCount();
            ++i;
        }
        Preconditions.checkState((i == numTokens ? 1 : 0) != 0, (String)"Expected %s to match %s", (Object[])new Object[]{i, numTokens});
        for (i = numTokens; i < count.length; ++i) {
            count[i] = 1000000000000000L;
        }
        this.createTree(numTokens, count, binary, parentNode);
        return this.encode(binary, parentNode);
    }

    private void createTree(int numTokens, long[] count, byte[] binary, int[] parentNode) throws InterruptedException {
        int pos1 = numTokens - 1;
        int pos2 = numTokens;
        for (int a = 0; a < numTokens - 1; ++a) {
            int min1i = pos1 >= 0 ? (count[pos1] < count[pos2] ? pos1-- : pos2++) : pos2++;
            int min2i = pos1 >= 0 ? (count[pos1] < count[pos2] ? pos1-- : pos2++) : pos2++;
            int newNodeIdx = numTokens + a;
            count[newNodeIdx] = count[min1i] + count[min2i];
            parentNode[min1i] = newNodeIdx;
            parentNode[min2i] = newNodeIdx;
            binary[min2i] = 1;
            if (a % 1000 != 0) continue;
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException("Interrupted while encoding huffman tree");
            }
            this.listener.update(Word2VecTrainerBuilder.TrainingProgressListener.Stage.CREATE_HUFFMAN_ENCODING, 0.5 * (double)a / (double)numTokens);
        }
    }

    private Map<String, HuffmanNode> encode(byte[] binary, int[] parentNode) throws InterruptedException {
        int numTokens = this.vocab.elementSet().size();
        ImmutableMap.Builder result = ImmutableMap.builder();
        int nodeIdx = 0;
        for (Multiset.Entry e : this.vocab.entrySet()) {
            int curNodeIdx = nodeIdx;
            ArrayList<Byte> code = new ArrayList<Byte>();
            ArrayList<Integer> points = new ArrayList<Integer>();
            do {
                code.add(binary[curNodeIdx]);
                points.add(curNodeIdx);
            } while ((curNodeIdx = parentNode[curNodeIdx]) != numTokens * 2 - 2);
            int codeLen = code.size();
            int count = e.getCount();
            byte[] rawCode = new byte[codeLen];
            int[] rawPoints = new int[codeLen + 1];
            rawPoints[0] = numTokens - 2;
            for (int i = 0; i < codeLen; ++i) {
                rawCode[codeLen - i - 1] = (Byte)code.get(i);
                rawPoints[codeLen - i] = (Integer)points.get(i) - numTokens;
            }
            String token = (String)e.getElement();
            result.put((Object)token, (Object)new HuffmanNode(rawCode, rawPoints, nodeIdx, count));
            if (nodeIdx % 1000 == 0) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new InterruptedException("Interrupted while encoding huffman tree");
                }
                this.listener.update(Word2VecTrainerBuilder.TrainingProgressListener.Stage.CREATE_HUFFMAN_ENCODING, 0.5 + 0.5 * (double)nodeIdx / (double)numTokens);
            }
            ++nodeIdx;
        }
        return result.build();
    }

    public static class HuffmanNode {
        public final byte[] code;
        public final int[] point;
        public final int idx;
        public final int count;

        private HuffmanNode(byte[] code, int[] point, int idx, int count) {
            this.code = code;
            this.point = point;
            this.idx = idx;
            this.count = count;
        }
    }
}

