/*
 * Decompiled with CFR 0.152.
 */
package com.medallia.word2vec;

import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Multiset;
import com.medallia.word2vec.Word2VecModel;
import com.medallia.word2vec.Word2VecTrainer;
import com.medallia.word2vec.neuralnetwork.NeuralNetworkConfig;
import com.medallia.word2vec.neuralnetwork.NeuralNetworkType;
import com.medallia.word2vec.util.AutoLog;
import java.util.List;
import org.apache.commons.logging.Log;

public class Word2VecTrainerBuilder {
    private static final Log LOG = AutoLog.getLog();
    private Integer layerSize;
    private Integer windowSize;
    private Integer numThreads;
    private NeuralNetworkType type;
    private int negativeSamples;
    private boolean useHierarchicalSoftmax;
    private Multiset<String> vocab;
    private Integer minFrequency;
    private Double initialLearningRate;
    private Double downSampleRate;
    private Integer iterations;
    private TrainingProgressListener listener;

    Word2VecTrainerBuilder() {
    }

    public Word2VecTrainerBuilder setLayerSize(int layerSize) {
        Preconditions.checkArgument((layerSize > 0 ? 1 : 0) != 0, (Object)"Value must be positive");
        this.layerSize = layerSize;
        return this;
    }

    public Word2VecTrainerBuilder setWindowSize(int windowSize) {
        Preconditions.checkArgument((windowSize > 0 ? 1 : 0) != 0, (Object)"Value must be positive");
        this.windowSize = windowSize;
        return this;
    }

    public Word2VecTrainerBuilder useNumThreads(int numThreads) {
        Preconditions.checkArgument((numThreads > 0 ? 1 : 0) != 0, (Object)"Value must be positive");
        this.numThreads = numThreads;
        return this;
    }

    public Word2VecTrainerBuilder type(NeuralNetworkType type) {
        this.type = (NeuralNetworkType)((Object)Preconditions.checkNotNull((Object)((Object)type)));
        return this;
    }

    public Word2VecTrainerBuilder useHierarchicalSoftmax() {
        this.useHierarchicalSoftmax = true;
        return this;
    }

    public Word2VecTrainerBuilder useNegativeSamples(int negativeSamples) {
        Preconditions.checkArgument((negativeSamples >= 0 ? 1 : 0) != 0, (Object)"Value must be non-negative");
        this.negativeSamples = negativeSamples;
        return this;
    }

    public Word2VecTrainerBuilder useVocab(Multiset<String> vocab) {
        this.vocab = (Multiset)Preconditions.checkNotNull(vocab);
        return this;
    }

    public Word2VecTrainerBuilder setMinVocabFrequency(int minFrequency) {
        Preconditions.checkArgument((minFrequency >= 0 ? 1 : 0) != 0, (Object)"Value must be non-negative");
        this.minFrequency = minFrequency;
        return this;
    }

    public Word2VecTrainerBuilder setInitialLearningRate(double initialLearningRate) {
        Preconditions.checkArgument((initialLearningRate >= 0.0 ? 1 : 0) != 0, (Object)"Value must be non-negative");
        this.initialLearningRate = initialLearningRate;
        return this;
    }

    public Word2VecTrainerBuilder setDownSamplingRate(double downSampleRate) {
        Preconditions.checkArgument((downSampleRate >= 0.0 ? 1 : 0) != 0, (Object)"Value must be non-negative");
        this.downSampleRate = downSampleRate;
        return this;
    }

    public Word2VecTrainerBuilder setNumIterations(int iterations) {
        Preconditions.checkArgument((iterations > 0 ? 1 : 0) != 0, (Object)"Value must be positive");
        this.iterations = iterations;
        return this;
    }

    public Word2VecTrainerBuilder setListener(TrainingProgressListener listener) {
        this.listener = listener;
        return this;
    }

    public Word2VecModel train(Iterable<List<String>> sentences) throws InterruptedException {
        this.type = (NeuralNetworkType)((Object)MoreObjects.firstNonNull((Object)((Object)this.type), (Object)((Object)NeuralNetworkType.CBOW)));
        this.initialLearningRate = (Double)MoreObjects.firstNonNull((Object)this.initialLearningRate, (Object)this.type.getDefaultInitialLearningRate());
        if (this.numThreads == null) {
            this.numThreads = Runtime.getRuntime().availableProcessors();
        }
        this.iterations = (Integer)MoreObjects.firstNonNull((Object)this.iterations, (Object)5);
        this.layerSize = (Integer)MoreObjects.firstNonNull((Object)this.layerSize, (Object)100);
        this.windowSize = (Integer)MoreObjects.firstNonNull((Object)this.windowSize, (Object)5);
        this.downSampleRate = (Double)MoreObjects.firstNonNull((Object)this.downSampleRate, (Object)0.001);
        this.minFrequency = (Integer)MoreObjects.firstNonNull((Object)this.minFrequency, (Object)5);
        this.listener = (TrainingProgressListener)MoreObjects.firstNonNull((Object)this.listener, (Object)new TrainingProgressListener(){

            @Override
            public void update(TrainingProgressListener.Stage stage, double progress) {
                System.out.println(String.format("Stage %s, progress %s%%", new Object[]{stage, progress}));
            }
        });
        Optional vocab = this.vocab == null ? Optional.absent() : Optional.of(this.vocab);
        return new Word2VecTrainer(this.minFrequency, (Optional<Multiset<String>>)vocab, new NeuralNetworkConfig(this.type, this.numThreads, this.iterations, this.layerSize, this.windowSize, this.negativeSamples, this.downSampleRate, this.initialLearningRate, this.useHierarchicalSoftmax)).train(LOG, this.listener, sentences);
    }

    public static interface TrainingProgressListener {
        public void update(Stage var1, double var2);

        public static enum Stage {
            ACQUIRE_VOCAB,
            FILTER_SORT_VOCAB,
            CREATE_HUFFMAN_ENCODING,
            TRAIN_NEURAL_NETWORK;

        }
    }
}

