/*
 * Decompiled with CFR 0.152.
 */
package com.medallia.word2vec;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.primitives.Doubles;
import com.medallia.word2vec.Searcher;
import com.medallia.word2vec.SearcherImpl;
import com.medallia.word2vec.Word2VecTrainerBuilder;
import com.medallia.word2vec.thrift.Word2VecModelThrift;
import com.medallia.word2vec.util.Common;
import com.medallia.word2vec.util.ProfilingTimer;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public class Word2VecModel {
    final List<String> vocab;
    final int layerSize;
    final DoubleBuffer vectors;
    private static final long ONE_GB = 0x40000000L;

    Word2VecModel(Iterable<String> vocab, int layerSize, DoubleBuffer vectors) {
        this.vocab = ImmutableList.copyOf(vocab);
        this.layerSize = layerSize;
        this.vectors = vectors;
    }

    Word2VecModel(Iterable<String> vocab, int layerSize, double[] vectors) {
        this(vocab, layerSize, DoubleBuffer.wrap(vectors));
    }

    public Iterable<String> getVocab() {
        return this.vocab;
    }

    public Searcher forSearch() {
        return new SearcherImpl(this);
    }

    public Word2VecModelThrift toThrift() {
        double[] vectorsArray;
        if (this.vectors.hasArray()) {
            vectorsArray = this.vectors.array();
        } else {
            vectorsArray = new double[this.vectors.limit()];
            this.vectors.position(0);
            this.vectors.get(vectorsArray);
        }
        return new Word2VecModelThrift().setVocab(this.vocab).setLayerSize(this.layerSize).setVectors(Doubles.asList((double[])vectorsArray));
    }

    public static Word2VecModel fromThrift(Word2VecModelThrift thrift) {
        return new Word2VecModel(thrift.getVocab(), thrift.getLayerSize(), Doubles.toArray(thrift.getVectors()));
    }

    public static Word2VecModel fromTextFile(File file) throws IOException {
        List<String> lines = Common.readToList(file);
        return Word2VecModel.fromTextFile(file.getAbsolutePath(), lines);
    }

    public static Word2VecModel fromBinFile(File file) throws IOException {
        return Word2VecModel.fromBinFile(file, ByteOrder.LITTLE_ENDIAN, ProfilingTimer.NONE);
    }

    public static Word2VecModel fromBinFile(File file, ByteOrder byteOrder) throws IOException {
        return Word2VecModel.fromBinFile(file, byteOrder, ProfilingTimer.NONE);
    }

    /*
     * Exception decompiling
     */
    public static Word2VecModel fromBinFile(File file, ByteOrder byteOrder, ProfilingTimer timer) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void toBinFile(OutputStream out) throws IOException {
        Charset cs = Charset.forName("UTF-8");
        String header = String.format("%d %d\n", this.vocab.size(), this.layerSize);
        out.write(header.getBytes(cs));
        double[] vector = new double[this.layerSize];
        ByteBuffer buffer = ByteBuffer.allocate(4 * this.layerSize);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        for (int i = 0; i < this.vocab.size(); ++i) {
            out.write(String.format("%s ", this.vocab.get(i)).getBytes(cs));
            this.vectors.position(i * this.layerSize);
            this.vectors.get(vector);
            buffer.clear();
            for (int j = 0; j < this.layerSize; ++j) {
                buffer.putFloat((float)vector[j]);
            }
            out.write(buffer.array());
            out.write(10);
        }
        out.flush();
    }

    @VisibleForTesting
    static Word2VecModel fromTextFile(String filename, List<String> lines) throws IOException {
        ArrayList vocab = Lists.newArrayList();
        ArrayList vectors = Lists.newArrayList();
        int vocabSize = Integer.parseInt(lines.get(0).split(" ")[0]);
        int layerSize = Integer.parseInt(lines.get(0).split(" ")[1]);
        Preconditions.checkArgument((vocabSize == lines.size() - 1 ? 1 : 0) != 0, (String)"For file '%s', vocab size is %s, but there are %s word vectors in the file", (Object[])new Object[]{filename, vocabSize, lines.size() - 1});
        for (int n = 1; n < lines.size(); ++n) {
            String[] values = lines.get(n).split(" ");
            vocab.add(values[0]);
            Preconditions.checkArgument((layerSize == values.length - 1 ? 1 : 0) != 0, (String)"For file '%s', on line %s, layer size is %s, but found %s values in the word vector", (Object[])new Object[]{filename, n, layerSize, values.length - 1});
            for (int d = 1; d < values.length; ++d) {
                vectors.add(Double.parseDouble(values[d]));
            }
        }
        Word2VecModelThrift thrift = new Word2VecModelThrift().setLayerSize(layerSize).setVocab(vocab).setVectors(vectors);
        return Word2VecModel.fromThrift(thrift);
    }

    public static Word2VecTrainerBuilder trainer() {
        return new Word2VecTrainerBuilder();
    }
}

