/*
 * Decompiled with CFR 0.152.
 */
package com.medallia.word2vec;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Doubles;
import com.medallia.word2vec.NormalizedWord2VecModel;
import com.medallia.word2vec.Searcher;
import com.medallia.word2vec.Word2VecModel;
import com.medallia.word2vec.util.Pair;
import java.nio.DoubleBuffer;
import java.util.Collection;
import java.util.List;

class SearcherImpl
implements Searcher {
    private final NormalizedWord2VecModel model;
    private final ImmutableMap<String, Integer> word2vectorOffset;

    SearcherImpl(NormalizedWord2VecModel model) {
        this.model = model;
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (int i = 0; i < model.vocab.size(); ++i) {
            result.put(model.vocab.get(i), (Object)(i * model.layerSize));
        }
        this.word2vectorOffset = result.build();
    }

    SearcherImpl(Word2VecModel model) {
        this(NormalizedWord2VecModel.fromWord2VecModel(model));
    }

    @Override
    public List<Searcher.Match> getMatches(String s, int maxNumMatches) throws Searcher.UnknownWordException {
        return this.getMatches(this.getVector(s), maxNumMatches);
    }

    @Override
    public double cosineDistance(String s1, String s2) throws Searcher.UnknownWordException {
        return this.calculateDistance(this.getVector(s1), this.getVector(s2));
    }

    @Override
    public boolean contains(String word) {
        return this.word2vectorOffset.containsKey((Object)word);
    }

    @Override
    public List<Searcher.Match> getMatches(final double[] vec, int maxNumMatches) {
        return Searcher.Match.ORDERING.greatestOf(Iterables.transform((Iterable)this.model.vocab, (Function)new Function<String, Searcher.Match>(){

            public Searcher.Match apply(String other) {
                double[] otherVec = SearcherImpl.this.getVectorOrNull(other);
                double d = SearcherImpl.this.calculateDistance(otherVec, vec);
                return new MatchImpl(other, d);
            }
        }), maxNumMatches);
    }

    private double calculateDistance(double[] otherVec, double[] vec) {
        double d = 0.0;
        for (int a = 0; a < this.model.layerSize; ++a) {
            d += vec[a] * otherVec[a];
        }
        return d;
    }

    @Override
    public ImmutableList<Double> getRawVector(String word) throws Searcher.UnknownWordException {
        return ImmutableList.copyOf((Collection)Doubles.asList((double[])this.getVector(word)));
    }

    private double[] getVector(String word) throws Searcher.UnknownWordException {
        double[] result = this.getVectorOrNull(word);
        if (result == null) {
            throw new Searcher.UnknownWordException(word);
        }
        return result;
    }

    private double[] getVectorOrNull(String word) {
        Integer index = (Integer)this.word2vectorOffset.get((Object)word);
        if (index == null) {
            return null;
        }
        DoubleBuffer vectors = this.model.vectors.duplicate();
        double[] result = new double[this.model.layerSize];
        vectors.position(index);
        vectors.get(result);
        return result;
    }

    private double[] getDifference(double[] v1, double[] v2) {
        double[] diff = new double[this.model.layerSize];
        for (int i = 0; i < this.model.layerSize; ++i) {
            diff[i] = v1[i] - v2[i];
        }
        return diff;
    }

    @Override
    public Searcher.SemanticDifference similarity(String s1, String s2) throws Searcher.UnknownWordException {
        double[] v1 = this.getVector(s1);
        double[] v2 = this.getVector(s2);
        final double[] diff = this.getDifference(v1, v2);
        return new Searcher.SemanticDifference(){

            @Override
            public List<Searcher.Match> getMatches(String word, int maxMatches) throws Searcher.UnknownWordException {
                double[] target = SearcherImpl.this.getDifference(SearcherImpl.this.getVector(word), diff);
                return SearcherImpl.this.getMatches(target, maxMatches);
            }
        };
    }

    private static class MatchImpl
    extends Pair<String, Double>
    implements Searcher.Match {
        private MatchImpl(String first, Double second) {
            super(first, second);
        }

        @Override
        public String match() {
            return (String)this.first;
        }

        @Override
        public double distance() {
            return (Double)this.second;
        }

        @Override
        public String toString() {
            return String.format("%s [%s]", this.first, this.second);
        }
    }
}

