/*
 * Decompiled with CFR 0.152.
 */
package com.medallia.word2vec;

import com.medallia.word2vec.Word2VecModel;
import com.medallia.word2vec.thrift.Word2VecModelThrift;
import java.io.File;
import java.io.IOException;
import java.nio.DoubleBuffer;

public class NormalizedWord2VecModel
extends Word2VecModel {
    private NormalizedWord2VecModel(Iterable<String> vocab, int layerSize, DoubleBuffer vectors) {
        super(vocab, layerSize, vectors);
        this.normalize();
    }

    private NormalizedWord2VecModel(Iterable<String> vocab, int layerSize, double[] vectors) {
        super(vocab, layerSize, vectors);
        this.normalize();
    }

    public static NormalizedWord2VecModel fromWord2VecModel(Word2VecModel model) {
        return new NormalizedWord2VecModel(model.vocab, model.layerSize, model.vectors.duplicate());
    }

    public static NormalizedWord2VecModel fromThrift(Word2VecModelThrift thrift) {
        return NormalizedWord2VecModel.fromWord2VecModel(Word2VecModel.fromThrift(thrift));
    }

    public static NormalizedWord2VecModel fromBinFile(File file) throws IOException {
        return NormalizedWord2VecModel.fromWord2VecModel(Word2VecModel.fromBinFile(file));
    }

    private void normalize() {
        for (int i = 0; i < this.vocab.size(); ++i) {
            int j;
            double len = 0.0;
            for (j = i * this.layerSize; j < (i + 1) * this.layerSize; ++j) {
                len += this.vectors.get(j) * this.vectors.get(j);
            }
            len = Math.sqrt(len);
            for (j = i * this.layerSize; j < (i + 1) * this.layerSize; ++j) {
                this.vectors.put(j, this.vectors.get(j) / len);
            }
        }
    }
}

