/*
 * Decompiled with CFR 0.152.
 */
package com.mdsol.mauth.apache;

import com.mdsol.mauth.DefaultSigner;
import com.mdsol.mauth.MAuthVersion;
import com.mdsol.mauth.SignerConfiguration;
import com.mdsol.mauth.exceptions.MAuthSigningException;
import com.mdsol.mauth.util.CurrentEpochTimeProvider;
import com.mdsol.mauth.util.EpochTimeProvider;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.ParseException;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;

public class HttpClientRequestSigner
extends DefaultSigner {
    public HttpClientRequestSigner(SignerConfiguration signerConfiguration) {
        super(signerConfiguration);
    }

    public HttpClientRequestSigner(UUID uUID, String string) {
        super(uUID, string);
    }

    public HttpClientRequestSigner(UUID uUID, String string, EpochTimeProvider epochTimeProvider) {
        super(uUID, string, epochTimeProvider);
    }

    public HttpClientRequestSigner(UUID uUID, PrivateKey privateKey) {
        super(uUID, privateKey, (EpochTimeProvider)new CurrentEpochTimeProvider());
    }

    public HttpClientRequestSigner(UUID uUID, PrivateKey privateKey, EpochTimeProvider epochTimeProvider) {
        super(uUID, privateKey, epochTimeProvider);
    }

    public HttpClientRequestSigner(UUID uUID, String string, EpochTimeProvider epochTimeProvider, List<MAuthVersion> list) {
        super(uUID, string, epochTimeProvider, list);
    }

    public void signRequest(HttpUriRequest httpUriRequest) throws MAuthSigningException {
        String string = httpUriRequest.getMethod();
        byte[] byArray = "".getBytes(StandardCharsets.UTF_8);
        if (httpUriRequest instanceof HttpEntityEnclosingRequest) {
            try {
                byArray = EntityUtils.toByteArray((HttpEntity)((HttpEntityEnclosingRequest)httpUriRequest).getEntity());
            }
            catch (IOException | ParseException throwable) {
                throw new MAuthSigningException(throwable);
            }
        }
        Map map = this.generateRequestHeaders(string, httpUriRequest.getURI().getRawPath(), byArray, httpUriRequest.getURI().getRawQuery());
        for (String string2 : map.keySet()) {
            httpUriRequest.addHeader(string2, (String)map.get(string2));
        }
    }
}

