/*
 * Decompiled with CFR 0.152.
 */
package com.mdsol.mauth.http4s;

import cats.Applicative;
import cats.ApplicativeError;
import cats.Apply;
import cats.FlatMap;
import cats.Functor;
import cats.Invariant;
import cats.Invariant$;
import cats.MonadError;
import cats.Semigroupal$;
import cats.package;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.ApplicativeIdOps$;
import cats.syntax.ApplyOps$;
import cats.syntax.package;
import com.mdsol.mauth.MAuthRequest;
import com.mdsol.mauth.MAuthVersion;
import com.mdsol.mauth.exception.MAuthValidationException;
import com.mdsol.mauth.http4s.RequestAuthenticator;
import com.mdsol.mauth.scaladsl.utils.ClientPublicKeyProvider;
import com.mdsol.mauth.util.EpochTimeProvider;
import com.mdsol.mauth.util.MAuthSignatureHelper;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.charset.StandardCharsets;
import java.security.PublicKey;
import java.util.Arrays;
import org.typelevel.log4cats.Logger;
import org.typelevel.log4cats.Logger$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

public final class RequestAuthenticator$ {
    public static final RequestAuthenticator$ MODULE$ = new RequestAuthenticator$();

    public <F> RequestAuthenticator<?> apply(ClientPublicKeyProvider<F> publicKeyProvider, EpochTimeProvider epochTimeProvider, MonadError<F, Throwable> evidence$3, Logger<F> evidence$4) {
        return new RequestAuthenticator<F>(publicKeyProvider, epochTimeProvider, false, evidence$3, evidence$4);
    }

    public <F> F com$mdsol$mauth$http4s$RequestAuthenticator$$validateTime(long requestTime, EpochTimeProvider epochTimeProvider, Duration requestValidationTimeout, ApplicativeError<F, Throwable> evidence$5) {
        return (F)ApplicativeIdOps$.MODULE$.pure$extension(package.all$.MODULE$.catsSyntaxApplicativeId((Object)BoxesRunTime.boxToBoolean((epochTimeProvider.inSeconds() - requestTime < requestValidationTimeout.toSeconds() ? 1 : 0) != 0)), evidence$5);
    }

    /*
     * Enabled aggressive block sorting
     */
    public <F> F com$mdsol$mauth$http4s$RequestAuthenticator$$validateMauthVersion(MAuthRequest mAuthRequest, boolean v2OnlyAuthenticate, ApplicativeError<F, Throwable> evidence$6) {
        boolean bl;
        block3: {
            block2: {
                if (!v2OnlyAuthenticate) break block2;
                MAuthVersion mAuthVersion = mAuthRequest.getMauthVersion();
                MAuthVersion mAuthVersion2 = MAuthVersion.MWSV2;
                if (mAuthVersion != null ? !mAuthVersion.equals(mAuthVersion2) : mAuthVersion2 != null) break block3;
            }
            bl = true;
            return (F)ApplicativeIdOps$.MODULE$.pure$extension(package.all$.MODULE$.catsSyntaxApplicativeId((Object)BoxesRunTime.boxToBoolean((boolean)bl)), evidence$6);
        }
        bl = false;
        return (F)ApplicativeIdOps$.MODULE$.pure$extension(package.all$.MODULE$.catsSyntaxApplicativeId((Object)BoxesRunTime.boxToBoolean((boolean)bl)), evidence$6);
    }

    public <F> F com$mdsol$mauth$http4s$RequestAuthenticator$$validateSignatureV1(MAuthRequest mAuthRequest, PublicKey clientPublicKey, MonadError<F, Throwable> evidence$7, Logger<F> evidence$8) {
        return (F)ApplyOps$.MODULE$.$times$greater$extension(package.all$.MODULE$.catsSyntaxApplyOps(this.logAuthenticationRequest(mAuthRequest, evidence$8)), ApplicativeErrorOps$.MODULE$.recoverWith$extension(package.all$.MODULE$.catsSyntaxApplicativeError(package.ApplicativeThrow$.MODULE$.apply(evidence$7).catchNonFatal((Function0)(JFunction0.mcZ.sp & Serializable)() -> {
            byte[] messageDigest_bytes = MAuthSignatureHelper.generateDigestedMessageV1((MAuthRequest)mAuthRequest).getBytes(StandardCharsets.UTF_8);
            return Arrays.equals(messageDigest_bytes, MAuthSignatureHelper.decryptSignature((PublicKey)clientPublicKey, (String)mAuthRequest.getRequestSignature()));
        }, (.less.colon.less)$less$colon$less$.MODULE$.refl()), evidence$7), (PartialFunction)new Serializable(evidence$8, evidence$7){
            private static final long serialVersionUID = 0L;
            private final Logger evidence$8$1;
            private final MonadError evidence$7$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof Exception) {
                    Exception exception = (Exception)A1;
                    String message = "MAuth request validation failed for V1.";
                    return (B1)ApplyOps$.MODULE$.$times$greater$extension(package.all$.MODULE$.catsSyntaxApplyOps(Logger$.MODULE$.apply(this.evidence$8$1).error((Throwable)exception, (Function0 & Serializable)() -> message)), package.ApplicativeThrow$.MODULE$.apply((ApplicativeError)this.evidence$7$1).raiseError((Object)new MAuthValidationException(message, (Throwable)exception)), (Apply)this.evidence$7$1);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                return throwable instanceof Exception;
            }
            {
                this.evidence$8$1 = evidence$8$1;
                this.evidence$7$1 = evidence$7$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(java.lang.String )}, serializedLambda);
            }
        }, evidence$7), evidence$7);
    }

    public <F> F com$mdsol$mauth$http4s$RequestAuthenticator$$validateSignatureV2(MAuthRequest mAuthRequest, PublicKey clientPublicKey, ApplicativeError<F, Throwable> evidence$9, Logger<F> evidence$10) {
        return (F)ApplyOps$.MODULE$.$times$greater$extension(package.all$.MODULE$.catsSyntaxApplyOps(this.logAuthenticationRequest(mAuthRequest, evidence$10)), ApplicativeErrorOps$.MODULE$.recoverWith$extension(package.all$.MODULE$.catsSyntaxApplicativeError(package.ApplicativeThrow$.MODULE$.apply(evidence$9).catchNonFatal((Function0)(JFunction0.mcZ.sp & Serializable)() -> MAuthSignatureHelper.verifyRSA((String)MAuthSignatureHelper.generateStringToSignV2((MAuthRequest)mAuthRequest), (String)mAuthRequest.getRequestSignature(), (PublicKey)clientPublicKey), (.less.colon.less)$less$colon$less$.MODULE$.refl()), evidence$9), (PartialFunction)new Serializable(evidence$10, evidence$9){
            private static final long serialVersionUID = 0L;
            private final Logger evidence$10$1;
            private final ApplicativeError evidence$9$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof Exception) {
                    Exception exception = (Exception)A1;
                    String message = "MAuth request validation failed for V2.";
                    return (B1)ApplyOps$.MODULE$.$times$greater$extension(package.all$.MODULE$.catsSyntaxApplyOps(Logger$.MODULE$.apply(this.evidence$10$1).error((Throwable)exception, (Function0 & Serializable)() -> message)), package.ApplicativeThrow$.MODULE$.apply(this.evidence$9$1).raiseError((Object)new MAuthValidationException(message, (Throwable)exception)), (Apply)this.evidence$9$1);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                return throwable instanceof Exception;
            }
            {
                this.evidence$10$1 = evidence$10$1;
                this.evidence$9$1 = evidence$9$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$2(java.lang.String )}, serializedLambda);
            }
        }, evidence$9), evidence$9);
    }

    public <F> F com$mdsol$mauth$http4s$RequestAuthenticator$$fallbackValidateSignatureV1(MAuthRequest mAuthRequest, PublicKey clientPublicKey, MonadError<F, Throwable> evidence$11, Logger<F> evidence$12) {
        return (F)Option$.MODULE$.apply((Object)mAuthRequest.getMessagePayload()).fold((Function0 & Serializable)() -> ApplyOps$.MODULE$.$times$greater$extension(package.all$.MODULE$.catsSyntaxApplyOps(Logger$.MODULE$.apply(evidence$12).warn((Function0 & Serializable)() -> "V1 authentication fallback is not available because the full request body is not available in memory.")), ApplicativeIdOps$.MODULE$.pure$extension(package.all$.MODULE$.catsSyntaxApplicativeId((Object)BoxesRunTime.boxToBoolean((boolean)false)), (Applicative)evidence$11), (Apply)evidence$11), (Function1 & Serializable)x$1 -> ((Option)package.all$.MODULE$.toFunctorOps(package.all$.MODULE$.catsSyntaxTuple2Semigroupal(new Tuple2((Object)Option$.MODULE$.apply((Object)mAuthRequest.getXmwsSignature()), (Object)Option$.MODULE$.apply((Object)mAuthRequest.getXmwsTime()))).tupled((Invariant)Invariant$.MODULE$.catsInstancesForOption(), Semigroupal$.MODULE$.catsSemigroupalForOption()), (Functor)Invariant$.MODULE$.catsInstancesForOption()).void()).map((Function1 & Serializable)x$2 -> {
            MAuthRequest mAuthRequestV1 = new MAuthRequest(mAuthRequest.getXmwsSignature(), mAuthRequest.getMessagePayload(), mAuthRequest.getHttpMethod(), mAuthRequest.getXmwsTime(), mAuthRequest.getResourcePath(), mAuthRequest.getQueryParameters());
            return package.all$.MODULE$.toFlatMapOps(MODULE$.com$mdsol$mauth$http4s$RequestAuthenticator$$validateSignatureV1(mAuthRequestV1, clientPublicKey, evidence$11, evidence$12), (FlatMap)evidence$11).flatTap((Function1 & Serializable)x$3 -> RequestAuthenticator$.$anonfun$fallbackValidateSignatureV1$5(evidence$12, evidence$11, BoxesRunTime.unboxToBoolean((Object)x$3)));
        }).getOrElse((Function0 & Serializable)() -> ApplyOps$.MODULE$.$times$greater$extension(package.all$.MODULE$.catsSyntaxApplyOps(Logger$.MODULE$.apply(evidence$12).warn((Function0 & Serializable)() -> "V1 authentication fallback is not available because the full request body is not available in memory.")), ApplicativeIdOps$.MODULE$.pure$extension(package.all$.MODULE$.catsSyntaxApplicativeId((Object)BoxesRunTime.boxToBoolean((boolean)false)), (Applicative)evidence$11), (Apply)evidence$11)));
    }

    private <F> F logAuthenticationRequest(MAuthRequest mAuthRequest, Logger<F> evidence$13) {
        String msgFormat = StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Mauth-client attempting to authenticate request from app with mauth app uuid %s using version %s."), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{mAuthRequest.getAppUUID(), mAuthRequest.getMauthVersion().getValue()}));
        return (F)Logger$.MODULE$.apply(evidence$13).info((Function0 & Serializable)() -> msgFormat);
    }

    public static final /* synthetic */ Object $anonfun$fallbackValidateSignatureV1$5(Logger evidence$12$1, MonadError evidence$11$1, boolean x$3) {
        if (x$3) {
            return Logger$.MODULE$.apply(evidence$12$1).warn((Function0 & Serializable)() -> "Completed successful authentication attempt after fallback to V1");
        }
        return ApplicativeIdOps$.MODULE$.pure$extension(package.all$.MODULE$.catsSyntaxApplicativeId((Object)BoxedUnit.UNIT), (Applicative)evidence$11$1);
    }

    private RequestAuthenticator$() {
    }
}

