/*
 * Decompiled with CFR 0.152.
 */
package com.mdsol.mauth.akka.http;

import akka.actor.ActorSystem;
import akka.http.scaladsl.model.HttpResponse;
import akka.http.scaladsl.model.StatusCode;
import akka.http.scaladsl.model.StatusCodes;
import akka.http.scaladsl.model.StatusCodes$;
import akka.http.scaladsl.unmarshalling.Unmarshal$;
import akka.http.scaladsl.unmarshalling.Unmarshaller$;
import akka.stream.Materializer;
import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.kernel.Sync;
import cats.effect.unsafe.implicits$;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.mdsol.mauth.AuthenticatorConfiguration;
import com.mdsol.mauth.MAuthRequestSigner;
import com.mdsol.mauth.http.HttpClient$;
import com.mdsol.mauth.http.Implicits;
import com.mdsol.mauth.http.Implicits$;
import com.mdsol.mauth.models.SignedRequest;
import com.mdsol.mauth.models.UnsignedRequest$;
import com.mdsol.mauth.scaladsl.utils.ClientPublicKeyProvider;
import com.mdsol.mauth.util.MAuthKeysHelper;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import java.net.URI;
import java.security.PublicKey;
import java.util.UUID;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.UninitializedFieldError;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scalacache.Entry;
import scalacache.Flags$;
import scalacache.caffeine.CaffeineCache$;
import scalacache.memoization.MemoizationConfig$;

@ScalaSignature(bytes="\u0006\u0005\u0005=e\u0001B\t\u0013\u0001uA\u0001\u0002\u000e\u0001\u0003\u0002\u0003\u0006I!\u000e\u0005\ts\u0001\u0011\t\u0011)A\u0005u!AQ\b\u0001B\u0001B\u0003-a\b\u0003\u0005E\u0001\t\u0005\t\u0015a\u0003F\u0011!a\u0005A!A!\u0002\u0017i\u0005\"B*\u0001\t\u0003!\u0006bB/\u0001\u0005\u0004%IA\u0018\u0005\b\u0003\u001f\u0001\u0001\u0015!\u0003`\u0011%\t\t\u0002\u0001b\u0001\n\u0007\t\u0019\u0002\u0003\u0005\u0002*\u0001\u0001\u000b\u0011BA\u000b\u0011%\tY\u0003\u0001b\u0001\n#\ti\u0003\u0003\u0005\u0002D\u0001\u0001\u000b\u0011BA\u0018\u0011\u001d\t)\u0005\u0001C!\u0003\u000fBq!a\u0018\u0001\t\u0003\n\t\u0007C\u0004\u0002h\u0001!\t\"!\u001b\t\u000f\u0005%\u0005\u0001\"\u0005\u0002\f\n1R*Y;uQB+(\r\\5d\u0017\u0016L\bK]8wS\u0012,'O\u0003\u0002\u0014)\u0005!\u0001\u000e\u001e;q\u0015\t)b#\u0001\u0003bW.\f'BA\f\u0019\u0003\u0015i\u0017-\u001e;i\u0015\tI\"$A\u0003nIN|GNC\u0001\u001c\u0003\r\u0019w.\\\u0002\u0001'\u0011\u0001a\u0004\n\u0017\u0011\u0005}\u0011S\"\u0001\u0011\u000b\u0003\u0005\nQa]2bY\u0006L!a\t\u0011\u0003\r\u0005s\u0017PU3g!\t)#&D\u0001'\u0015\t9\u0003&A\u0003vi&d7O\u0003\u0002*-\u0005A1oY1mC\u0012\u001cH.\u0003\u0002,M\t92\t\\5f]R\u0004VO\u00197jG.+\u0017\u0010\u0015:pm&$WM\u001d\t\u0003[Ij\u0011A\f\u0006\u0003_A\nAb]2bY\u0006dwnZ4j]\u001eT!!\r\u000e\u0002\u0011QL\b/Z:bM\u0016L!a\r\u0018\u0003\u001bM#(/[2u\u0019><w-\u001b8h\u00035\u0019wN\u001c4jOV\u0014\u0018\r^5p]B\u0011agN\u0007\u0002-%\u0011\u0001H\u0006\u0002\u001b\u0003V$\b.\u001a8uS\u000e\fGo\u001c:D_:4\u0017nZ;sCRLwN\\\u0001\u0007g&<g.\u001a:\u0011\u0005YZ\u0014B\u0001\u001f\u0017\u0005Ii\u0015)\u001e;i%\u0016\fX/Z:u'&<g.\u001a:\u0002\u0005\u0015\u001c\u0007CA C\u001b\u0005\u0001%BA!!\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003\u0007\u0002\u0013\u0001#\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0002\rML8\u000f^3n!\t1%*D\u0001H\u0015\tA\u0015*A\u0003bGR|'OC\u0001\u0016\u0013\tYuIA\u0006BGR|'oU=ti\u0016l\u0017\u0001D7bi\u0016\u0014\u0018.\u00197ju\u0016\u0014\bC\u0001(R\u001b\u0005y%B\u0001)J\u0003\u0019\u0019HO]3b[&\u0011!k\u0014\u0002\r\u001b\u0006$XM]5bY&TXM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007U[F\f\u0006\u0003W1fS\u0006CA,\u0001\u001b\u0005\u0011\u0002\"B\u001f\u0007\u0001\bq\u0004\"\u0002#\u0007\u0001\b)\u0005\"\u0002'\u0007\u0001\bi\u0005\"\u0002\u001b\u0007\u0001\u0004)\u0004\"B\u001d\u0007\u0001\u0004Q\u0014AB2DC\u000eDW-F\u0001`!\u0011\u0001\u0017n\u001b<\u000e\u0003\u0005T!AY2\u0002\u000b\r\f7\r[3\u000b\u0005\u0011,\u0017\u0001C2bM\u001a,\u0017N\\3\u000b\u0005\u0019<\u0017\u0001\u00032f]6\fg.Z:\u000b\u0005!T\u0012AB4ji\",(-\u0003\u0002kC\n)1)Y2iKB\u0011An\u001d\b\u0003[F\u0004\"A\u001c\u0011\u000e\u0003=T!\u0001\u001d\u000f\u0002\rq\u0012xn\u001c;?\u0013\t\u0011\b%\u0001\u0004Qe\u0016$WMZ\u0005\u0003iV\u0014aa\u0015;sS:<'B\u0001:!!\r9(\u0010`\u0007\u0002q*\t\u00110\u0001\u0006tG\u0006d\u0017mY1dQ\u0016L!a\u001f=\u0003\u000b\u0015sGO]=\u0011\u0007}ix0\u0003\u0002\u007fA\t1q\n\u001d;j_:\u0004B!!\u0001\u0002\f5\u0011\u00111\u0001\u0006\u0005\u0003\u000b\t9!\u0001\u0005tK\u000e,(/\u001b;z\u0015\t\tI!\u0001\u0003kCZ\f\u0017\u0002BA\u0007\u0003\u0007\u0011\u0011\u0002U;cY&\u001c7*Z=\u0002\u000f\r\u001c\u0015m\u00195fA\u0005i1-\u00194gK&tWmQ1dQ\u0016,\"!!\u0006\u0011\u000f]\f9\"!\u0007ly&\u0011!\u000e\u001f\t\u0005\u00037\t)#\u0004\u0002\u0002\u001e)!\u0011qDA\u0011\u0003\u0019)gMZ3di*\u0011\u00111E\u0001\u0005G\u0006$8/\u0003\u0003\u0002(\u0005u!AA%P\u00039\u0019\u0017M\u001a4fS:,7)Y2iK\u0002\na!\\1qa\u0016\u0014XCAA\u0018!\u0011\t\t$a\u0010\u000e\u0005\u0005M\"\u0002BA\u001b\u0003o\t\u0001\u0002Z1uC\nLg\u000e\u001a\u0006\u0005\u0003s\tY$A\u0004kC\u000e\\7o\u001c8\u000b\u0007\u0005u\"$A\u0005gCN$XM\u001d=nY&!\u0011\u0011IA\u001a\u00051y%M[3di6\u000b\u0007\u000f]3s\u0003\u001di\u0017\r\u001d9fe\u0002\nAbZ3u!V\u0014G.[2LKf$B!!\u0013\u0002PA!q(a\u0013}\u0013\r\ti\u0005\u0011\u0002\u0007\rV$XO]3\t\u000f\u0005ES\u00021\u0001\u0002T\u00059\u0011\r\u001d9V+&#\u0005\u0003BA+\u00037j!!a\u0016\u000b\t\u0005e\u0013qA\u0001\u0005kRLG.\u0003\u0003\u0002^\u0005]#\u0001B+V\u0013\u0012\u000babZ3u!V\u0014G.[2LKfLu\n\u0006\u0003\u0002d\u0005\u0015\u0004#BA\u000e\u0003Ka\bbBA)\u001d\u0001\u0007\u00111K\u0001\u0012e\u0016$(/[3wKB+(\r\\5d\u0017\u0016LHCAA6)\u0011\t\u0019'!\u001c\t\u0011\u0005=t\u0002\"a\u0001\u0003c\nQ#\\1vi\"\u0004VO\u00197jG.+\u0017PR3uG\",'\u000fE\u0003 \u0003g\n9(C\u0002\u0002v\u0001\u0012\u0001\u0002\u00102z]\u0006lWM\u0010\t\u0007\u00037\t)#!\u001f\u0011\t\u0005m\u0014QQ\u0007\u0003\u0003{RA!a \u0002\u0002\u0006)Qn\u001c3fY*\u0019\u0011&a!\u000b\u0005MI\u0015\u0002BAD\u0003{\u0012A\u0002\u0013;uaJ+7\u000f]8og\u0016\f\u0011cZ3u%\u0016\fX/Z:u+Jd\u0007+\u0019;i)\rY\u0017Q\u0012\u0005\b\u0003#\u0002\u0002\u0019AA*\u0001")
public class MauthPublicKeyProvider
implements ClientPublicKeyProvider,
StrictLogging {
    private final AuthenticatorConfiguration configuration;
    private final MAuthRequestSigner signer;
    private final ExecutionContext ec;
    private final ActorSystem system;
    private final Materializer materializer;
    private final Cache<String, Entry<Option<PublicKey>>> cCache;
    private final scalacache.Cache<IO, String, Option<PublicKey>> caffeineCache;
    private final ObjectMapper mapper;
    private Logger logger;
    private volatile byte bitmap$init$0;

    public Logger logger() {
        if ((byte)(this.bitmap$init$0 & 8) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/travis/build/mdsol/mauth-jvm-clients/modules/mauth-authenticator-akka-http/src/main/scala/com/mdsol/mauth/akka/http/MauthPublicKeyProvider.scala: 29");
        }
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 8);
    }

    private Cache<String, Entry<Option<PublicKey>>> cCache() {
        if ((byte)(this.bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/travis/build/mdsol/mauth-jvm-clients/modules/mauth-authenticator-akka-http/src/main/scala/com/mdsol/mauth/akka/http/MauthPublicKeyProvider.scala: 36");
        }
        return this.cCache;
    }

    public scalacache.Cache<IO, String, Option<PublicKey>> caffeineCache() {
        if ((byte)(this.bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/travis/build/mdsol/mauth-jvm-clients/modules/mauth-authenticator-akka-http/src/main/scala/com/mdsol/mauth/akka/http/MauthPublicKeyProvider.scala: 37");
        }
        return this.caffeineCache;
    }

    public ObjectMapper mapper() {
        if ((byte)(this.bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/travis/build/mdsol/mauth-jvm-clients/modules/mauth-authenticator-akka-http/src/main/scala/com/mdsol/mauth/akka/http/MauthPublicKeyProvider.scala: 38");
        }
        return this.mapper;
    }

    public Future<Option<PublicKey>> getPublicKey(UUID appUUID) {
        return this.getPublicKeyIO(appUUID).unsafeToFuture(implicits$.MODULE$.global());
    }

    public IO<Option<PublicKey>> getPublicKeyIO(UUID appUUID) {
        String key$macro$1 = MemoizationConfig$.MODULE$.defaultMemoizationConfig().toStringConverter().toString("com.mdsol.mauth.akka.http.MauthPublicKeyProvider", (IndexedSeq)Vector$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Vector[]{(Vector)Vector$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{this.configuration, this.signer})), (Vector)Vector$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{this.ec, this.system, this.materializer}))})), "getPublicKeyIO", (IndexedSeq)Vector$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Vector[]{(Vector)Vector$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UUID[]{appUUID}))})));
        SignedRequest signedRequest = this.signer.signRequest(UnsignedRequest$.MODULE$.noBody("GET", new URI(new StringBuilder(0).append(this.configuration.getBaseUrl()).append(this.getRequestUrlPath(appUUID)).toString()), Predef$.MODULE$.Map().empty()));
        return (IO)this.caffeineCache().cachingF((Object)key$macro$1, (Option)new Some((Object)new package.DurationLong(package$.MODULE$.DurationLong(this.configuration.getTimeToLive())).seconds()), this.retrievePublicKey((Function0<IO<HttpResponse>>)(Function0 & Serializable)() -> IO$.MODULE$.fromFuture(IO$.MODULE$.apply((Function0 & Serializable)() -> HttpClient$.MODULE$.call(Implicits.NewSignedRequestOps$.MODULE$.toAkkaHttpRequest$extension(Implicits$.MODULE$.NewSignedRequestOps(signedRequest)), $this.system)))), Flags$.MODULE$.defaultFlags());
    }

    public IO<Option<PublicKey>> retrievePublicKey(Function0<IO<HttpResponse>> mauthPublicKeyFetcher) {
        return ((IO)mauthPublicKeyFetcher.apply()).flatMap((Function1 & Serializable)response -> IO$.MODULE$.fromFuture(IO$.MODULE$.apply((Function0 & Serializable)() -> Unmarshal$.MODULE$.apply((Object)response.entity()).to(Unmarshaller$.MODULE$.stringUnmarshaller(), $this.ec, $this.materializer))).map((Function1 & Serializable)body -> {
            None$ none$;
            StatusCode statusCode = response.status();
            StatusCodes.Success success = StatusCodes$.MODULE$.OK();
            if (!(statusCode != null ? !statusCode.equals(success) : success != null)) {
                Some some;
                Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> MAuthKeysHelper.getPublicKeyFromString((String)this.mapper().readTree(body).findValue("public_key_str").asText()));
                if (try_ instanceof Success) {
                    Success success2 = (Success)try_;
                    PublicKey publicKey = (PublicKey)success2.value();
                    some = new Some((Object)publicKey);
                } else if (try_ instanceof Failure) {
                    BoxedUnit boxedUnit;
                    Failure failure = (Failure)try_;
                    Throwable error = failure.exception();
                    if (this.logger().underlying().isErrorEnabled()) {
                        this.logger().underlying().error("Converting string to Public Key failed", error);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    some = None$.MODULE$;
                } else {
                    throw new MatchError((Object)try_);
                }
                none$ = some;
            } else {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error("Unexpected response returned by server -- status: {} response: {}", new Object[]{response.status(), body});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                none$ = None$.MODULE$;
            }
            return none$;
        }).handleError((Function1 & Serializable)error -> {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("Request to get MAuth public key couldn't be signed", error);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return None$.MODULE$;
        })).handleError((Function1 & Serializable)error -> {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("Request to get MAuth public key couldn't be completed", error);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return None$.MODULE$;
        });
    }

    public String getRequestUrlPath(UUID appUUID) {
        return new StringBuilder(0).append(this.configuration.getRequestUrlPath()).append(String.format(this.configuration.getSecurityTokensUrlPath(), appUUID.toString())).toString();
    }

    public MauthPublicKeyProvider(AuthenticatorConfiguration configuration, MAuthRequestSigner signer, ExecutionContext ec, ActorSystem system, Materializer materializer) {
        this.configuration = configuration;
        this.signer = signer;
        this.ec = ec;
        this.system = system;
        this.materializer = materializer;
        StrictLogging.$init$((StrictLogging)this);
        this.cCache = Caffeine.newBuilder().build();
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        this.caffeineCache = CaffeineCache$.MODULE$.apply(this.cCache(), (Sync)IO$.MODULE$.asyncForIO());
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
        this.mapper = new ObjectMapper();
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
        Statics.releaseFence();
    }
}

