/*
 * Decompiled with CFR 0.152.
 */
package com.mdsol.mauth.akka.http;

import akka.http.javadsl.model.HttpHeader;
import akka.http.scaladsl.model.HttpEntity;
import akka.http.scaladsl.model.HttpRequest;
import akka.http.scaladsl.model.RequestEntity;
import akka.http.scaladsl.server.ConjunctionMagnet$;
import akka.http.scaladsl.server.Directive;
import akka.http.scaladsl.server.Directive$;
import akka.http.scaladsl.server.Directives$;
import akka.http.scaladsl.server.MalformedHeaderRejection;
import akka.http.scaladsl.server.MissingHeaderRejection;
import akka.http.scaladsl.server.Rejection;
import akka.http.scaladsl.server.StandardRoute$;
import akka.http.scaladsl.server.directives.BasicDirectives$;
import akka.http.scaladsl.server.directives.FutureDirectives$;
import akka.http.scaladsl.server.directives.HeaderMagnet$;
import akka.http.scaladsl.server.directives.RouteDirectives$;
import akka.http.scaladsl.server.util.Tuple$;
import akka.http.scaladsl.server.util.TupleOps;
import com.mdsol.mauth.MAuthRequest;
import com.mdsol.mauth.akka.http.AuthHeaderDetail;
import com.mdsol.mauth.akka.http.MauthHeaderValues;
import com.mdsol.mauth.akka.http.MdsolAuthFailedRejection$;
import com.mdsol.mauth.http.HttpVerbOps$;
import com.mdsol.mauth.http.X;
import com.mdsol.mauth.http.X$minusMWS$minusAuthentication$;
import com.mdsol.mauth.http.X$minusMWS$minusTime$;
import com.mdsol.mauth.scaladsl.Authenticator;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import java.util.UUID;
import java.util.function.Function;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple1;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u0005McaB\u0007\u000f!\u0003\r\t!\u0007\u0005\u0006Q\u0001!\t!\u000b\u0005\u0006[\u0001!\tA\f\u0005\b;\u0002\u0011\r\u0011\"\u0001_\u0011\u001d\u0011\bA1A\u0005\u0002MDqA\u001f\u0001C\u0002\u0013\u00051\u0010C\u0004\u0002\u0004\u0001!I!!\u0002\t\u000f\u0005E\u0001\u0001\"\u0003\u0002\u0014!9\u0011Q\u0005\u0001\u0005\n\u0005\u001d\u0002bBA\u0019\u0001\u0011\u0005\u00111G\u0004\b\u0003\u000fr\u0001\u0012AA%\r\u0019ia\u0002#\u0001\u0002L!9\u0011qJ\u0006\u0005\u0002\u0005E#aD'BkRDG)\u001b:fGRLg/Z:\u000b\u0005=\u0001\u0012\u0001\u00025uiBT!!\u0005\n\u0002\t\u0005\\7.\u0019\u0006\u0003'Q\tQ!\\1vi\"T!!\u0006\f\u0002\u000b5$7o\u001c7\u000b\u0003]\t1aY8n\u0007\u0001\u00192\u0001\u0001\u000e!!\tYb$D\u0001\u001d\u0015\u0005i\u0012!B:dC2\f\u0017BA\u0010\u001d\u0005\u0019\te.\u001f*fMB\u0011\u0011EJ\u0007\u0002E)\u00111\u0005J\u0001\rg\u000e\fG.\u00197pO\u001eLgn\u001a\u0006\u0003KY\t\u0001\u0002^=qKN\fg-Z\u0005\u0003O\t\u0012Qb\u0015;sS\u000e$Hj\\4hS:<\u0017A\u0002\u0013j]&$H\u0005F\u0001+!\tY2&\u0003\u0002-9\t!QK\\5u\u00031\tW\u000f\u001e5f]RL7-\u0019;f)\u0011ysI\u0014-\u0011\u0005A\"eBA\u0019B\u001d\t\u0011dH\u0004\u00024w9\u0011A'\u000f\b\u0003kaj\u0011A\u000e\u0006\u0003oa\ta\u0001\u0010:p_Rt\u0014\"A\t\n\u0005=Q$\"A\t\n\u0005qj\u0014\u0001C:dC2\fGm\u001d7\u000b\u0005=Q\u0014BA A\u0003\u0019\u0019XM\u001d<fe*\u0011A(P\u0005\u0003\u0005\u000e\u000bq\u0001]1dW\u0006<WM\u0003\u0002@\u0001&\u0011QI\u0012\u0002\u000b\t&\u0014Xm\u0019;jm\u0016\u0004$B\u0001\"D\u0011\u0015A%\u0001q\u0001J\u00035\tW\u000f\u001e5f]RL7-\u0019;peB\u0011!\nT\u0007\u0002\u0017*\u0011AHE\u0005\u0003\u001b.\u0013Q\"Q;uQ\u0016tG/[2bi>\u0014\b\"B(\u0003\u0001\b\u0001\u0016a\u0002;j[\u0016|W\u000f\u001e\t\u0003#Zk\u0011A\u0015\u0006\u0003'R\u000b\u0001\u0002Z;sCRLwN\u001c\u0006\u0003+r\t!bY8oGV\u0014(/\u001a8u\u0013\t9&K\u0001\bGS:LG/\u001a#ve\u0006$\u0018n\u001c8\t\u000be\u0013\u00019\u0001.\u00021I,\u0017/^3tiZ\u000bG.\u001b3bi&|g\u000eV5nK>,H\u000f\u0005\u0002R7&\u0011AL\u0015\u0002\t\tV\u0014\u0018\r^5p]\u0006qR\r\u001f;sC\u000e$Xj^:BkRDWM\u001c;jG\u0006$\u0018n\u001c8IK\u0006$WM]\u000b\u0002?B\u0019\u0001\u0007\u00192\n\u0005\u00054%A\u0003#je\u0016\u001cG/\u001b<fcA\u00111m\u001a\b\u0003I\u0016\u0004\"!\u000e\u000f\n\u0005\u0019d\u0012A\u0002)sK\u0012,g-\u0003\u0002iS\n11\u000b\u001e:j]\u001eT!A\u001a\u000f)\t\rYg\u000e\u001d\t\u000371L!!\u001c\u000f\u0003\u0015\u0011,\u0007O]3dCR,G-I\u0001p\u0003%\"\u0006.[:![\u0016$\bn\u001c3!SN\u0004cm\u001c:!\u001b\u0006,H\u000f\u001b\u0011Wc\u0001\u0002(o\u001c;pG>d\u0007e\u001c8ms\u0006\n\u0011/A\u00034]Ar\u0003'\u0001\nfqR\u0014\u0018m\u0019;N\u0003V$\b\u000eS3bI\u0016\u0014X#\u0001;\u0011\u0007A\u0002W\u000f\u0005\u0002wo6\ta\"\u0003\u0002y\u001d\t\u0001\u0012)\u001e;i\u0011\u0016\fG-\u001a:EKR\f\u0017\u000e\u001c\u0015\u0005\t-t\u0007/\u0001\u000bfqR\u0014\u0018m\u0019;NoN$\u0016.\\3IK\u0006$WM]\u000b\u0002yB\u0019\u0001\u0007Y?\u0011\u0005mq\u0018BA@\u001d\u0005\u0011auN\\4)\t\u0015Yg\u000e]\u0001\u0018Kb$(/Y2u\u0003V$\b\u000eS3bI\u0016\u0014H)\u001a;bS2$B!a\u0002\u0002\u000eA!1$!\u0003v\u0013\r\tY\u0001\b\u0002\u0007\u001fB$\u0018n\u001c8\t\r\u0005=a\u00011\u0001c\u0003\r\u0019HO]\u0001\u000fO\u0016$\u0018+^3ssN#(/\u001b8h)\r\u0011\u0017Q\u0003\u0005\b\u0003/9\u0001\u0019AA\r\u0003\r\u0011X-\u001d\t\u0005\u00037\t\t#\u0004\u0002\u0002\u001e)\u0019\u0011q\u0004!\u0002\u000b5|G-\u001a7\n\t\u0005\r\u0012Q\u0004\u0002\f\u0011R$\bOU3rk\u0016\u001cH/\u0001\u000bfqR\u0014\u0018m\u0019;SKF,Xm\u001d;IK\u0006$WM\u001d\u000b\u0006E\u0006%\u0012Q\u0006\u0005\b\u0003WA\u0001\u0019AA\r\u0003\u001d\u0011X-];fgRDa!a\f\t\u0001\u0004\u0011\u0017A\u00035fC\u0012,'OT1nK\u0006\u0011S\r\u001f;sC\u000e$H*\u0019;fgR\fU\u000f\u001e5f]RL7-\u0019;j_:DU-\u00193feN$B!!\u000e\u0002>A!\u0001\u0007YA\u001c!\r1\u0018\u0011H\u0005\u0004\u0003wq!!E'bkRD\u0007*Z1eKJ4\u0016\r\\;fg\"9\u0011qH\u0005A\u0002\u0005\u0005\u0013A\u0005<3\u001f:d\u00170Q;uQ\u0016tG/[2bi\u0016\u00042aGA\"\u0013\r\t)\u0005\b\u0002\b\u0005>|G.Z1o\u0003=i\u0015)\u001e;i\t&\u0014Xm\u0019;jm\u0016\u001c\bC\u0001<\f'\u0011Y!$!\u0014\u0011\u0005Y\u0004\u0011A\u0002\u001fj]&$h\b\u0006\u0002\u0002J\u0001")
public interface MAuthDirectives
extends StrictLogging {
    public void com$mdsol$mauth$akka$http$MAuthDirectives$_setter_$extractMwsAuthenticationHeader_$eq(Directive<Tuple1<String>> var1);

    public void com$mdsol$mauth$akka$http$MAuthDirectives$_setter_$extractMAuthHeader_$eq(Directive<Tuple1<AuthHeaderDetail>> var1);

    public void com$mdsol$mauth$akka$http$MAuthDirectives$_setter_$extractMwsTimeHeader_$eq(Directive<Tuple1<Object>> var1);

    public static /* synthetic */ Directive authenticate$(MAuthDirectives $this, Authenticator authenticator, FiniteDuration timeout, Duration requestValidationTimeout) {
        return $this.authenticate(authenticator, timeout, requestValidationTimeout);
    }

    default public Directive<BoxedUnit> authenticate(Authenticator authenticator, FiniteDuration timeout, Duration requestValidationTimeout) {
        return Directive.SingleValueTransformers$.MODULE$.flatMap$extension(Directive$.MODULE$.SingleValueTransformers(BasicDirectives$.MODULE$.extractExecutionContext()), (Function1 & Serializable)ec -> Directive.SingleValueTransformers$.MODULE$.flatMap$extension(Directive$.MODULE$.SingleValueTransformers(this.extractLatestAuthenticationHeaders(authenticator.isV2OnlyAuthenticate())), (Function1 & Serializable)mauthHeaderValues -> (Directive)BasicDirectives$.MODULE$.toStrictEntity(timeout).$amp(ConjunctionMagnet$.MODULE$.fromDirective(Directive.SingleValueTransformers$.MODULE$.flatMap$extension(Directive$.MODULE$.SingleValueTransformers(BasicDirectives$.MODULE$.extractRequest()), (Function1 & Serializable)req -> {
            Directive directive;
            RequestEntity requestEntity = req.entity();
            if (requestEntity instanceof HttpEntity.Strict) {
                HttpEntity.Strict strict = (HttpEntity.Strict)requestEntity;
                MAuthRequest mAuthRequest = new MAuthRequest(mauthHeaderValues.authenticator(), (byte[])strict.data().toArray((ClassTag)ClassTag$.MODULE$.Byte()), HttpVerbOps$.MODULE$.httpVerb(req.method()), Long.toString(mauthHeaderValues.time()), req.uri().path().toString(), this.getQueryString((HttpRequest)req));
                if (!authenticator.isV2OnlyAuthenticate()) {
                    String xmwsAuthenticationHeader = this.extractRequestHeader((HttpRequest)req, "x-mws-authentication");
                    String xmwsTimeHeader = this.extractRequestHeader((HttpRequest)req, "x-mws-time");
                    if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(xmwsAuthenticationHeader)) && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(xmwsTimeHeader))) {
                        mAuthRequest.setXmwsSignature(xmwsAuthenticationHeader);
                        mAuthRequest.setXmwsTime(xmwsTimeHeader);
                    }
                }
                directive = Directive.SingleValueTransformers$.MODULE$.flatMap$extension(Directive$.MODULE$.SingleValueTransformers(FutureDirectives$.MODULE$.onComplete((Function0 & Serializable)() -> authenticator.authenticate(mAuthRequest, (ExecutionContext)ec, requestValidationTimeout))), (Function1 & Serializable)x0$1 -> {
                    Success success;
                    boolean bl;
                    Try try_ = x0$1;
                    Directive directive = try_ instanceof Success && (bl = BoxesRunTime.unboxToBoolean((Object)(success = (Success)try_).value())) ? BasicDirectives$.MODULE$.pass() : StandardRoute$.MODULE$.toDirective(RouteDirectives$.MODULE$.reject((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Rejection[]{MdsolAuthFailedRejection$.MODULE$})), Tuple$.MODULE$.forUnit());
                    return directive;
                }, Tuple$.MODULE$.forUnit());
            } else {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error("MAUTH: Non-Strict Entity in Request");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                directive = StandardRoute$.MODULE$.toDirective(RouteDirectives$.MODULE$.reject((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Rejection[]{MdsolAuthFailedRejection$.MODULE$})), Tuple$.MODULE$.forUnit());
            }
            Directive isAuthed = directive;
            return isAuthed;
        }, Tuple$.MODULE$.forUnit()), TupleOps.Join$.MODULE$.join0P())), Tuple$.MODULE$.forUnit()), Tuple$.MODULE$.forUnit());
    }

    public Directive<Tuple1<String>> extractMwsAuthenticationHeader();

    public Directive<Tuple1<AuthHeaderDetail>> extractMAuthHeader();

    public Directive<Tuple1<Object>> extractMwsTimeHeader();

    private Option<AuthHeaderDetail> extractAuthHeaderDetail(String str) {
        None$ none$;
        if (str.startsWith("MWS ")) {
            None$ none$2;
            SeqOps seqOps;
            List list = Predef$.MODULE$.wrapRefArray((Object[])str.replaceFirst("MWS ", "").split(":")).toList();
            if (list != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.List().unapplySeq((SeqOps)list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) == 0) {
                Some some;
                String uuid = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
                String hash = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
                try {
                    some = new Some((Object)new AuthHeaderDetail(UUID.fromString(uuid), hash));
                }
                catch (Throwable throwable) {
                    Option option;
                    Throwable throwable2 = throwable;
                    if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        BoxedUnit boxedUnit;
                        Throwable e = (Throwable)option.get();
                        if (this.logger().underlying().isErrorEnabled()) {
                            this.logger().underlying().error(new StringBuilder(46).append("Bad format for UUID in authentication header: ").append(str).toString(), e);
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                    } else {
                        throw throwable;
                    }
                    None$ none$3 = None$.MODULE$;
                    some = none$3;
                }
                none$2 = some;
            } else {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error("Bad format for authentication header: {}", (Object)str);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                none$2 = None$.MODULE$;
            }
            none$ = none$2;
        } else {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("Bad format for authentication header: {}", (Object)str);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private String getQueryString(HttpRequest req) {
        return (String)req.uri().rawQueryString().getOrElse((Function0 & Serializable)() -> "");
    }

    private String extractRequestHeader(HttpRequest request, String headerName) {
        Function<HttpHeader, String> f = new Function<HttpHeader, String>(null){

            public <V> Function<V, String> compose(Function<? super V, ? extends HttpHeader> x$1) {
                return Function.super.compose(x$1);
            }

            public <V> Function<HttpHeader, V> andThen(Function<? super String, ? extends V> x$1) {
                return Function.super.andThen(x$1);
            }

            public String apply(HttpHeader h) {
                return h.value();
            }
        };
        return request.getHeader(headerName).map(f).orElse("");
    }

    public static /* synthetic */ Directive extractLatestAuthenticationHeaders$(MAuthDirectives $this, boolean v2OnlyAuthenticate) {
        return $this.extractLatestAuthenticationHeaders(v2OnlyAuthenticate);
    }

    default public Directive<Tuple1<MauthHeaderValues>> extractLatestAuthenticationHeaders(boolean v2OnlyAuthenticate) {
        return Directive.SingleValueTransformers$.MODULE$.flatMap$extension(Directive$.MODULE$.SingleValueTransformers(BasicDirectives$.MODULE$.extractRequest()), (Function1 & Serializable)request -> {
            Directive directive;
            Directive directive2;
            String authenticationHeaderStr = this.extractRequestHeader((HttpRequest)request, "mcc-authentication");
            if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(authenticationHeaderStr))) {
                Directive directive3;
                String timeHeaderStr = this.extractRequestHeader((HttpRequest)request, "mcc-time");
                if (!StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(timeHeaderStr))) {
                    directive2 = StandardRoute$.MODULE$.toDirective(RouteDirectives$.MODULE$.reject((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Rejection[]{new MissingHeaderRejection("mcc-time")})), Tuple$.MODULE$.forTuple1());
                    return directive2;
                }
                Option option = Try$.MODULE$.apply((Function0)(JFunction0.mcJ.sp & Serializable)() -> StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(timeHeaderStr))).toOption();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    long time = BoxesRunTime.unboxToLong((Object)some.value());
                    long l = time;
                    directive3 = BasicDirectives$.MODULE$.provide((Object)new MauthHeaderValues(authenticationHeaderStr, l));
                } else {
                    BoxedUnit boxedUnit;
                    if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                    String msg = new StringBuilder(44).append("mcc-time").append(" header supplied with bad format: [").append(timeHeaderStr).append("]").toString();
                    if (this.logger().underlying().isErrorEnabled()) {
                        this.logger().underlying().error(msg);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    directive3 = StandardRoute$.MODULE$.toDirective(RouteDirectives$.MODULE$.reject((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Rejection[]{new MalformedHeaderRejection("mcc-time", msg, (Option)None$.MODULE$)})), Tuple$.MODULE$.forTuple1());
                }
                directive2 = directive3;
                return directive2;
            }
            if (v2OnlyAuthenticate) {
                directive2 = StandardRoute$.MODULE$.toDirective(RouteDirectives$.MODULE$.reject((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Rejection[]{new MissingHeaderRejection("mcc-authentication")})), Tuple$.MODULE$.forTuple1());
                return directive2;
            }
            String authenticationHeaderStr2 = this.extractRequestHeader((HttpRequest)request, "x-mws-authentication");
            if (!StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(authenticationHeaderStr2))) {
                directive2 = StandardRoute$.MODULE$.toDirective(RouteDirectives$.MODULE$.reject((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Rejection[]{new MissingHeaderRejection("x-mws-authentication")})), Tuple$.MODULE$.forTuple1());
                return directive2;
            }
            String timeHeaderStr = this.extractRequestHeader((HttpRequest)request, "x-mws-time");
            if (!StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(timeHeaderStr))) {
                directive2 = StandardRoute$.MODULE$.toDirective(RouteDirectives$.MODULE$.reject((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Rejection[]{new MissingHeaderRejection("x-mws-time")})), Tuple$.MODULE$.forTuple1());
                return directive2;
            }
            Option option = Try$.MODULE$.apply((Function0)(JFunction0.mcJ.sp & Serializable)() -> StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(timeHeaderStr))).toOption();
            if (option instanceof Some) {
                Some some = (Some)option;
                long time = BoxesRunTime.unboxToLong((Object)some.value());
                long l = time;
                directive = BasicDirectives$.MODULE$.provide((Object)new MauthHeaderValues(authenticationHeaderStr2, l));
            } else {
                BoxedUnit boxedUnit;
                if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                String msg = new StringBuilder(46).append("x-mws-time").append(" header supplied with bad format: [").append(timeHeaderStr).append("]").toString();
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error(msg);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                directive = StandardRoute$.MODULE$.toDirective(RouteDirectives$.MODULE$.reject((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Rejection[]{new MalformedHeaderRejection("x-mws-time", msg, (Option)None$.MODULE$)})), Tuple$.MODULE$.forTuple1());
            }
            directive2 = directive;
            return directive2;
        }, Tuple$.MODULE$.forTuple1());
    }

    public static void $init$(MAuthDirectives $this) {
        $this.com$mdsol$mauth$akka$http$MAuthDirectives$_setter_$extractMwsAuthenticationHeader_$eq((Directive<Tuple1<String>>)Directives$.MODULE$.headerValueByName(X$minusMWS$minusAuthentication$.MODULE$.name()));
        $this.com$mdsol$mauth$akka$http$MAuthDirectives$_setter_$extractMAuthHeader_$eq((Directive<Tuple1<AuthHeaderDetail>>)Directive.SingleValueTransformers$.MODULE$.flatMap$extension(Directive$.MODULE$.SingleValueTransformers(Directives$.MODULE$.headerValueByType(HeaderMagnet$.MODULE$.fromUnitForModeledCustomHeader(BoxedUnit.UNIT, ClassTag$.MODULE$.apply(X.minusMWS.minusAuthentication.class), X$minusMWS$minusAuthentication$.MODULE$.implicitlyLocatableCompanion()))), (Function1 & Serializable)hdr -> {
            Directive directive;
            Some some;
            AuthHeaderDetail ahd;
            Option<AuthHeaderDetail> option = $this.extractAuthHeaderDetail(hdr.value());
            if (option instanceof Some && (ahd = (AuthHeaderDetail)(some = (Some)option).value()) != null) {
                AuthHeaderDetail authHeaderDetail = ahd;
                directive = BasicDirectives$.MODULE$.provide((Object)authHeaderDetail);
            } else if (None$.MODULE$.equals(option)) {
                BoxedUnit boxedUnit;
                String msg = new StringBuilder(36).append(X$minusMWS$minusAuthentication$.MODULE$.name()).append(" header supplied with bad format: [").append(hdr.value()).append("]").toString();
                if ($this.logger().underlying().isErrorEnabled()) {
                    $this.logger().underlying().error(msg);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                directive = StandardRoute$.MODULE$.toDirective(RouteDirectives$.MODULE$.reject((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Rejection[]{new MalformedHeaderRejection(X$minusMWS$minusAuthentication$.MODULE$.name(), msg, (Option)None$.MODULE$)})), Tuple$.MODULE$.forTuple1());
            } else {
                throw new MatchError(option);
            }
            return directive;
        }, Tuple$.MODULE$.forTuple1()));
        $this.com$mdsol$mauth$akka$http$MAuthDirectives$_setter_$extractMwsTimeHeader_$eq((Directive<Tuple1<Object>>)Directive.SingleValueTransformers$.MODULE$.flatMap$extension(Directive$.MODULE$.SingleValueTransformers(Directives$.MODULE$.headerValueByType(HeaderMagnet$.MODULE$.fromUnitForModeledCustomHeader(BoxedUnit.UNIT, ClassTag$.MODULE$.apply(X.minusMWS.minusTime.class), X$minusMWS$minusTime$.MODULE$.implicitlyLocatableCompanion()))), (Function1 & Serializable)time -> {
            BoxedUnit boxedUnit;
            Option option = Try$.MODULE$.apply((Function0)(JFunction0.mcJ.sp & Serializable)() -> StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(time.value()))).toOption();
            if (option instanceof Some) {
                Some some = (Some)option;
                long t = BoxesRunTime.unboxToLong((Object)some.value());
                if (true) {
                    long l = t;
                    return BasicDirectives$.MODULE$.provide((Object)BoxesRunTime.boxToLong((long)l));
                }
            }
            if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
            String msg = new StringBuilder(36).append(X$minusMWS$minusTime$.MODULE$.name()).append(" header supplied with bad format: [").append(time.value()).append("]").toString();
            if ($this.logger().underlying().isErrorEnabled()) {
                $this.logger().underlying().error(msg);
                boxedUnit = BoxedUnit.UNIT;
                return StandardRoute$.MODULE$.toDirective(RouteDirectives$.MODULE$.reject((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Rejection[]{new MalformedHeaderRejection(X$minusMWS$minusTime$.MODULE$.name(), msg, (Option)None$.MODULE$)})), Tuple$.MODULE$.forTuple1());
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return StandardRoute$.MODULE$.toDirective(RouteDirectives$.MODULE$.reject((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Rejection[]{new MalformedHeaderRejection(X$minusMWS$minusTime$.MODULE$.name(), msg, (Option)None$.MODULE$)})), Tuple$.MODULE$.forTuple1());
        }, Tuple$.MODULE$.forTuple1()));
    }
}

