/*
 * Decompiled with CFR 0.152.
 */
package com.mdsol.mauth.akka.http;

import akka.actor.ActorSystem;
import akka.http.caching.LfuCache$;
import akka.http.caching.scaladsl.Cache;
import akka.http.caching.scaladsl.CachingSettings;
import akka.http.caching.scaladsl.CachingSettings$;
import akka.http.caching.scaladsl.LfuCacheSettings;
import akka.http.scaladsl.model.HttpResponse;
import akka.http.scaladsl.model.StatusCode;
import akka.http.scaladsl.model.StatusCodes;
import akka.http.scaladsl.model.StatusCodes$;
import akka.http.scaladsl.unmarshalling.Unmarshal$;
import akka.http.scaladsl.unmarshalling.Unmarshaller$;
import akka.stream.Materializer;
import cats.effect.IO;
import cats.effect.IO$;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mdsol.mauth.AuthenticatorConfiguration;
import com.mdsol.mauth.MAuthRequestSigner;
import com.mdsol.mauth.http.HttpClient$;
import com.mdsol.mauth.http.Implicits;
import com.mdsol.mauth.http.Implicits$;
import com.mdsol.mauth.models.SignedRequest;
import com.mdsol.mauth.models.UnsignedRequest$;
import com.mdsol.mauth.scaladsl.utils.ClientPublicKeyProvider;
import com.mdsol.mauth.util.MAuthKeysHelper;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import java.net.URI;
import java.security.PublicKey;
import java.util.UUID;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Statics;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0005-e\u0001B\n\u0015\u0001}A\u0001\u0002\u0010\u0001\u0003\u0002\u0003\u0006I!\u0010\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005\u0005\"AQ\t\u0001B\u0001B\u0003-a\t\u0003\u0005J\u0001\t\u0005\t\u0015a\u0003K\u0011!\t\u0006A!A!\u0002\u0017\u0011\u0006\"\u0002-\u0001\t\u0003I\u0006b\u00022\u0001\u0005\u0004%\tb\u0019\u0005\u0007]\u0002\u0001\u000b\u0011\u00023\t\u000f=\u0004!\u0019!C\u0005a\"1\u0011\u0010\u0001Q\u0001\nEDqA\u001f\u0001C\u0002\u0013%1\u0010\u0003\u0004\u0000\u0001\u0001\u0006I\u0001 \u0005\n\u0003\u0003\u0001!\u0019!C\u0005\u0003\u0007A\u0001\"!\f\u0001A\u0003%\u0011Q\u0001\u0005\b\u0003_\u0001A\u0011IA\u0019\u0011\u001d\tI\u0004\u0001C\u0001\u0003wAq!a\u0014\u0001\t#\t\t\u0006C\u0004\u0002p\u0001!\t\"!\u001d\u0003-5\u000bW\u000f\u001e5Qk\nd\u0017nY&fsB\u0013xN^5eKJT!!\u0006\f\u0002\t!$H\u000f\u001d\u0006\u0003/a\tA!Y6lC*\u0011\u0011DG\u0001\u0006[\u0006,H\u000f\u001b\u0006\u00037q\tQ!\u001c3t_2T\u0011!H\u0001\u0004G>l7\u0001A\n\u0005\u0001\u00012C\u0007\u0005\u0002\"I5\t!EC\u0001$\u0003\u0015\u00198-\u00197b\u0013\t)#E\u0001\u0004B]f\u0014VM\u001a\t\u0004O1rS\"\u0001\u0015\u000b\u0005%R\u0013!B;uS2\u001c(BA\u0016\u0019\u0003!\u00198-\u00197bINd\u0017BA\u0017)\u0005]\u0019E.[3oiB+(\r\\5d\u0017\u0016L\bK]8wS\u0012,'\u000f\u0005\u00020e5\t\u0001G\u0003\u00022E\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\u0005M\u0002$A\u0002$viV\u0014X\r\u0005\u00026u5\taG\u0003\u00028q\u0005a1oY1mC2|wmZ5oO*\u0011\u0011\bH\u0001\tif\u0004Xm]1gK&\u00111H\u000e\u0002\u000e'R\u0014\u0018n\u0019;M_\u001e<\u0017N\\4\u0002\u001b\r|gNZ5hkJ\fG/[8o!\tqt(D\u0001\u0019\u0013\t\u0001\u0005D\u0001\u000eBkRDWM\u001c;jG\u0006$xN]\"p]\u001aLw-\u001e:bi&|g.\u0001\u0004tS\u001etWM\u001d\t\u0003}\rK!\u0001\u0012\r\u0003%5\u000bU\u000f\u001e5SKF,Xm\u001d;TS\u001etWM]\u0001\u0003K\u000e\u0004\"aL$\n\u0005!\u0003$\u0001E#yK\u000e,H/[8o\u0007>tG/\u001a=u\u0003\u0019\u0019\u0018p\u001d;f[B\u00111jT\u0007\u0002\u0019*\u0011QJT\u0001\u0006C\u000e$xN\u001d\u0006\u0002/%\u0011\u0001\u000b\u0014\u0002\f\u0003\u000e$xN]*zgR,W.\u0001\u0007nCR,'/[1mSj,'\u000f\u0005\u0002T-6\tAK\u0003\u0002V\u001d\u000611\u000f\u001e:fC6L!a\u0016+\u0003\u00195\u000bG/\u001a:jC2L'0\u001a:\u0002\rqJg.\u001b;?)\rQ\u0006-\u0019\u000b\u00057vsv\f\u0005\u0002]\u00015\tA\u0003C\u0003F\r\u0001\u000fa\tC\u0003J\r\u0001\u000f!\nC\u0003R\r\u0001\u000f!\u000bC\u0003=\r\u0001\u0007Q\bC\u0003B\r\u0001\u0007!)\u0001\u0004nCB\u0004XM]\u000b\u0002IB\u0011Q\r\\\u0007\u0002M*\u0011q\r[\u0001\tI\u0006$\u0018MY5oI*\u0011\u0011N[\u0001\bU\u0006\u001c7n]8o\u0015\tYG$A\u0005gCN$XM\u001d=nY&\u0011QN\u001a\u0002\r\u001f\nTWm\u0019;NCB\u0004XM]\u0001\b[\u0006\u0004\b/\u001a:!\u0003Y!WMZ1vYR\u001c\u0015m\u00195j]\u001e\u001cV\r\u001e;j]\u001e\u001cX#A9\u0011\u0005I<X\"A:\u000b\u0005-\"(BA;w\u0003\u001d\u0019\u0017m\u00195j]\u001eT!!\u0006(\n\u0005a\u001c(aD\"bG\"LgnZ*fiRLgnZ:\u0002/\u0011,g-Y;mi\u000e\u000b7\r[5oON+G\u000f^5oON\u0004\u0013\u0001\u00057gk\u000e\u000b7\r[3TKR$\u0018N\\4t+\u0005a\bC\u0001:~\u0013\tq8O\u0001\tMMV\u001c\u0015m\u00195f'\u0016$H/\u001b8hg\u0006\tBNZ;DC\u000eDWmU3ui&twm\u001d\u0011\u0002\u000b\r\f7\r[3\u0016\u0005\u0005\u0015\u0001c\u0002:\u0002\b\u0005-\u00111D\u0005\u0004\u0003\u0013\u0019(!B\"bG\",\u0007\u0003BA\u0007\u0003/i!!a\u0004\u000b\t\u0005E\u00111C\u0001\u0005kRLGN\u0003\u0002\u0002\u0016\u0005!!.\u0019<b\u0013\u0011\tI\"a\u0004\u0003\tU+\u0016\n\u0012\t\u0006C\u0005u\u0011\u0011E\u0005\u0004\u0003?\u0011#AB(qi&|g\u000e\u0005\u0003\u0002$\u0005%RBAA\u0013\u0015\u0011\t9#a\u0005\u0002\u0011M,7-\u001e:jifLA!a\u000b\u0002&\tI\u0001+\u001e2mS\u000e\\U-_\u0001\u0007G\u0006\u001c\u0007.\u001a\u0011\u0002\u0019\u001d,G\u000fU;cY&\u001c7*Z=\u0015\t\u0005M\u0012Q\u0007\t\u0005_I\nY\u0002C\u0004\u00028=\u0001\r!a\u0003\u0002\u000f\u0005\u0004\b/V+J\t\u0006qq-\u001a;Qk\nd\u0017nY&fs&{E\u0003BA\u001f\u0003\u001b\u0002b!a\u0010\u0002J\u0005mQBAA!\u0015\u0011\t\u0019%!\u0012\u0002\r\u00154g-Z2u\u0015\t\t9%\u0001\u0003dCR\u001c\u0018\u0002BA&\u0003\u0003\u0012!!S(\t\u000f\u0005]\u0002\u00031\u0001\u0002\f\u0005\t\"/\u001a;sS\u00164X\rU;cY&\u001c7*Z=\u0015\u0005\u0005MC\u0003BA\u001a\u0003+B\u0001\"a\u0016\u0012\t\u0003\u0007\u0011\u0011L\u0001\u0016[\u0006,H\u000f\u001b)vE2L7mS3z\r\u0016$8\r[3s!\u0015\t\u00131LA0\u0013\r\tiF\t\u0002\ty\tLh.Y7f}A!qFMA1!\u0011\t\u0019'a\u001b\u000e\u0005\u0005\u0015$\u0002BA4\u0003S\nQ!\\8eK2T!a\u000b<\n\t\u00055\u0014Q\r\u0002\r\u0011R$\bOU3ta>t7/Z\u0001\u0012O\u0016$(+Z9vKN$XK\u001d7QCRDG\u0003BA:\u0003\u0013\u0003B!!\u001e\u0002\u0004:!\u0011qOA@!\r\tIHI\u0007\u0003\u0003wR1!! \u001f\u0003\u0019a$o\\8u}%\u0019\u0011\u0011\u0011\u0012\u0002\rA\u0013X\rZ3g\u0013\u0011\t))a\"\u0003\rM#(/\u001b8h\u0015\r\t\tI\t\u0005\b\u0003o\u0011\u0002\u0019AA\u0006\u0001")
public class MauthPublicKeyProvider
implements ClientPublicKeyProvider<Future>,
StrictLogging {
    private final AuthenticatorConfiguration configuration;
    private final MAuthRequestSigner signer;
    private final ExecutionContext ec;
    private final ActorSystem system;
    private final Materializer materializer;
    private final ObjectMapper mapper;
    private final CachingSettings defaultCachingSettings;
    private final LfuCacheSettings lfuCacheSettings;
    private final Cache<UUID, Option<PublicKey>> cache;
    private Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public ObjectMapper mapper() {
        return this.mapper;
    }

    private CachingSettings defaultCachingSettings() {
        return this.defaultCachingSettings;
    }

    private LfuCacheSettings lfuCacheSettings() {
        return this.lfuCacheSettings;
    }

    private Cache<UUID, Option<PublicKey>> cache() {
        return this.cache;
    }

    public Future<Option<PublicKey>> getPublicKey(UUID appUUID) {
        return this.cache().getOrLoad((Object)appUUID, (Function1 & Serializable)x$1 -> {
            SignedRequest signedRequest = $this.signer.signRequest(UnsignedRequest$.MODULE$.noBody("GET", new URI(new StringBuilder(0).append($this.configuration.getBaseUrl()).append(this.getRequestUrlPath(appUUID)).toString()), Predef$.MODULE$.Map().empty()));
            return this.retrievePublicKey((Function0<Future<HttpResponse>>)(Function0 & Serializable)() -> HttpClient$.MODULE$.call(Implicits.NewSignedRequestOps$.MODULE$.toAkkaHttpRequest$extension(Implicits$.MODULE$.NewSignedRequestOps(signedRequest)), $this.system));
        });
    }

    public IO<Option<PublicKey>> getPublicKeyIO(UUID appUUID) {
        return IO$.MODULE$.fromFuture(IO$.MODULE$.apply((Function0 & Serializable)() -> this.getPublicKey(appUUID)));
    }

    public Future<Option<PublicKey>> retrievePublicKey(Function0<Future<HttpResponse>> mauthPublicKeyFetcher) {
        return ((Future)mauthPublicKeyFetcher.apply()).flatMap((Function1 & Serializable)response -> Unmarshal$.MODULE$.apply((Object)response.entity()).to(Unmarshaller$.MODULE$.stringUnmarshaller(), $this.ec, $this.materializer).map((Function1 & Serializable)body -> {
            BoxedUnit boxedUnit;
            StatusCode statusCode = response.status();
            StatusCodes.Success success = StatusCodes$.MODULE$.OK();
            if (!(statusCode != null ? !statusCode.equals(success) : success != null)) {
                Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> MAuthKeysHelper.getPublicKeyFromString((String)this.mapper().readTree(body).findValue("public_key_str").asText()));
                if (try_ instanceof Success) {
                    Success success2 = (Success)try_;
                    PublicKey publicKey = (PublicKey)success2.value();
                    return new Some((Object)publicKey);
                }
                if (try_ instanceof Failure) {
                    BoxedUnit boxedUnit2;
                    Failure failure = (Failure)try_;
                    Throwable error = failure.exception();
                    if (this.logger().underlying().isErrorEnabled()) {
                        this.logger().underlying().error("Converting string to Public Key failed", error);
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                    return None$.MODULE$;
                }
                throw new MatchError((Object)try_);
            }
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("Unexpected response returned by server -- status: {} response: {}", new Object[]{response.status(), body});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return None$.MODULE$;
        }, $this.ec).recover((PartialFunction)new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ MauthPublicKeyProvider $outer;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 != null) {
                    BoxedUnit boxedUnit;
                    A1 A12 = A1;
                    if (this.$outer.logger().underlying().isErrorEnabled()) {
                        this.$outer.logger().underlying().error("Request to get MAuth public key couldn't be signed", A12);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    return (B1)None$.MODULE$;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                return throwable != null;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, $this.ec), this.ec).recover((PartialFunction)new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ MauthPublicKeyProvider $outer;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                A1 A1 = x2;
                if (A1 != null) {
                    BoxedUnit boxedUnit;
                    A1 A12 = A1;
                    if (this.$outer.logger().underlying().isErrorEnabled()) {
                        this.$outer.logger().underlying().error("Request to get MAuth public key couldn't be completed", A12);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    return (B1)None$.MODULE$;
                }
                return (B1)function1.apply(x2);
            }

            public final boolean isDefinedAt(Throwable x2) {
                Throwable throwable = x2;
                return throwable != null;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.ec);
    }

    public String getRequestUrlPath(UUID appUUID) {
        return new StringBuilder(0).append(this.configuration.getRequestUrlPath()).append(String.format(this.configuration.getSecurityTokensUrlPath(), appUUID.toString())).toString();
    }

    public MauthPublicKeyProvider(AuthenticatorConfiguration configuration, MAuthRequestSigner signer, ExecutionContext ec, ActorSystem system, Materializer materializer) {
        this.configuration = configuration;
        this.signer = signer;
        this.ec = ec;
        this.system = system;
        this.materializer = materializer;
        StrictLogging.$init$((StrictLogging)this);
        this.mapper = new ObjectMapper();
        this.defaultCachingSettings = (CachingSettings)CachingSettings$.MODULE$.apply(system);
        this.lfuCacheSettings = this.defaultCachingSettings().lfuCacheSettings().withTimeToLive((Duration)new package.DurationLong(package$.MODULE$.DurationLong(configuration.getTimeToLive())).seconds());
        this.cache = LfuCache$.MODULE$.apply(this.defaultCachingSettings().withLfuCacheSettings(this.lfuCacheSettings()));
        Statics.releaseFence();
    }
}

