/*
 * Decompiled with CFR 0.152.
 */
package com.mdsol.mauth.akka.http;

import akka.http.javadsl.model.HttpHeader;
import akka.http.scaladsl.model.HttpEntity;
import akka.http.scaladsl.model.HttpRequest;
import akka.http.scaladsl.model.RequestEntity;
import akka.http.scaladsl.server.ConjunctionMagnet$;
import akka.http.scaladsl.server.Directive;
import akka.http.scaladsl.server.Directive$;
import akka.http.scaladsl.server.Directives$;
import akka.http.scaladsl.server.Rejection;
import akka.http.scaladsl.server.StandardRoute$;
import akka.http.scaladsl.server.directives.BasicDirectives$;
import akka.http.scaladsl.server.directives.FutureDirectives$;
import akka.http.scaladsl.server.directives.HeaderMagnet;
import akka.http.scaladsl.server.directives.HeaderMagnet$;
import akka.http.scaladsl.server.directives.RouteDirectives$;
import akka.http.scaladsl.server.util.Tuple$;
import akka.http.scaladsl.server.util.TupleOps;
import com.mdsol.mauth.MAuthRequest;
import com.mdsol.mauth.akka.http.AuthHeaderDetail;
import com.mdsol.mauth.akka.http.MauthHeaderValues;
import com.mdsol.mauth.akka.http.MdsolAuthFailedRejection$;
import com.mdsol.mauth.akka.http.MdsolAuthMalformedHeaderRejection;
import com.mdsol.mauth.akka.http.MdsolAuthMissingHeaderRejection;
import com.mdsol.mauth.http.HttpVerbOps$;
import com.mdsol.mauth.http.X;
import com.mdsol.mauth.http.X$minusMWS$minusAuthentication$;
import com.mdsol.mauth.http.X$minusMWS$minusTime$;
import com.mdsol.mauth.scaladsl.Authenticator;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import java.util.UUID;
import java.util.function.Function;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple1;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u0005=ea\u0002\b\u0010!\u0003\r\tA\u0007\u0005\u0006S\u0001!\tA\u000b\u0005\u0006]\u0001!\ta\f\u0005\bE\u0002\u0011\r\u0011\"\u0001d\u0011\u0015I\b\u0001\"\u0001{\u0011%\t\t\u0003\u0001b\u0001\n\u0003\t\u0019\u0003C\u0005\u00022\u0001\u0011\r\u0011\"\u0001\u00024!9\u0011q\b\u0001\u0005\n\u0005\u0005\u0003bBA'\u0001\u0011%\u0011q\n\u0005\b\u0003C\u0002A\u0011BA2\u0011\u001d\ti\u0007\u0001C\u0001\u0003_:q!a!\u0010\u0011\u0003\t)I\u0002\u0004\u000f\u001f!\u0005\u0011q\u0011\u0005\b\u0003\u0017cA\u0011AAG\u0005=i\u0015)\u001e;i\t&\u0014Xm\u0019;jm\u0016\u001c(B\u0001\t\u0012\u0003\u0011AG\u000f\u001e9\u000b\u0005I\u0019\u0012\u0001B1lW\u0006T!\u0001F\u000b\u0002\u000b5\fW\u000f\u001e5\u000b\u0005Y9\u0012!B7eg>d'\"\u0001\r\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001Y\u0012\u0005\u0005\u0002\u001d?5\tQDC\u0001\u001f\u0003\u0015\u00198-\u00197b\u0013\t\u0001SD\u0001\u0004B]f\u0014VM\u001a\t\u0003E\u001dj\u0011a\t\u0006\u0003I\u0015\nAb]2bY\u0006dwnZ4j]\u001eT!AJ\f\u0002\u0011QL\b/Z:bM\u0016L!\u0001K\u0012\u0003\u001bM#(/[2u\u0019><w-\u001b8h\u0003\u0019!\u0013N\\5uIQ\t1\u0006\u0005\u0002\u001dY%\u0011Q&\b\u0002\u0005+:LG/\u0001\u0007bkRDWM\u001c;jG\u0006$X\r\u0006\u00031\u0011Vk\u0006CA\u0019F\u001d\t\u0011$I\u0004\u00024\u007f9\u0011A\u0007\u0010\b\u0003kir!AN\u001d\u000e\u0003]R!\u0001O\r\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0011\u0012B\u0001\t<\u0015\u0005\u0011\u0012BA\u001f?\u0003!\u00198-\u00197bINd'B\u0001\t<\u0013\t\u0001\u0015)\u0001\u0004tKJ4XM\u001d\u0006\u0003{yJ!a\u0011#\u0002\u000fA\f7m[1hK*\u0011\u0001)Q\u0005\u0003\r\u001e\u0013!\u0002R5sK\u000e$\u0018N^31\u0015\t\u0019E\tC\u0003J\u0005\u0001\u000f!*A\u0007bkRDWM\u001c;jG\u0006$xN\u001d\t\u0004\u00176{U\"\u0001'\u000b\u0005u\u001a\u0012B\u0001(M\u00055\tU\u000f\u001e5f]RL7-\u0019;peB\u0011\u0001kU\u0007\u0002#*\u0011!+H\u0001\u000bG>t7-\u001e:sK:$\u0018B\u0001+R\u0005\u00191U\u000f^;sK\")aK\u0001a\u0002/\u00069A/[7f_V$\bC\u0001-\\\u001b\u0005I&B\u0001.R\u0003!!WO]1uS>t\u0017B\u0001/Z\u000591\u0015N\\5uK\u0012+(/\u0019;j_:DQA\u0018\u0002A\u0004}\u000b\u0001D]3rk\u0016\u001cHOV1mS\u0012\fG/[8o)&lWm\\;u!\tA\u0006-\u0003\u0002b3\nAA)\u001e:bi&|g.\u0001\u0010fqR\u0014\u0018m\u0019;NoN\fU\u000f\u001e5f]RL7-\u0019;j_:DU-\u00193feV\tA\rE\u00022K\u001eL!AZ$\u0003\u0015\u0011K'/Z2uSZ,\u0017\u0007\u0005\u0002iY:\u0011\u0011N\u001b\t\u0003muI!a[\u000f\u0002\rA\u0013X\rZ3g\u0013\tigN\u0001\u0004TiJLgn\u001a\u0006\u0003WvAca\u00019tiZ<\bC\u0001\u000fr\u0013\t\u0011XD\u0001\u0006eKB\u0014XmY1uK\u0012\fq!\\3tg\u0006<W-I\u0001v\u0003%\"\u0006.[:![\u0016$\bn\u001c3!SN\u0004cm\u001c:!\u001b\u0006,H\u000f\u001b\u0011Wc\u0001\u0002(o\u001c;pG>d\u0007e\u001c8ms\u0006)1/\u001b8dK\u0006\n\u00010A\u00034]Ar\u0003'\u0001\fiK\u0006$WM\u001d,bYV,')\u001f+za\u0016lEm]8m+\tYx\u0010F\u0002}\u0003#\u00012!M3~!\tqx\u0010\u0004\u0001\u0005\u000f\u0005\u0005AA1\u0001\u0002\u0004\t\tA+\u0005\u0003\u0002\u0006\u0005-\u0001c\u0001\u000f\u0002\b%\u0019\u0011\u0011B\u000f\u0003\u000f9{G\u000f[5oOB\u0019A$!\u0004\n\u0007\u0005=QDA\u0002B]fDq!a\u0005\u0005\u0001\u0004\t)\"\u0001\u0004nC\u001etW\r\u001e\t\u0006\u0003/\ti\"`\u0007\u0003\u00033Q1!a\u0007E\u0003)!\u0017N]3di&4Xm]\u0005\u0005\u0003?\tIB\u0001\u0007IK\u0006$WM]'bO:,G/\u0001\nfqR\u0014\u0018m\u0019;N\u0003V$\b\u000eS3bI\u0016\u0014XCAA\u0013!\u0011\tT-a\n\u0011\t\u0005%\u00121F\u0007\u0002\u001f%\u0019\u0011QF\b\u0003!\u0005+H\u000f\u001b%fC\u0012,'\u000fR3uC&d\u0007FB\u0003qgR4x/\u0001\u000bfqR\u0014\u0018m\u0019;NoN$\u0016.\\3IK\u0006$WM]\u000b\u0003\u0003k\u0001B!M3\u00028A\u0019A$!\u000f\n\u0007\u0005mRD\u0001\u0003M_:<\u0007F\u0002\u0004qgR4x/A\ffqR\u0014\u0018m\u0019;BkRD\u0007*Z1eKJ$U\r^1jYR!\u00111IA%!\u0015a\u0012QIA\u0014\u0013\r\t9%\b\u0002\u0007\u001fB$\u0018n\u001c8\t\r\u0005-s\u00011\u0001h\u0003\r\u0019HO]\u0001\u000fO\u0016$\u0018+^3ssN#(/\u001b8h)\r9\u0017\u0011\u000b\u0005\b\u0003'B\u0001\u0019AA+\u0003\r\u0011X-\u001d\t\u0005\u0003/\ni&\u0004\u0002\u0002Z)\u0019\u00111L!\u0002\u000b5|G-\u001a7\n\t\u0005}\u0013\u0011\f\u0002\f\u0011R$\bOU3rk\u0016\u001cH/\u0001\u000bfqR\u0014\u0018m\u0019;SKF,Xm\u001d;IK\u0006$WM\u001d\u000b\u0006O\u0006\u0015\u0014\u0011\u000e\u0005\b\u0003OJ\u0001\u0019AA+\u0003\u001d\u0011X-];fgRDa!a\u001b\n\u0001\u00049\u0017A\u00035fC\u0012,'OT1nK\u0006\u0011S\r\u001f;sC\u000e$H*\u0019;fgR\fU\u000f\u001e5f]RL7-\u0019;j_:DU-\u00193feN$B!!\u001d\u0002zA!\u0011'ZA:!\u0011\tI#!\u001e\n\u0007\u0005]tBA\tNCV$\b\u000eS3bI\u0016\u0014h+\u00197vKNDq!a\u001f\u000b\u0001\u0004\ti(\u0001\nwe=sG._!vi\",g\u000e^5dCR,\u0007c\u0001\u000f\u0002\u0000%\u0019\u0011\u0011Q\u000f\u0003\u000f\t{w\u000e\\3b]\u0006yQ*Q;uQ\u0012K'/Z2uSZ,7\u000fE\u0002\u0002*1\u0019B\u0001D\u000e\u0002\nB\u0019\u0011\u0011\u0006\u0001\u0002\rqJg.\u001b;?)\t\t)\t")
public interface MAuthDirectives
extends StrictLogging {
    public void com$mdsol$mauth$akka$http$MAuthDirectives$_setter_$extractMwsAuthenticationHeader_$eq(Directive<Tuple1<String>> var1);

    public void com$mdsol$mauth$akka$http$MAuthDirectives$_setter_$extractMAuthHeader_$eq(Directive<Tuple1<AuthHeaderDetail>> var1);

    public void com$mdsol$mauth$akka$http$MAuthDirectives$_setter_$extractMwsTimeHeader_$eq(Directive<Tuple1<Object>> var1);

    public static /* synthetic */ Directive authenticate$(MAuthDirectives $this, Authenticator authenticator, FiniteDuration timeout, Duration requestValidationTimeout) {
        return $this.authenticate((Authenticator<Future>)authenticator, timeout, requestValidationTimeout);
    }

    default public Directive<BoxedUnit> authenticate(Authenticator<Future> authenticator, FiniteDuration timeout, Duration requestValidationTimeout) {
        return Directive.SingleValueTransformers$.MODULE$.flatMap$extension(Directive$.MODULE$.SingleValueTransformers(this.extractLatestAuthenticationHeaders(authenticator.isV2OnlyAuthenticate())), (Function1 & Serializable)mauthHeaderValues -> (Directive)BasicDirectives$.MODULE$.toStrictEntity(timeout).$amp(ConjunctionMagnet$.MODULE$.fromDirective(Directive.SingleValueTransformers$.MODULE$.flatMap$extension(Directive$.MODULE$.SingleValueTransformers(BasicDirectives$.MODULE$.extractRequest()), (Function1 & Serializable)req -> {
            Directive directive;
            RequestEntity requestEntity = req.entity();
            if (requestEntity instanceof HttpEntity.Strict) {
                HttpEntity.Strict strict = (HttpEntity.Strict)requestEntity;
                MAuthRequest mAuthRequest = new MAuthRequest(mauthHeaderValues.authenticator(), (byte[])strict.data().toArray((ClassTag)ClassTag$.MODULE$.Byte()), HttpVerbOps$.MODULE$.httpVerb(req.method()), Long.toString(mauthHeaderValues.time()), req.uri().path().toString(), this.getQueryString((HttpRequest)req));
                if (!authenticator.isV2OnlyAuthenticate()) {
                    String xmwsAuthenticationHeader = this.extractRequestHeader((HttpRequest)req, "x-mws-authentication");
                    String xmwsTimeHeader = this.extractRequestHeader((HttpRequest)req, "x-mws-time");
                    if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(xmwsAuthenticationHeader)) && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(xmwsTimeHeader))) {
                        mAuthRequest.setXmwsSignature(xmwsAuthenticationHeader);
                        mAuthRequest.setXmwsTime(xmwsTimeHeader);
                    }
                }
                directive = Directive.SingleValueTransformers$.MODULE$.flatMap$extension(Directive$.MODULE$.SingleValueTransformers(FutureDirectives$.MODULE$.onComplete((Function0 & Serializable)() -> (Future)authenticator.authenticate(mAuthRequest, requestValidationTimeout))), (Function1 & Serializable)x0$1 -> {
                    Success success;
                    boolean bl;
                    Try try_ = x0$1;
                    if (try_ instanceof Success && (bl = BoxesRunTime.unboxToBoolean((Object)(success = (Success)try_).value()))) {
                        return BasicDirectives$.MODULE$.pass();
                    }
                    return StandardRoute$.MODULE$.toDirective(RouteDirectives$.MODULE$.reject((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Rejection[]{MdsolAuthFailedRejection$.MODULE$})), Tuple$.MODULE$.forUnit());
                }, Tuple$.MODULE$.forUnit());
            } else {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error("MAUTH: Non-Strict Entity in Request");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                directive = StandardRoute$.MODULE$.toDirective(RouteDirectives$.MODULE$.reject((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Rejection[]{MdsolAuthFailedRejection$.MODULE$})), Tuple$.MODULE$.forUnit());
            }
            Directive isAuthed = directive;
            return isAuthed;
        }, Tuple$.MODULE$.forUnit()), TupleOps.Join$.MODULE$.join0P())), Tuple$.MODULE$.forUnit());
    }

    public Directive<Tuple1<String>> extractMwsAuthenticationHeader();

    public static /* synthetic */ Directive headerValueByTypeMdsol$(MAuthDirectives $this, HeaderMagnet magnet) {
        return $this.headerValueByTypeMdsol(magnet);
    }

    default public <T> Directive<Tuple1<T>> headerValueByTypeMdsol(HeaderMagnet<T> magnet) {
        return Directives$.MODULE$.headerValuePF(magnet.extractPF()).$bar(StandardRoute$.MODULE$.toDirective(RouteDirectives$.MODULE$.reject((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Rejection[]{new MdsolAuthMissingHeaderRejection(magnet.headerName())})), Tuple$.MODULE$.forTuple1()));
    }

    public Directive<Tuple1<AuthHeaderDetail>> extractMAuthHeader();

    public Directive<Tuple1<Object>> extractMwsTimeHeader();

    private Option<AuthHeaderDetail> extractAuthHeaderDetail(String str) {
        BoxedUnit boxedUnit;
        if (str.startsWith("MWS ")) {
            BoxedUnit boxedUnit2;
            SeqOps seqOps;
            List list = Predef$.MODULE$.wrapRefArray((Object[])str.replaceFirst("MWS ", "").split(":")).toList();
            if (list != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.List().unapplySeq((SeqOps)list)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) == 0) {
                Some some;
                String uuid = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
                String hash = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
                try {
                    some = new Some((Object)new AuthHeaderDetail(UUID.fromString(uuid), hash));
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    Throwable throwable3 = throwable;
                    if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                        BoxedUnit boxedUnit3;
                        if (this.logger().underlying().isErrorEnabled()) {
                            this.logger().underlying().error(new StringBuilder(46).append("Bad format for UUID in authentication header: ").append(str).toString(), throwable2);
                            boxedUnit3 = BoxedUnit.UNIT;
                        } else {
                            boxedUnit3 = BoxedUnit.UNIT;
                        }
                        some = None$.MODULE$;
                    }
                    throw throwable;
                }
                return some;
            }
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("Bad format for authentication header: {}", (Object)str);
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            return None$.MODULE$;
        }
        if (this.logger().underlying().isErrorEnabled()) {
            this.logger().underlying().error("Bad format for authentication header: {}", (Object)str);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return None$.MODULE$;
    }

    private String getQueryString(HttpRequest req) {
        return (String)req.uri().rawQueryString().getOrElse((Function0 & Serializable)() -> "");
    }

    private String extractRequestHeader(HttpRequest request, String headerName) {
        Function<HttpHeader, String> f = new Function<HttpHeader, String>(null){

            public <V> Function<V, String> compose(Function<? super V, ? extends HttpHeader> x$1) {
                return Function.super.compose(x$1);
            }

            public <V> Function<HttpHeader, V> andThen(Function<? super String, ? extends V> x$1) {
                return Function.super.andThen(x$1);
            }

            public String apply(HttpHeader h) {
                return h.value();
            }
        };
        return request.getHeader(headerName).map(f).orElse("");
    }

    public static /* synthetic */ Directive extractLatestAuthenticationHeaders$(MAuthDirectives $this, boolean v2OnlyAuthenticate) {
        return $this.extractLatestAuthenticationHeaders(v2OnlyAuthenticate);
    }

    default public Directive<Tuple1<MauthHeaderValues>> extractLatestAuthenticationHeaders(boolean v2OnlyAuthenticate) {
        return Directive.SingleValueTransformers$.MODULE$.flatMap$extension(Directive$.MODULE$.SingleValueTransformers(BasicDirectives$.MODULE$.extractRequest()), (Function1 & Serializable)request -> {
            String authenticationHeaderStr = this.extractRequestHeader((HttpRequest)request, "mcc-authentication");
            if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(authenticationHeaderStr))) {
                String timeHeaderStr = this.extractRequestHeader((HttpRequest)request, "mcc-time");
                if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(timeHeaderStr))) {
                    Option option = Try$.MODULE$.apply((Function0)(JFunction0.mcJ.sp & Serializable)() -> StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(timeHeaderStr))).toOption();
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        long time = BoxesRunTime.unboxToLong((Object)some.value());
                        if (true) {
                            long l = time;
                            return BasicDirectives$.MODULE$.provide((Object)new MauthHeaderValues(authenticationHeaderStr, l));
                        }
                    }
                    if (None$.MODULE$.equals(option)) {
                        BoxedUnit boxedUnit;
                        String msg = new StringBuilder(44).append("mcc-time").append(" header supplied with bad format: [").append(timeHeaderStr).append("]").toString();
                        if (this.logger().underlying().isErrorEnabled()) {
                            this.logger().underlying().error(msg);
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        return StandardRoute$.MODULE$.toDirective(RouteDirectives$.MODULE$.reject((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Rejection[]{new MdsolAuthMalformedHeaderRejection("mcc-time", msg, (Option<Throwable>)None$.MODULE$)})), Tuple$.MODULE$.forTuple1());
                    }
                    throw new MatchError((Object)option);
                }
                return StandardRoute$.MODULE$.toDirective(RouteDirectives$.MODULE$.reject((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Rejection[]{new MdsolAuthMissingHeaderRejection("mcc-time")})), Tuple$.MODULE$.forTuple1());
            }
            if (!v2OnlyAuthenticate) {
                String authenticationHeaderStr2 = this.extractRequestHeader((HttpRequest)request, "x-mws-authentication");
                if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(authenticationHeaderStr2))) {
                    String timeHeaderStr = this.extractRequestHeader((HttpRequest)request, "x-mws-time");
                    if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(timeHeaderStr))) {
                        Option option = Try$.MODULE$.apply((Function0)(JFunction0.mcJ.sp & Serializable)() -> StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(timeHeaderStr))).toOption();
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            long time = BoxesRunTime.unboxToLong((Object)some.value());
                            if (true) {
                                long l = time;
                                return BasicDirectives$.MODULE$.provide((Object)new MauthHeaderValues(authenticationHeaderStr2, l));
                            }
                        }
                        if (None$.MODULE$.equals(option)) {
                            BoxedUnit boxedUnit;
                            String msg = new StringBuilder(46).append("x-mws-time").append(" header supplied with bad format: [").append(timeHeaderStr).append("]").toString();
                            if (this.logger().underlying().isErrorEnabled()) {
                                this.logger().underlying().error(msg);
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            return StandardRoute$.MODULE$.toDirective(RouteDirectives$.MODULE$.reject((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Rejection[]{new MdsolAuthMalformedHeaderRejection("x-mws-time", msg, (Option<Throwable>)None$.MODULE$)})), Tuple$.MODULE$.forTuple1());
                        }
                        throw new MatchError((Object)option);
                    }
                    return StandardRoute$.MODULE$.toDirective(RouteDirectives$.MODULE$.reject((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Rejection[]{new MdsolAuthMissingHeaderRejection("x-mws-time")})), Tuple$.MODULE$.forTuple1());
                }
                return StandardRoute$.MODULE$.toDirective(RouteDirectives$.MODULE$.reject((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Rejection[]{new MdsolAuthMissingHeaderRejection("x-mws-authentication")})), Tuple$.MODULE$.forTuple1());
            }
            return StandardRoute$.MODULE$.toDirective(RouteDirectives$.MODULE$.reject((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Rejection[]{new MdsolAuthMissingHeaderRejection("mcc-authentication")})), Tuple$.MODULE$.forTuple1());
        }, Tuple$.MODULE$.forTuple1());
    }

    public static void $init$(MAuthDirectives $this) {
        $this.com$mdsol$mauth$akka$http$MAuthDirectives$_setter_$extractMwsAuthenticationHeader_$eq((Directive<Tuple1<String>>)Directives$.MODULE$.headerValueByName(X$minusMWS$minusAuthentication$.MODULE$.name()));
        $this.com$mdsol$mauth$akka$http$MAuthDirectives$_setter_$extractMAuthHeader_$eq((Directive<Tuple1<AuthHeaderDetail>>)Directive.SingleValueTransformers$.MODULE$.flatMap$extension(Directive$.MODULE$.SingleValueTransformers($this.headerValueByTypeMdsol(HeaderMagnet$.MODULE$.fromUnitForModeledCustomHeader(BoxedUnit.UNIT, ClassTag$.MODULE$.apply(X.minusMWS.minusAuthentication.class), X$minusMWS$minusAuthentication$.MODULE$.implicitlyLocatableCompanion()))), (Function1 & Serializable)hdr -> {
            Some some;
            AuthHeaderDetail ahd;
            Option<AuthHeaderDetail> option = $this.extractAuthHeaderDetail(hdr.value());
            if (option instanceof Some && (ahd = (AuthHeaderDetail)(some = (Some)option).value()) != null) {
                AuthHeaderDetail authHeaderDetail = ahd;
                return BasicDirectives$.MODULE$.provide((Object)authHeaderDetail);
            }
            if (None$.MODULE$.equals(option)) {
                BoxedUnit boxedUnit;
                String msg = new StringBuilder(36).append(X$minusMWS$minusAuthentication$.MODULE$.name()).append(" header supplied with bad format: [").append(hdr.value()).append("]").toString();
                if ($this.logger().underlying().isErrorEnabled()) {
                    $this.logger().underlying().error(msg);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return StandardRoute$.MODULE$.toDirective(RouteDirectives$.MODULE$.reject((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Rejection[]{new MdsolAuthMalformedHeaderRejection(X$minusMWS$minusAuthentication$.MODULE$.name(), msg, (Option<Throwable>)None$.MODULE$)})), Tuple$.MODULE$.forTuple1());
            }
            throw new MatchError(option);
        }, Tuple$.MODULE$.forTuple1()));
        $this.com$mdsol$mauth$akka$http$MAuthDirectives$_setter_$extractMwsTimeHeader_$eq((Directive<Tuple1<Object>>)Directive.SingleValueTransformers$.MODULE$.flatMap$extension(Directive$.MODULE$.SingleValueTransformers($this.headerValueByTypeMdsol(HeaderMagnet$.MODULE$.fromUnitForModeledCustomHeader(BoxedUnit.UNIT, ClassTag$.MODULE$.apply(X.minusMWS.minusTime.class), X$minusMWS$minusTime$.MODULE$.implicitlyLocatableCompanion()))), (Function1 & Serializable)time -> {
            Option option = Try$.MODULE$.apply((Function0)(JFunction0.mcJ.sp & Serializable)() -> StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(time.value()))).toOption();
            if (option instanceof Some) {
                Some some = (Some)option;
                long t = BoxesRunTime.unboxToLong((Object)some.value());
                if (true) {
                    long l = t;
                    return BasicDirectives$.MODULE$.provide((Object)BoxesRunTime.boxToLong((long)l));
                }
            }
            if (None$.MODULE$.equals(option)) {
                BoxedUnit boxedUnit;
                String msg = new StringBuilder(36).append(X$minusMWS$minusTime$.MODULE$.name()).append(" header supplied with bad format: [").append(time.value()).append("]").toString();
                if ($this.logger().underlying().isErrorEnabled()) {
                    $this.logger().underlying().error(msg);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return StandardRoute$.MODULE$.toDirective(RouteDirectives$.MODULE$.reject((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Rejection[]{new MdsolAuthMalformedHeaderRejection(X$minusMWS$minusTime$.MODULE$.name(), msg, (Option<Throwable>)None$.MODULE$)})), Tuple$.MODULE$.forTuple1());
            }
            throw new MatchError((Object)option);
        }, Tuple$.MODULE$.forTuple1()));
    }
}

