/*
 * Decompiled with CFR 0.152.
 */
package com.mdsol.mauth.akka.http.utils;

import com.mdsol.mauth.CryptoError;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.UUID;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.encodings.PKCS1Encoding;
import org.bouncycastle.crypto.engines.RSAEngine;
import org.bouncycastle.crypto.util.PublicKeyFactory;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.UninitializedFieldError;
import scala.runtime.BoxedUnit;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class MAuthSignatureEngine$
implements StrictLogging {
    public static final MAuthSignatureEngine$ MODULE$ = new MAuthSignatureEngine$();
    private static Logger logger;
    private static volatile boolean bitmap$init$0;

    static {
        StrictLogging.$init$((StrictLogging)MODULE$);
    }

    public Logger logger() {
        if (!bitmap$init$0) {
            throw new UninitializedFieldError("Uninitialized field: MAuthSignatureEngine.scala: 19");
        }
        return logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        logger = x$1;
        bitmap$init$0 = true;
    }

    public String getEpochTime() {
        return Long.toString(System.currentTimeMillis() / 1000L);
    }

    public String buildSignature(UUID appUUID, String httpMethod, String resourceUrl, String body, String epochTime) {
        String signature = new StringBuilder(4).append(httpMethod).append("\n").append(resourceUrl).append("\n").append(body).append("\n").append(appUUID.toString()).append("\n").append(epochTime).toString();
        return signature;
    }

    public Either<CryptoError, byte[]> decryptFromBase64(String encDigestBase64, PublicKey publicKey) {
        Left left;
        try {
            byte[] encryptedDigest = Base64.decodeBase64((String)encDigestBase64);
            PKCS1Encoding decryptEngine = new PKCS1Encoding((AsymmetricBlockCipher)new RSAEngine());
            decryptEngine.init(false, (CipherParameters)PublicKeyFactory.createKey((byte[])publicKey.getEncoded()));
            byte[] decryptedDigest = decryptEngine.processBlock(encryptedDigest, 0, encryptedDigest.length);
            left = new Right((Object)decryptedDigest);
        }
        catch (IOException e) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(new StringBuilder(39).append("IOException decrypting the signature : ").append(e.getMessage()).toString(), (Throwable)e);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            left = new Left((Object)new CryptoError(new StringBuilder(39).append("IOException decrypting the signature : ").append(e.getMessage()).toString(), (Option)new Some((Object)e)));
        }
        catch (InvalidCipherTextException e) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(new StringBuilder(54).append("InvalidCipherTextException decrypting the signature : ").append(e.getMessage()).toString(), (Throwable)e);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            left = new Left((Object)new CryptoError(new StringBuilder(54).append("InvalidCipherTextException decrypting the signature : ").append(e.getMessage()).toString(), (Option)new Some((Object)e)));
        }
        return left;
    }

    public boolean compareDigests(String base64Header, PublicKey key, String signatureString) {
        Right right;
        byte[] headerDigest;
        CryptoError cryptoError;
        boolean bl = false;
        Left left = null;
        Either<CryptoError, byte[]> either = this.decryptFromBase64(base64Header, key);
        if (either instanceof Left) {
            bl = true;
            left = (Left)either;
            CryptoError cryptoError2 = (CryptoError)left.value();
            if (cryptoError2 != null) {
                String msg = cryptoError2.msg();
                Option option = cryptoError2.cause();
                if (option instanceof Some) {
                    BoxedUnit boxedUnit;
                    Some some = (Some)option;
                    Throwable e = (Throwable)some.value();
                    if (this.logger().underlying().isDebugEnabled()) {
                        this.logger().underlying().debug(new StringBuilder(3).append(msg).append(" : ").append(e.getMessage()).toString(), e);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    return false;
                }
            }
        }
        if (bl && (cryptoError = (CryptoError)left.value()) != null) {
            String msg = cryptoError.msg();
            Option option = cryptoError.cause();
            if (None$.MODULE$.equals(option)) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(msg);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return false;
            }
        }
        if (either instanceof Right && (headerDigest = (byte[])(right = (Right)either).value()) != null) {
            byte[] byArray = headerDigest;
            String newDigest = this.asHex(this.getDigest(signatureString));
            return Arrays.equals(newDigest.getBytes("UTF-8"), byArray);
        }
        throw new MatchError(either);
    }

    public byte[] getDigest(String signature) {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-512", "BC");
        return messageDigest.digest(signature.getBytes(StandardCharsets.UTF_8));
    }

    public String asHex(byte[] array) {
        return Hex.encodeHexString((byte[])array);
    }

    public byte[] fromHex(char[] array) {
        return Hex.decodeHex((char[])array);
    }

    private MAuthSignatureEngine$() {
    }
}

