/*
 * Decompiled with CFR 0.152.
 */
package com.mdsol.mauth.akka.http;

import com.mdsol.mauth.MAuthRequest;
import com.mdsol.mauth.MAuthVersion;
import com.mdsol.mauth.exception.MAuthValidationException;
import com.mdsol.mauth.scaladsl.Authenticator;
import com.mdsol.mauth.scaladsl.utils.ClientPublicKeyProvider;
import com.mdsol.mauth.util.EpochTimeProvider;
import com.mdsol.mauth.util.MAuthSignatureHelper;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.PublicKey;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.UninitializedFieldError;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005Uc\u0001\u0002\f\u0018\u0001\tB\u0001\"\u000e\u0001\u0003\u0006\u0004%\tA\u000e\u0005\t{\u0001\u0011\t\u0011)A\u0005o!Aa\b\u0001BC\u0002\u0013\u0005s\b\u0003\u0005G\u0001\t\u0005\t\u0015!\u0003A\u0011!9\u0005A!A!\u0002\u0013A\u0005\u0002C&\u0001\u0005\u000b\u0007I1\u0001'\t\u0011A\u0003!\u0011!Q\u0001\n5CQ!\u0015\u0001\u0005\u0002ICqA\u0017\u0001C\u0002\u0013\u00051\f\u0003\u0004e\u0001\u0001\u0006I\u0001\u0018\u0005\u0006#\u0002!\t!\u001a\u0005\bU\u0002\u0011\r\u0011\"\u0011l\u0011\u0019a\u0007\u0001)A\u0005\u0011\")Q\u000e\u0001C!]\"1q\u0010\u0001C\u0005\u0003\u0003Aq!!\u0002\u0001\t\u0013\t9\u0001C\u0004\u0002\u0018\u0001!I!!\u0007\t\u000f\u0005}\u0001\u0001\"\u0003\u0002\"!9\u0011\u0011\b\u0001\u0005\n\u0005m\u0002bBA!\u0001\u0011%\u00111\t\u0005\b\u0003\u0013\u0002A\u0011BA&\u0005Q\u0011V-];fgR\fU\u000f\u001e5f]RL7-\u0019;pe*\u0011\u0001$G\u0001\u0005QR$\bO\u0003\u0002\u001b7\u0005!\u0011m[6b\u0015\taR$A\u0003nCV$\bN\u0003\u0002\u001f?\u0005)Q\u000eZ:pY*\t\u0001%A\u0002d_6\u001c\u0001aE\u0002\u0001G%\u0002\"\u0001J\u0014\u000e\u0003\u0015R\u0011AJ\u0001\u0006g\u000e\fG.Y\u0005\u0003Q\u0015\u0012a!\u00118z%\u00164\u0007c\u0001\u0016._5\t1F\u0003\u0002-7\u0005A1oY1mC\u0012\u001cH.\u0003\u0002/W\ti\u0011)\u001e;iK:$\u0018nY1u_J\u0004\"\u0001M\u001a\u000e\u0003ER!AM\u0013\u0002\u0015\r|gnY;se\u0016tG/\u0003\u00025c\t1a)\u001e;ve\u0016\f\u0011\u0003];cY&\u001c7*Z=Qe>4\u0018\u000eZ3s+\u00059\u0004c\u0001\u001d<_5\t\u0011H\u0003\u0002;W\u0005)Q\u000f^5mg&\u0011A(\u000f\u0002\u0018\u00072LWM\u001c;Qk\nd\u0017nY&fsB\u0013xN^5eKJ\f!\u0003];cY&\u001c7*Z=Qe>4\u0018\u000eZ3sA\u0005\tR\r]8dQRKW.\u001a)s_ZLG-\u001a:\u0016\u0003\u0001\u0003\"!\u0011#\u000e\u0003\tS!aQ\u000e\u0002\tU$\u0018\u000e\\\u0005\u0003\u000b\n\u0013\u0011#\u00129pG\"$\u0016.\\3Qe>4\u0018\u000eZ3s\u0003I)\u0007o\\2i)&lW\r\u0015:pm&$WM\u001d\u0011\u0002%Y\u0014tJ\u001c7z\u0003V$\b.\u001a8uS\u000e\fG/\u001a\t\u0003I%K!AS\u0013\u0003\u000f\t{w\u000e\\3b]\u0006\u0001R\r_3dkRLwN\\\"p]R,\u0007\u0010^\u000b\u0002\u001bB\u0011\u0001GT\u0005\u0003\u001fF\u0012\u0001#\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0002#\u0015DXmY;uS>t7i\u001c8uKb$\b%\u0001\u0004=S:LGO\u0010\u000b\u0005'^C\u0016\f\u0006\u0002U-B\u0011Q\u000bA\u0007\u0002/!)1\n\u0003a\u0002\u001b\")Q\u0007\u0003a\u0001o!)a\b\u0003a\u0001\u0001\")q\t\u0003a\u0001\u0011\u00061An\\4hKJ,\u0012\u0001\u0018\t\u0003;\nl\u0011A\u0018\u0006\u0003?\u0002\fQa\u001d7gi)T\u0011!Y\u0001\u0004_J<\u0017BA2_\u0005\u0019aunZ4fe\u00069An\\4hKJ\u0004Cc\u00014iSR\u0011Ak\u001a\u0005\u0006\u0017.\u0001\u001d!\u0014\u0005\u0006k-\u0001\ra\u000e\u0005\u0006}-\u0001\r\u0001Q\u0001\u0015SN4&g\u00148ms\u0006+H\u000f[3oi&\u001c\u0017\r^3\u0016\u0003!\u000bQ#[:We=sG._!vi\",g\u000e^5dCR,\u0007%\u0001\u0007bkRDWM\u001c;jG\u0006$X\r\u0006\u0002psR\u0011\u0001/\u001d\t\u0004aMB\u0005\"\u0002:\u000f\u0001\b\u0019\u0018\u0001\u0007:fcV,7\u000f\u001e,bY&$\u0017\r^5p]RKW.Z8viB\u0011Ao^\u0007\u0002k*\u0011a/M\u0001\tIV\u0014\u0018\r^5p]&\u0011\u00010\u001e\u0002\t\tV\u0014\u0018\r^5p]\")!P\u0004a\u0001w\u0006aQ.Q;uQJ+\u0017/^3tiB\u0011A0`\u0007\u00027%\u0011ap\u0007\u0002\r\u001b\u0006+H\u000f\u001b*fcV,7\u000f^\u0001\rO\u0016$\b+\u001e2mS\u000e\\U-\u001f\u000b\u0004a\u0006\r\u0001\"\u0002>\u0010\u0001\u0004Y\u0018\u0001\u0004<bY&$\u0017\r^3US6,G\u0003BA\u0005\u0003\u001b!2\u0001SA\u0006\u0011\u0015\u0011\b\u00031\u0001t\u0011\u001d\ty\u0001\u0005a\u0001\u0003#\t1B]3rk\u0016\u001cH\u000fV5nKB\u0019A%a\u0005\n\u0007\u0005UQE\u0001\u0003M_:<\u0017\u0001\u0006<bY&$\u0017\r^3NCV$\bNV3sg&|g\u000eF\u0003I\u00037\ti\u0002C\u0003{#\u0001\u00071\u0010C\u0003H#\u0001\u0007\u0001*A\nwC2LG-\u0019;f'&<g.\u0019;ve\u00164\u0016\u0007F\u0003I\u0003G\t)\u0003C\u0003{%\u0001\u00071\u0010C\u0004\u0002(I\u0001\r!!\u000b\u0002\u001f\rd\u0017.\u001a8u!V\u0014G.[2LKf\u0004B!a\u000b\u000265\u0011\u0011Q\u0006\u0006\u0005\u0003_\t\t$\u0001\u0005tK\u000e,(/\u001b;z\u0015\t\t\u0019$\u0001\u0003kCZ\f\u0017\u0002BA\u001c\u0003[\u0011\u0011\u0002U;cY&\u001c7*Z=\u0002'Y\fG.\u001b3bi\u0016\u001c\u0016n\u001a8biV\u0014XM\u0016\u001a\u0015\u000b!\u000bi$a\u0010\t\u000bi\u001c\u0002\u0019A>\t\u000f\u0005\u001d2\u00031\u0001\u0002*\u0005Yb-\u00197mE\u0006\u001c7NV1mS\u0012\fG/Z*jO:\fG/\u001e:f-F\"R\u0001SA#\u0003\u000fBQA\u001f\u000bA\u0002mDq!a\n\u0015\u0001\u0004\tI#\u0001\rm_\u001e\fU\u000f\u001e5f]RL7-\u0019;j_:\u0014V-];fgR$B!!\u0014\u0002TA\u0019A%a\u0014\n\u0007\u0005ESE\u0001\u0003V]&$\b\"\u0002>\u0016\u0001\u0004Y\b")
public class RequestAuthenticator
implements Authenticator<Future> {
    private final ClientPublicKeyProvider<Future> publicKeyProvider;
    private final EpochTimeProvider epochTimeProvider;
    private final boolean v2OnlyAuthenticate;
    private final ExecutionContext executionContext;
    private final Logger logger;
    private final boolean isV2OnlyAuthenticate;
    private volatile byte bitmap$init$0;

    public ClientPublicKeyProvider<Future> publicKeyProvider() {
        return this.publicKeyProvider;
    }

    public EpochTimeProvider epochTimeProvider() {
        return this.epochTimeProvider;
    }

    public ExecutionContext executionContext() {
        return this.executionContext;
    }

    public Logger logger() {
        if ((byte)(this.bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: RequestAuthenticator.scala: 23");
        }
        return this.logger;
    }

    public boolean isV2OnlyAuthenticate() {
        if ((byte)(this.bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: RequestAuthenticator.scala: 32");
        }
        return this.isV2OnlyAuthenticate;
    }

    public Future<Object> authenticate(MAuthRequest mAuthRequest, Duration requestValidationTimeout) {
        Promise promise;
        Promise promise2 = Promise$.MODULE$.apply();
        if (!this.validateTime(mAuthRequest.getRequestTime(), requestValidationTimeout)) {
            String message = new StringBuilder(51).append("MAuth request validation failed because of timeout ").append(requestValidationTimeout).toString();
            this.logger().error(message);
            promise = promise2.failure((Throwable)new MAuthValidationException(message));
        } else if (!this.validateMauthVersion(mAuthRequest, this.v2OnlyAuthenticate)) {
            String message = "The service requires mAuth v2 authentication headers.";
            this.logger().error(message);
            promise = promise2.failure((Throwable)new MAuthValidationException(message));
        } else {
            promise = promise2.completeWith(this.getPublicKey(mAuthRequest));
        }
        return promise2.future();
    }

    private Future<Object> getPublicKey(MAuthRequest mAuthRequest) {
        return ((Future)this.publicKeyProvider().getPublicKey(mAuthRequest.getAppUUID())).map((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)RequestAuthenticator.$anonfun$getPublicKey$1(this, mAuthRequest, x0$1)), this.executionContext());
    }

    private boolean validateTime(long requestTime, Duration requestValidationTimeout) {
        return this.epochTimeProvider().inSeconds() - requestTime < requestValidationTimeout.toSeconds();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean validateMauthVersion(MAuthRequest mAuthRequest, boolean v2OnlyAuthenticate) {
        if (!v2OnlyAuthenticate) return true;
        MAuthVersion mAuthVersion = mAuthRequest.getMauthVersion();
        MAuthVersion mAuthVersion2 = MAuthVersion.MWSV2;
        if (mAuthVersion != null) {
            if (!mAuthVersion.equals(mAuthVersion2)) return false;
            return true;
        }
        if (mAuthVersion2 == null) return true;
        return false;
    }

    private boolean validateSignatureV1(MAuthRequest mAuthRequest, PublicKey clientPublicKey) {
        boolean bl;
        this.logAuthenticationRequest(mAuthRequest);
        byte[] decryptedSignature = MAuthSignatureHelper.decryptSignature((PublicKey)clientPublicKey, (String)mAuthRequest.getRequestSignature());
        try {
            byte[] messageDigest_bytes = MAuthSignatureHelper.generateDigestedMessageV1((MAuthRequest)mAuthRequest).getBytes(StandardCharsets.UTF_8);
            bl = Arrays.equals(messageDigest_bytes, decryptedSignature);
        }
        catch (Exception ex) {
            String message = "MAuth request validation failed for V1.";
            this.logger().error(message, (Throwable)ex);
            throw new MAuthValidationException(message, (Throwable)ex);
        }
        return bl;
    }

    private boolean validateSignatureV2(MAuthRequest mAuthRequest, PublicKey clientPublicKey) {
        boolean bl;
        this.logAuthenticationRequest(mAuthRequest);
        String unencryptedRequestString = MAuthSignatureHelper.generateStringToSignV2((MAuthRequest)mAuthRequest);
        try {
            bl = MAuthSignatureHelper.verifyRSA((String)unencryptedRequestString, (String)mAuthRequest.getRequestSignature(), (PublicKey)clientPublicKey);
        }
        catch (Exception ex) {
            String message = "MAuth request validation failed for V2.";
            this.logger().error(message, (Throwable)ex);
            throw new MAuthValidationException(message, (Throwable)ex);
        }
        return bl;
    }

    private boolean fallbackValidateSignatureV1(MAuthRequest mAuthRequest, PublicKey clientPublicKey) {
        boolean isValidated;
        block1: {
            MAuthRequest mAuthRequestV1;
            block0: {
                isValidated = false;
                if (mAuthRequest.getMessagePayload() != null) break block0;
                this.logger().warn("V1 authentication fallback is not available because the full request body is not available in memory.");
                break block1;
            }
            if (mAuthRequest.getXmwsSignature() == null || mAuthRequest.getXmwsTime() == null || !(isValidated = this.validateSignatureV1(mAuthRequestV1 = new MAuthRequest(mAuthRequest.getXmwsSignature(), mAuthRequest.getMessagePayload(), mAuthRequest.getHttpMethod(), mAuthRequest.getXmwsTime(), mAuthRequest.getResourcePath(), mAuthRequest.getQueryParameters()), clientPublicKey))) break block1;
            this.logger().warn("Completed successful authentication attempt after fallback to V1");
        }
        return isValidated;
    }

    private void logAuthenticationRequest(MAuthRequest mAuthRequest) {
        String msgFormat = "Mauth-client attempting to authenticate request from app with mauth app uuid %s using version %s.";
        this.logger().info(String.format(msgFormat, mAuthRequest.getAppUUID(), mAuthRequest.getMauthVersion().getValue()));
    }

    public static final /* synthetic */ boolean $anonfun$getPublicKey$1(RequestAuthenticator $this, MAuthRequest mAuthRequest$1, Option x0$1) {
        Option option = x0$1;
        if (None$.MODULE$.equals(option)) {
            $this.logger().error("Public Key couldn't be retrieved");
            return false;
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            PublicKey clientPublicKey = (PublicKey)some.value();
            MAuthVersion mAuthVersion = mAuthRequest$1.getMauthVersion();
            if (MAuthVersion.MWS.equals(mAuthVersion)) {
                $this.logger().warn("MAuth v1 client was used to authenticate this request which is deprecated");
                return $this.validateSignatureV1(mAuthRequest$1, clientPublicKey);
            }
            if (MAuthVersion.MWSV2.equals(mAuthVersion)) {
                boolean v2IsValidated = $this.validateSignatureV2(mAuthRequest$1, clientPublicKey);
                if ($this.v2OnlyAuthenticate) {
                    return v2IsValidated;
                }
                if (v2IsValidated) {
                    return v2IsValidated;
                }
                return $this.fallbackValidateSignatureV1(mAuthRequest$1, clientPublicKey);
            }
            throw new MatchError((Object)mAuthVersion);
        }
        throw new MatchError((Object)option);
    }

    public RequestAuthenticator(ClientPublicKeyProvider<Future> publicKeyProvider, EpochTimeProvider epochTimeProvider, boolean v2OnlyAuthenticate, ExecutionContext executionContext) {
        this.publicKeyProvider = publicKeyProvider;
        this.epochTimeProvider = epochTimeProvider;
        this.v2OnlyAuthenticate = v2OnlyAuthenticate;
        this.executionContext = executionContext;
        this.logger = LoggerFactory.getLogger(RequestAuthenticator.class);
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        this.isV2OnlyAuthenticate = v2OnlyAuthenticate;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
    }

    public RequestAuthenticator(ClientPublicKeyProvider<Future> publicKeyProvider, EpochTimeProvider epochTimeProvider, ExecutionContext executionContext) {
        this(publicKeyProvider, epochTimeProvider, false, executionContext);
    }
}

