/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.bouncycastle.bcpg.BCPGKey;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.ContainedPacket;
import org.bouncycastle.bcpg.DSAPublicBCPGKey;
import org.bouncycastle.bcpg.ECPublicBCPGKey;
import org.bouncycastle.bcpg.ElGamalPublicBCPGKey;
import org.bouncycastle.bcpg.PublicKeyAlgorithmTags;
import org.bouncycastle.bcpg.PublicKeyPacket;
import org.bouncycastle.bcpg.RSAPublicBCPGKey;
import org.bouncycastle.bcpg.TrustPacket;
import org.bouncycastle.bcpg.UserAttributePacket;
import org.bouncycastle.bcpg.UserIDPacket;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import org.bouncycastle.openpgp.PGPUserAttributeSubpacketVector;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.util.Arrays;

public class PGPPublicKey
implements PublicKeyAlgorithmTags {
    private static final int[] MASTER_KEY_CERTIFICATION_TYPES = new int[]{19, 18, 17, 16};
    PublicKeyPacket publicPk;
    TrustPacket trustPk;
    List keySigs = new ArrayList();
    List ids = new ArrayList();
    List idTrusts = new ArrayList();
    List idSigs = new ArrayList();
    List subSigs = null;
    private long keyID;
    private byte[] fingerprint;
    private int keyStrength;

    private void init(KeyFingerPrintCalculator fingerPrintCalculator) throws PGPException {
        BCPGKey key = this.publicPk.getKey();
        this.fingerprint = fingerPrintCalculator.calculateFingerprint(this.publicPk);
        if (this.publicPk.getVersion() <= 3) {
            RSAPublicBCPGKey rK = (RSAPublicBCPGKey)key;
            this.keyID = rK.getModulus().longValue();
            this.keyStrength = rK.getModulus().bitLength();
        } else {
            this.keyID = (long)(this.fingerprint[this.fingerprint.length - 8] & 0xFF) << 56 | (long)(this.fingerprint[this.fingerprint.length - 7] & 0xFF) << 48 | (long)(this.fingerprint[this.fingerprint.length - 6] & 0xFF) << 40 | (long)(this.fingerprint[this.fingerprint.length - 5] & 0xFF) << 32 | (long)(this.fingerprint[this.fingerprint.length - 4] & 0xFF) << 24 | (long)(this.fingerprint[this.fingerprint.length - 3] & 0xFF) << 16 | (long)(this.fingerprint[this.fingerprint.length - 2] & 0xFF) << 8 | (long)(this.fingerprint[this.fingerprint.length - 1] & 0xFF);
            if (key instanceof RSAPublicBCPGKey) {
                this.keyStrength = ((RSAPublicBCPGKey)key).getModulus().bitLength();
            } else if (key instanceof DSAPublicBCPGKey) {
                this.keyStrength = ((DSAPublicBCPGKey)key).getP().bitLength();
            } else if (key instanceof ElGamalPublicBCPGKey) {
                this.keyStrength = ((ElGamalPublicBCPGKey)key).getP().bitLength();
            } else if (key instanceof ECPublicBCPGKey) {
                this.keyStrength = ECNamedCurveTable.getByOID(((ECPublicBCPGKey)key).getCurveOID()).getCurve().getFieldSize();
            }
        }
    }

    public PGPPublicKey(PublicKeyPacket publicKeyPacket, KeyFingerPrintCalculator fingerPrintCalculator) throws PGPException {
        this.publicPk = publicKeyPacket;
        this.ids = new ArrayList();
        this.idSigs = new ArrayList();
        this.init(fingerPrintCalculator);
    }

    PGPPublicKey(PublicKeyPacket publicPk, TrustPacket trustPk, List sigs, KeyFingerPrintCalculator fingerPrintCalculator) throws PGPException {
        this.publicPk = publicPk;
        this.trustPk = trustPk;
        this.subSigs = sigs;
        this.init(fingerPrintCalculator);
    }

    PGPPublicKey(PGPPublicKey key, TrustPacket trust, List subSigs) {
        this.publicPk = key.publicPk;
        this.trustPk = trust;
        this.subSigs = subSigs;
        this.fingerprint = key.fingerprint;
        this.keyID = key.keyID;
        this.keyStrength = key.keyStrength;
    }

    PGPPublicKey(PGPPublicKey pubKey) {
        this.publicPk = pubKey.publicPk;
        this.keySigs = new ArrayList(pubKey.keySigs);
        this.ids = new ArrayList(pubKey.ids);
        this.idTrusts = new ArrayList(pubKey.idTrusts);
        this.idSigs = new ArrayList(pubKey.idSigs.size());
        int i = 0;
        while (i != pubKey.idSigs.size()) {
            this.idSigs.add(new ArrayList((ArrayList)pubKey.idSigs.get(i)));
            ++i;
        }
        if (pubKey.subSigs != null) {
            this.subSigs = new ArrayList(pubKey.subSigs.size());
            i = 0;
            while (i != pubKey.subSigs.size()) {
                this.subSigs.add(pubKey.subSigs.get(i));
                ++i;
            }
        }
        this.fingerprint = pubKey.fingerprint;
        this.keyID = pubKey.keyID;
        this.keyStrength = pubKey.keyStrength;
    }

    PGPPublicKey(PublicKeyPacket publicPk, TrustPacket trustPk, List keySigs, List ids, List idTrusts, List idSigs, KeyFingerPrintCalculator fingerPrintCalculator) throws PGPException {
        this.publicPk = publicPk;
        this.trustPk = trustPk;
        this.keySigs = keySigs;
        this.ids = ids;
        this.idTrusts = idTrusts;
        this.idSigs = idSigs;
        this.init(fingerPrintCalculator);
    }

    public int getVersion() {
        return this.publicPk.getVersion();
    }

    public Date getCreationTime() {
        return this.publicPk.getTime();
    }

    public int getValidDays() {
        if (this.publicPk.getVersion() > 3) {
            long delta = this.getValidSeconds() % 86400L;
            int days = (int)(this.getValidSeconds() / 86400L);
            if (delta > 0L && days == 0) {
                return 1;
            }
            return days;
        }
        return this.publicPk.getValidDays();
    }

    public byte[] getTrustData() {
        if (this.trustPk == null) {
            return null;
        }
        return Arrays.clone(this.trustPk.getLevelAndTrustAmount());
    }

    public long getValidSeconds() {
        if (this.publicPk.getVersion() > 3) {
            if (this.isMasterKey()) {
                int i = 0;
                while (i != MASTER_KEY_CERTIFICATION_TYPES.length) {
                    long seconds = this.getExpirationTimeFromSig(true, MASTER_KEY_CERTIFICATION_TYPES[i]);
                    if (seconds >= 0L) {
                        return seconds;
                    }
                    ++i;
                }
            } else {
                long seconds = this.getExpirationTimeFromSig(false, 24);
                if (seconds >= 0L) {
                    return seconds;
                }
            }
            return 0L;
        }
        return (long)this.publicPk.getValidDays() * 24L * 60L * 60L;
    }

    private long getExpirationTimeFromSig(boolean selfSigned, int signatureType) {
        Iterator signatures = this.getSignaturesOfType(signatureType);
        long expiryTime = -1L;
        while (signatures.hasNext()) {
            PGPSignature sig = (PGPSignature)signatures.next();
            if (selfSigned && sig.getKeyID() != this.getKeyID()) continue;
            PGPSignatureSubpacketVector hashed = sig.getHashedSubPackets();
            if (hashed != null) {
                long current = hashed.getKeyExpirationTime();
                if (current != 0L && current <= expiryTime) continue;
                expiryTime = current;
                continue;
            }
            return 0L;
        }
        return expiryTime;
    }

    public long getKeyID() {
        return this.keyID;
    }

    public byte[] getFingerprint() {
        byte[] tmp = new byte[this.fingerprint.length];
        System.arraycopy(this.fingerprint, 0, tmp, 0, tmp.length);
        return tmp;
    }

    public boolean isEncryptionKey() {
        int algorithm = this.publicPk.getAlgorithm();
        return algorithm == 1 || algorithm == 2 || algorithm == 16 || algorithm == 20 || algorithm == 18;
    }

    public boolean isMasterKey() {
        return this.subSigs == null;
    }

    public int getAlgorithm() {
        return this.publicPk.getAlgorithm();
    }

    public int getBitStrength() {
        return this.keyStrength;
    }

    public Iterator getUserIDs() {
        ArrayList<String> temp = new ArrayList<String>();
        int i = 0;
        while (i != this.ids.size()) {
            if (this.ids.get(i) instanceof UserIDPacket) {
                temp.add(((UserIDPacket)this.ids.get(i)).getID());
            }
            ++i;
        }
        return temp.iterator();
    }

    public Iterator getRawUserIDs() {
        ArrayList<byte[]> temp = new ArrayList<byte[]>();
        int i = 0;
        while (i != this.ids.size()) {
            if (this.ids.get(i) instanceof UserIDPacket) {
                temp.add(((UserIDPacket)this.ids.get(i)).getRawID());
            }
            ++i;
        }
        return temp.iterator();
    }

    public Iterator getUserAttributes() {
        ArrayList temp = new ArrayList();
        int i = 0;
        while (i != this.ids.size()) {
            if (this.ids.get(i) instanceof PGPUserAttributeSubpacketVector) {
                temp.add(this.ids.get(i));
            }
            ++i;
        }
        return temp.iterator();
    }

    public Iterator getSignaturesForID(String id) {
        return this.getSignaturesForID(new UserIDPacket(id));
    }

    public Iterator getSignaturesForID(byte[] rawID) {
        return this.getSignaturesForID(new UserIDPacket(rawID));
    }

    private Iterator getSignaturesForID(UserIDPacket id) {
        int i = 0;
        while (i != this.ids.size()) {
            if (id.equals(this.ids.get(i))) {
                return ((ArrayList)this.idSigs.get(i)).iterator();
            }
            ++i;
        }
        return null;
    }

    public Iterator getSignaturesForUserAttribute(PGPUserAttributeSubpacketVector userAttributes) {
        int i = 0;
        while (i != this.ids.size()) {
            if (userAttributes.equals(this.ids.get(i))) {
                return ((ArrayList)this.idSigs.get(i)).iterator();
            }
            ++i;
        }
        return null;
    }

    public Iterator getSignaturesOfType(int signatureType) {
        ArrayList<PGPSignature> l = new ArrayList<PGPSignature>();
        Iterator it = this.getSignatures();
        while (it.hasNext()) {
            PGPSignature sig = (PGPSignature)it.next();
            if (sig.getSignatureType() != signatureType) continue;
            l.add(sig);
        }
        return l.iterator();
    }

    public Iterator getSignatures() {
        if (this.subSigs == null) {
            ArrayList sigs = new ArrayList();
            sigs.addAll(this.keySigs);
            int i = 0;
            while (i != this.idSigs.size()) {
                sigs.addAll((Collection)this.idSigs.get(i));
                ++i;
            }
            return sigs.iterator();
        }
        return this.subSigs.iterator();
    }

    public Iterator getKeySignatures() {
        if (this.subSigs == null) {
            ArrayList sigs = new ArrayList();
            sigs.addAll(this.keySigs);
            return sigs.iterator();
        }
        return this.subSigs.iterator();
    }

    public PublicKeyPacket getPublicKeyPacket() {
        return this.publicPk;
    }

    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        this.encode(bOut);
        return bOut.toByteArray();
    }

    public void encode(OutputStream outStream) throws IOException {
        BCPGOutputStream out = outStream instanceof BCPGOutputStream ? (BCPGOutputStream)outStream : new BCPGOutputStream(outStream);
        out.writePacket(this.publicPk);
        if (this.trustPk != null) {
            out.writePacket(this.trustPk);
        }
        if (this.subSigs == null) {
            int i = 0;
            while (i != this.keySigs.size()) {
                ((PGPSignature)this.keySigs.get(i)).encode(out);
                ++i;
            }
            i = 0;
            while (i != this.ids.size()) {
                if (this.ids.get(i) instanceof UserIDPacket) {
                    UserIDPacket id = (UserIDPacket)this.ids.get(i);
                    out.writePacket(id);
                } else {
                    PGPUserAttributeSubpacketVector v = (PGPUserAttributeSubpacketVector)this.ids.get(i);
                    out.writePacket(new UserAttributePacket(v.toSubpacketArray()));
                }
                if (this.idTrusts.get(i) != null) {
                    out.writePacket((ContainedPacket)this.idTrusts.get(i));
                }
                List sigs = (List)this.idSigs.get(i);
                int j = 0;
                while (j != sigs.size()) {
                    ((PGPSignature)sigs.get(j)).encode(out);
                    ++j;
                }
                ++i;
            }
        } else {
            int j = 0;
            while (j != this.subSigs.size()) {
                ((PGPSignature)this.subSigs.get(j)).encode(out);
                ++j;
            }
        }
    }

    public boolean isRevoked() {
        return this.hasRevocation();
    }

    /*
     * Unable to fully structure code
     */
    public boolean hasRevocation() {
        block2: {
            ns = 0;
            revoked = false;
            if (!this.isMasterKey()) ** GOTO lbl11
            while (!revoked && ns < this.keySigs.size()) {
                if (((PGPSignature)this.keySigs.get(ns++)).getSignatureType() != 32) continue;
                revoked = true;
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                if (((PGPSignature)this.subSigs.get(ns++)).getSignatureType() != 40) continue;
                revoked = true;
lbl11:
                // 3 sources

                ** while (!revoked && ns < this.subSigs.size())
            }
        }
        return revoked;
    }

    public static PGPPublicKey addCertification(PGPPublicKey key, byte[] rawID, PGPSignature certification) {
        return PGPPublicKey.addCert(key, new UserIDPacket(rawID), certification);
    }

    public static PGPPublicKey addCertification(PGPPublicKey key, String id, PGPSignature certification) {
        return PGPPublicKey.addCert(key, new UserIDPacket(id), certification);
    }

    public static PGPPublicKey addCertification(PGPPublicKey key, PGPUserAttributeSubpacketVector userAttributes, PGPSignature certification) {
        return PGPPublicKey.addCert(key, userAttributes, certification);
    }

    private static PGPPublicKey addCert(PGPPublicKey key, Object id, PGPSignature certification) {
        PGPPublicKey returnKey = new PGPPublicKey(key);
        List<PGPSignature> sigList = null;
        int i = 0;
        while (i != returnKey.ids.size()) {
            if (id.equals(returnKey.ids.get(i))) {
                sigList = (List)returnKey.idSigs.get(i);
            }
            ++i;
        }
        if (sigList != null) {
            sigList.add(certification);
        } else {
            sigList = new ArrayList<PGPSignature>();
            sigList.add(certification);
            returnKey.ids.add(id);
            returnKey.idTrusts.add(null);
            returnKey.idSigs.add(sigList);
        }
        return returnKey;
    }

    public static PGPPublicKey removeCertification(PGPPublicKey key, PGPUserAttributeSubpacketVector userAttributes) {
        return PGPPublicKey.removeCert(key, userAttributes);
    }

    public static PGPPublicKey removeCertification(PGPPublicKey key, String id) {
        return PGPPublicKey.removeCert(key, new UserIDPacket(id));
    }

    public static PGPPublicKey removeCertification(PGPPublicKey key, byte[] rawID) {
        return PGPPublicKey.removeCert(key, new UserIDPacket(rawID));
    }

    private static PGPPublicKey removeCert(PGPPublicKey key, Object id) {
        PGPPublicKey returnKey = new PGPPublicKey(key);
        boolean found = false;
        int i = 0;
        while (i < returnKey.ids.size()) {
            if (id.equals(returnKey.ids.get(i))) {
                found = true;
                returnKey.ids.remove(i);
                returnKey.idTrusts.remove(i);
                returnKey.idSigs.remove(i);
            }
            ++i;
        }
        if (!found) {
            return null;
        }
        return returnKey;
    }

    public static PGPPublicKey removeCertification(PGPPublicKey key, byte[] id, PGPSignature certification) {
        return PGPPublicKey.removeCert(key, new UserIDPacket(id), certification);
    }

    public static PGPPublicKey removeCertification(PGPPublicKey key, String id, PGPSignature certification) {
        return PGPPublicKey.removeCert(key, new UserIDPacket(id), certification);
    }

    public static PGPPublicKey removeCertification(PGPPublicKey key, PGPUserAttributeSubpacketVector userAttributes, PGPSignature certification) {
        return PGPPublicKey.removeCert(key, userAttributes, certification);
    }

    private static PGPPublicKey removeCert(PGPPublicKey key, Object id, PGPSignature certification) {
        PGPPublicKey returnKey = new PGPPublicKey(key);
        boolean found = false;
        int i = 0;
        while (i < returnKey.ids.size()) {
            if (id.equals(returnKey.ids.get(i))) {
                found = ((List)returnKey.idSigs.get(i)).remove(certification);
            }
            ++i;
        }
        if (!found) {
            return null;
        }
        return returnKey;
    }

    public static PGPPublicKey addCertification(PGPPublicKey key, PGPSignature certification) {
        if (key.isMasterKey()) {
            if (certification.getSignatureType() == 40) {
                throw new IllegalArgumentException("signature type incorrect for master key revocation.");
            }
        } else if (certification.getSignatureType() == 32) {
            throw new IllegalArgumentException("signature type incorrect for sub-key revocation.");
        }
        PGPPublicKey returnKey = new PGPPublicKey(key);
        if (returnKey.subSigs != null) {
            returnKey.subSigs.add(certification);
        } else {
            returnKey.keySigs.add(certification);
        }
        return returnKey;
    }

    public static PGPPublicKey removeCertification(PGPPublicKey key, PGPSignature certification) {
        PGPPublicKey returnKey = new PGPPublicKey(key);
        boolean found = returnKey.subSigs != null ? returnKey.subSigs.remove(certification) : returnKey.keySigs.remove(certification);
        if (!found) {
            Iterator sIt;
            Object id;
            Iterator it = key.getUserIDs();
            while (it.hasNext()) {
                id = (UserIDPacket)it.next();
                sIt = key.getSignaturesForID((UserIDPacket)id);
                while (sIt.hasNext()) {
                    if (certification != sIt.next()) continue;
                    found = true;
                    returnKey = PGPPublicKey.removeCertification(returnKey, ((UserIDPacket)id).getRawID(), certification);
                }
            }
            if (!found) {
                it = key.getUserAttributes();
                while (it.hasNext()) {
                    id = (PGPUserAttributeSubpacketVector)it.next();
                    sIt = key.getSignaturesForUserAttribute((PGPUserAttributeSubpacketVector)id);
                    while (sIt.hasNext()) {
                        if (certification != sIt.next()) continue;
                        found = true;
                        returnKey = PGPPublicKey.removeCertification(returnKey, (PGPUserAttributeSubpacketVector)id, certification);
                    }
                }
            }
        }
        return returnKey;
    }
}

