/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.sdp.sctp;

import fm.icelink.ArrayExtensions;
import fm.icelink.IntegerExtensions;
import fm.icelink.ParseAssistant;
import fm.icelink.StringBuilderExtensions;
import fm.icelink.StringExtensions;
import fm.icelink.sdp.Attribute;
import fm.icelink.sdp.AttributeType;

public class MapAttribute
extends Attribute {
    private int _port;
    private String _sctpProtocol;
    private int _streams;

    public static MapAttribute fromAttributeValue(String value) {
        Object[] strArray = StringExtensions.split(value, new char[]{' '});
        int num = ParseAssistant.parseIntegerValue(strArray[0]);
        String str = strArray[1];
        int num2 = ArrayExtensions.getLength(strArray) > 2 ? ParseAssistant.parseIntegerValue((String)strArray[2]) : 16;
        MapAttribute attribute = new MapAttribute();
        attribute.setPort(num);
        attribute.setSctpProtocol(str);
        attribute.setStreams(num2);
        return attribute;
    }

    @Override
    protected String getAttributeValue() {
        StringBuilder builder = new StringBuilder();
        StringBuilderExtensions.append(builder, IntegerExtensions.toString(this.getPort()));
        StringBuilderExtensions.append(builder, " ");
        StringBuilderExtensions.append(builder, this.getSctpProtocol());
        StringBuilderExtensions.append(builder, " ");
        StringBuilderExtensions.append(builder, IntegerExtensions.toString(this.getStreams()));
        return builder.toString();
    }

    public int getPort() {
        return this._port;
    }

    public String getSctpProtocol() {
        return this._sctpProtocol;
    }

    public int getStreams() {
        return this._streams;
    }

    public MapAttribute(int port, String protocol, int streams) {
        super.setAttributeType(AttributeType.SctpMapAttribute);
        this.setPort(port);
        this.setSctpProtocol(protocol);
        this.setStreams(streams);
    }

    private MapAttribute() {
        super.setAttributeType(AttributeType.SctpMapAttribute);
    }

    private void setPort(int value) {
        this._port = value;
    }

    private void setSctpProtocol(String value) {
        this._sctpProtocol = value;
    }

    private void setStreams(int value) {
        this._streams = value;
    }
}

