/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.sdp.ice;

import fm.icelink.Guid;
import fm.icelink.StringExtensions;
import fm.icelink.sdp.Attribute;
import fm.icelink.sdp.AttributeType;

public class UfragAttribute
extends Attribute {
    private String _ufrag;

    public static UfragAttribute fromAttributeValue(String value) {
        return new UfragAttribute(value);
    }

    public static String generateUfrag() {
        return StringExtensions.substring(Guid.newGuid().toString().replace("-", ""), 0, 8);
    }

    @Override
    protected String getAttributeValue() {
        return this.getUfrag();
    }

    public String getUfrag() {
        return this._ufrag;
    }

    private void setUfrag(String value) {
        this._ufrag = value;
    }

    public UfragAttribute(String ufrag) {
        super.setAttributeType(AttributeType.IceUfragAttribute);
        if (StringExtensions.getLength(ufrag) < 4 || StringExtensions.getLength(ufrag) > 256) {
            throw new RuntimeException(new Exception("ufrag must be at least 4 characters long up to 256 characters."));
        }
        this.setUfrag(ufrag);
    }

    public UfragAttribute() {
        this(UfragAttribute.generateUfrag());
    }
}

