/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.matroska;

import fm.icelink.ArrayExtensions;
import fm.icelink.ArrayListExtensions;
import fm.icelink.BitAssistant;
import fm.icelink.ByteOutputStream;
import fm.icelink.Global;
import fm.icelink.IntegerHolder;
import fm.icelink.LockedRandomizer;
import fm.icelink.Log;
import fm.icelink.NullableFloat;
import fm.icelink.NullableLong;
import fm.icelink.StringExtensions;
import fm.icelink.matroska.Audio;
import fm.icelink.matroska.ContentEncodings;
import fm.icelink.matroska.Element;
import fm.icelink.matroska.Video;
import java.util.ArrayList;

public class TrackEntry
extends Element {
    private static byte[] _attachmentLinkId;
    private long[] _attachmentLinks;
    private Audio _audio;
    private NullableLong _codecDelay = new NullableLong();
    private static byte[] _codecDelayId;
    private String _codecId;
    private static byte[] _codecIdId;
    private String _codecName;
    private static byte[] _codecNameId;
    private byte[] _codecPrivate;
    private static byte[] _codecPrivateId;
    private ContentEncodings _contentEncodings;
    private NullableLong _defaultDuration = new NullableLong();
    private static byte[] _defaultDurationId;
    private boolean _flagDefault;
    private static byte[] _flagDefaultId;
    private boolean _flagEnabled;
    private static byte[] _flagEnabledId;
    private boolean _flagForced;
    private static byte[] _flagForcedId;
    private boolean _flagLacing;
    private static byte[] _flagLacingId;
    private String _language;
    private static byte[] _languageId;
    private NullableLong _maxCache = new NullableLong();
    private static byte[] _maxCacheId;
    private long _minCache;
    private static byte[] _minCacheId;
    private String _name;
    private static byte[] _nameId;
    private NullableLong _seekPreRoll = new NullableLong();
    private static byte[] _seekPreRollId;
    private long _trackNumber;
    private static byte[] _trackNumberId;
    private NullableFloat _trackTimecodeScale = new NullableFloat();
    private static byte[] _trackTimecodeScaleId;
    private long _trackType;
    private static byte[] _trackTypeId;
    private long _trackUid;
    private static byte[] _trackUidId;
    private Video _video;

    public long[] getAttachmentLinks() {
        return this._attachmentLinks;
    }

    public Audio getAudio() {
        return this._audio;
    }

    public NullableLong getCodecDelay() {
        return this._codecDelay;
    }

    public String getCodecId() {
        return this._codecId;
    }

    public String getCodecName() {
        return this._codecName;
    }

    public byte[] getCodecPrivate() {
        return this._codecPrivate;
    }

    public ContentEncodings getContentEncodings() {
        return this._contentEncodings;
    }

    public NullableLong getDefaultDuration() {
        return this._defaultDuration;
    }

    public static boolean getDefaultFlagDefault() {
        return true;
    }

    public static boolean getDefaultFlagEnabled() {
        return true;
    }

    public static boolean getDefaultFlagForced() {
        return false;
    }

    public static boolean getDefaultFlagLacing() {
        return true;
    }

    public static String getDefaultLanguage() {
        return "eng";
    }

    public static long getDefaultMinCache() {
        return 0L;
    }

    public static byte[] getEbmlId() {
        return new byte[]{-82};
    }

    public boolean getFlagDefault() {
        return this._flagDefault;
    }

    public boolean getFlagEnabled() {
        return this._flagEnabled;
    }

    public boolean getFlagForced() {
        return this._flagForced;
    }

    public boolean getFlagLacing() {
        return this._flagLacing;
    }

    public static String getH264CodecId() {
        return "V_MPEG4/ISO/AVC";
    }

    @Override
    public byte[] getId() {
        return TrackEntry.getEbmlId();
    }

    @Override
    protected byte[] getInnerBytes() {
        if (this.getCodecId() == null) {
            return null;
        }
        ByteOutputStream stream = new ByteOutputStream();
        super.writeUnsignedInteger(this.getTrackNumber(), _trackNumberId, stream);
        super.writeUnsignedInteger(this.getTrackUid(), _trackUidId, stream);
        super.writeUnsignedInteger(this.getTrackType(), _trackTypeId, stream);
        if (super.getWriteDefaultValues() || !Global.equals(this.getFlagEnabled(), TrackEntry.getDefaultFlagEnabled())) {
            super.writeBool(this.getFlagEnabled(), _flagEnabledId, stream);
        }
        if (super.getWriteDefaultValues() || !Global.equals(this.getFlagDefault(), TrackEntry.getDefaultFlagDefault())) {
            super.writeBool(this.getFlagDefault(), _flagDefaultId, stream);
        }
        if (super.getWriteDefaultValues() || !Global.equals(this.getFlagForced(), TrackEntry.getDefaultFlagForced())) {
            super.writeBool(this.getFlagForced(), _flagForcedId, stream);
        }
        if (super.getWriteDefaultValues() || !Global.equals(this.getFlagLacing(), TrackEntry.getDefaultFlagLacing())) {
            super.writeBool(this.getFlagLacing(), _flagLacingId, stream);
        }
        if (super.getWriteDefaultValues() || this.getMinCache() != TrackEntry.getDefaultMinCache()) {
            super.writeUnsignedInteger(this.getMinCache(), _minCacheId, stream);
        }
        if (this.getMaxCache().getHasValue()) {
            super.writeUnsignedInteger(this.getMaxCache().getValue(), _maxCacheId, stream);
        }
        if (this.getDefaultDuration().getHasValue()) {
            super.writeUnsignedInteger(this.getDefaultDuration().getValue(), _defaultDurationId, stream);
        }
        if (this.getTrackTimecodeScale().getHasValue()) {
            super.writeFloat(this.getTrackTimecodeScale().getValue(), _trackTimecodeScaleId, stream);
        }
        if (this.getName() != null) {
            super.writeUtf8(this.getName(), _nameId, stream);
        }
        if ((super.getWriteDefaultValues() || !Global.equals(this.getLanguage(), TrackEntry.getDefaultLanguage())) && this.getLanguage() != null) {
            super.writeString(this.getLanguage(), _languageId, stream);
        }
        super.writeString(this.getCodecId(), _codecIdId, stream);
        if (this.getCodecPrivate() != null) {
            super.write(this.getCodecPrivate(), _codecPrivateId, stream);
        }
        if (this.getCodecName() != null) {
            super.writeUtf8(this.getCodecName(), _codecNameId, stream);
        }
        if (this.getCodecDelay().getHasValue()) {
            super.writeUnsignedInteger(this.getCodecDelay().getValue(), _codecDelayId, stream);
        }
        if (this.getSeekPreRoll().getHasValue()) {
            super.writeUnsignedInteger(this.getSeekPreRoll().getValue(), _seekPreRollId, stream);
        }
        if (this.getAttachmentLinks() != null) {
            for (long num : this.getAttachmentLinks()) {
                super.writeUnsignedInteger(num, _attachmentLinkId, stream);
            }
        }
        if (this.getVideo() != null) {
            stream.writeBuffer(this.getVideo().getBytes());
        }
        if (this.getAudio() != null) {
            stream.writeBuffer(this.getAudio().getBytes());
        }
        if (this.getContentEncodings() != null) {
            stream.writeBuffer(this.getContentEncodings().getBytes());
        }
        return stream.toArray();
    }

    public String getLanguage() {
        return this._language;
    }

    public NullableLong getMaxCache() {
        return this._maxCache;
    }

    public long getMinCache() {
        return this._minCache;
    }

    public String getName() {
        return this._name;
    }

    public static String getOpusCodecId() {
        return "A_OPUS";
    }

    public static int getPcmaFormatTag() {
        return 6;
    }

    public static String getPcmCodecId() {
        return "A_MS/ACM";
    }

    public static int getPcmuFormatTag() {
        return 7;
    }

    public NullableLong getSeekPreRoll() {
        return this._seekPreRoll;
    }

    public long getTrackNumber() {
        return this._trackNumber;
    }

    public NullableFloat getTrackTimecodeScale() {
        return this._trackTimecodeScale;
    }

    public long getTrackType() {
        return this._trackType;
    }

    public long getTrackUid() {
        return this._trackUid;
    }

    public Video getVideo() {
        return this._video;
    }

    public static String getVp8CodecId() {
        return "V_VP8";
    }

    public static String getVp9CodecId() {
        return "V_VP9";
    }

    public void setAttachmentLinks(long[] value) {
        this._attachmentLinks = value;
    }

    public void setAudio(Audio value) {
        this._audio = value;
    }

    public void setCodecDelay(NullableLong value) {
        this._codecDelay = value;
    }

    public void setCodecId(String value) {
        this._codecId = value;
    }

    public void setCodecName(String value) {
        this._codecName = value;
    }

    public void setCodecPrivate(byte[] value) {
        this._codecPrivate = value;
    }

    public void setContentEncodings(ContentEncodings value) {
        this._contentEncodings = value;
    }

    public void setDefaultDuration(NullableLong value) {
        this._defaultDuration = value;
    }

    public void setFlagDefault(boolean value) {
        this._flagDefault = value;
    }

    public void setFlagEnabled(boolean value) {
        this._flagEnabled = value;
    }

    public void setFlagForced(boolean value) {
        this._flagForced = value;
    }

    public void setFlagLacing(boolean value) {
        this._flagLacing = value;
    }

    public void setLanguage(String value) {
        this._language = value;
    }

    public void setMaxCache(NullableLong value) {
        this._maxCache = value;
    }

    public void setMinCache(long value) {
        this._minCache = value;
    }

    public void setName(String value) {
        this._name = value;
    }

    public void setSeekPreRoll(NullableLong value) {
        this._seekPreRoll = value;
    }

    public void setTrackNumber(long value) {
        this._trackNumber = value;
    }

    public void setTrackTimecodeScale(NullableFloat value) {
        this._trackTimecodeScale = value;
    }

    public void setTrackType(long value) {
        this._trackType = value;
    }

    public void setTrackUid(long value) {
        this._trackUid = value;
    }

    public void setVideo(Video value) {
        this._video = value;
    }

    public TrackEntry() {
        this.setTrackUid(LockedRandomizer.nextLong());
        this.setFlagEnabled(TrackEntry.getDefaultFlagEnabled());
        this.setFlagDefault(TrackEntry.getDefaultFlagDefault());
        this.setFlagForced(TrackEntry.getDefaultFlagForced());
        this.setFlagLacing(TrackEntry.getDefaultFlagLacing());
        this.setMinCache(TrackEntry.getDefaultMinCache());
        this.setLanguage(TrackEntry.getDefaultLanguage());
    }

    public TrackEntry(byte[] bytes) {
        this();
        ArrayList<Long> list = new ArrayList<Long>();
        int offset = 0;
        while (offset < ArrayExtensions.getLength(bytes)) {
            IntegerHolder _var0 = new IntegerHolder(offset);
            byte[] _var1 = Element.readId(bytes, offset, _var0);
            offset = _var0.getValue();
            byte[] buffer = _var1;
            IntegerHolder _var2 = new IntegerHolder(offset);
            byte[] _var3 = Element.readValue(bytes, offset, _var2);
            offset = _var2.getValue();
            byte[] buffer2 = _var3;
            if (Element.compare(buffer, _trackNumberId)) {
                this.setTrackNumber(Element.readUnsignedInteger(buffer2));
                continue;
            }
            if (Element.compare(buffer, _trackUidId)) {
                this.setTrackUid(Element.readUnsignedInteger(buffer2));
                continue;
            }
            if (Element.compare(buffer, _trackTypeId)) {
                this.setTrackType(Element.readUnsignedInteger(buffer2));
                continue;
            }
            if (Element.compare(buffer, _flagEnabledId)) {
                this.setFlagEnabled(Element.readBool(buffer2));
                continue;
            }
            if (Element.compare(buffer, _flagDefaultId)) {
                this.setFlagDefault(Element.readBool(buffer2));
                continue;
            }
            if (Element.compare(buffer, _flagForcedId)) {
                this.setFlagForced(Element.readBool(buffer2));
                continue;
            }
            if (Element.compare(buffer, _flagLacingId)) {
                this.setFlagLacing(Element.readBool(buffer2));
                continue;
            }
            if (Element.compare(buffer, _minCacheId)) {
                this.setMinCache(Element.readUnsignedInteger(buffer2));
                continue;
            }
            if (Element.compare(buffer, _maxCacheId)) {
                this.setMaxCache(new NullableLong(Element.readUnsignedInteger(buffer2)));
                continue;
            }
            if (Element.compare(buffer, _defaultDurationId)) {
                this.setDefaultDuration(new NullableLong(Element.readUnsignedInteger(buffer2)));
                continue;
            }
            if (Element.compare(buffer, _trackTimecodeScaleId)) {
                this.setTrackTimecodeScale(new NullableFloat(Element.readFloat(buffer2)));
                continue;
            }
            if (Element.compare(buffer, _nameId)) {
                this.setName(Element.readUtf8(buffer2));
                continue;
            }
            if (Element.compare(buffer, _languageId)) {
                this.setLanguage(Element.readString(buffer2));
                continue;
            }
            if (Element.compare(buffer, _codecIdId)) {
                this.setCodecId(Element.readString(buffer2));
                continue;
            }
            if (Element.compare(buffer, _codecPrivateId)) {
                this.setCodecPrivate(buffer2);
                continue;
            }
            if (Element.compare(buffer, _codecNameId)) {
                this.setCodecName(Element.readUtf8(buffer2));
                continue;
            }
            if (Element.compare(buffer, _codecDelayId)) {
                this.setCodecDelay(new NullableLong(Element.readUnsignedInteger(buffer2)));
                continue;
            }
            if (Element.compare(buffer, _seekPreRollId)) {
                this.setSeekPreRoll(new NullableLong(Element.readUnsignedInteger(buffer2)));
                continue;
            }
            if (Element.compare(buffer, _attachmentLinkId)) {
                list.add(Element.readUnsignedInteger(buffer2));
                continue;
            }
            if (Element.compare(buffer, Video.getEbmlId())) {
                this.setVideo(new Video(buffer2));
                continue;
            }
            if (Element.compare(buffer, Audio.getEbmlId())) {
                this.setAudio(new Audio(buffer2));
                continue;
            }
            if (Element.compare(buffer, ContentEncodings.getEbmlId())) {
                this.setContentEncodings(new ContentEncodings(buffer2));
                continue;
            }
            Log.warn(StringExtensions.concat("Unrecognized ID in MatroskaTrackEntry: ", BitAssistant.getHexString(buffer)));
        }
        if (ArrayListExtensions.getCount(list) > 0) {
            long[] numArray = new long[ArrayListExtensions.getCount(list)];
            for (int i = 0; i < ArrayListExtensions.getCount(list); ++i) {
                numArray[i] = (Long)ArrayListExtensions.getItem(list).get(i);
            }
            this.setAttachmentLinks(numArray);
        }
    }

    static {
        _trackNumberId = new byte[]{-41};
        _trackUidId = new byte[]{115, -59};
        _trackTypeId = new byte[]{-125};
        _flagEnabledId = new byte[]{-71};
        _flagDefaultId = new byte[]{-120};
        _flagForcedId = new byte[]{85, -86};
        _flagLacingId = new byte[]{-100};
        _minCacheId = new byte[]{109, -25};
        _maxCacheId = new byte[]{109, -8};
        _defaultDurationId = new byte[]{35, -29, -125};
        _trackTimecodeScaleId = new byte[]{35, 49, 79};
        _nameId = new byte[]{83, 110};
        _languageId = new byte[]{34, -75, -100};
        _codecIdId = new byte[]{-122};
        _codecPrivateId = new byte[]{99, -94};
        _codecNameId = new byte[]{37, -122, -120};
        _codecDelayId = new byte[]{86, -86};
        _seekPreRollId = new byte[]{86, -69};
        _attachmentLinkId = new byte[]{116, 70};
    }
}

