/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.bzip2;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

enum DecompressorState {
    EOF(1),
    START_BLOCK(2),
    RAND_PART_A(3),
    RAND_PART_B(4),
    RAND_PART_C(5),
    NO_RAND_PART_A(6),
    NO_RAND_PART_B(7),
    NO_RAND_PART_C(8);

    private final int value;
    private static final Map<Integer, DecompressorState> lookup;

    private DecompressorState(int value) {
        this.value = value;
    }

    public int getAssignedValue() {
        return this.value;
    }

    public static DecompressorState getByAssignedValue(int value) {
        return lookup.get(value);
    }

    static {
        lookup = new HashMap<Integer, DecompressorState>();
        for (DecompressorState s : EnumSet.allOf(DecompressorState.class)) {
            lookup.put(s.getAssignedValue(), s);
        }
    }
}

