/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayListExtensions;
import fm.icelink.Global;
import fm.icelink.IAction1;
import fm.icelink.IActionDelegate1;
import fm.icelink.IntegerExtensions;
import fm.icelink.Log;
import fm.icelink.StringExtensions;
import fm.icelink.TimeoutTimer;
import fm.icelink.TransportAddress;
import fm.icelink.VirtualNatMode;
import java.util.ArrayList;

class VirtualNatMapping {
    private ArrayList<TransportAddress> __externalAddresses = new ArrayList();
    private Object __externalAddressesLock = new Object();
    private TransportAddress _internalAddress;
    private boolean _isForwarding;
    private int _port;
    private int _timeout;
    private IAction1<VirtualNatMapping> _timeoutCallback;
    private TimeoutTimer _timer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    VirtualNatMapping addExternalPermission(TransportAddress externalAddress, VirtualNatMode natMode) {
        if (!Global.equals((Object)natMode, (Object)VirtualNatMode.FullCone)) {
            Object obj2;
            if (Global.equals((Object)natMode, (Object)VirtualNatMode.AddressRestrictedCone)) {
                Object obj22;
                Object object = obj22 = this.__externalAddressesLock;
                synchronized (object) {
                    this.__externalAddresses.add(new TransportAddress(externalAddress.getIPAddress(), 0));
                }
            }
            Object object = obj2 = this.__externalAddressesLock;
            synchronized (object) {
                this.__externalAddresses.add(new TransportAddress(externalAddress.getIPAddress(), externalAddress.getPort()));
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean checkExternalPermission(TransportAddress externalAddress, VirtualNatMode natMode) {
        if (Global.equals((Object)natMode, (Object)VirtualNatMode.FullCone)) {
            return true;
        }
        Object object = this.__externalAddressesLock;
        synchronized (object) {
            for (int i = 0; i < ArrayListExtensions.getCount(this.__externalAddresses); ++i) {
                TransportAddress address = ArrayListExtensions.getItem(this.__externalAddresses).get(i);
                if (Global.equals((Object)natMode, (Object)VirtualNatMode.AddressRestrictedCone)) {
                    if (!Global.equals(address.getIPAddress(), externalAddress.getIPAddress())) continue;
                    return true;
                }
                if (!Global.equals(address.getIPAddress(), externalAddress.getIPAddress()) || address.getPort() != externalAddress.getPort()) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransportAddress[] getExternalAddresses() {
        Object object = this.__externalAddressesLock;
        synchronized (object) {
            return this.__externalAddresses.toArray(new TransportAddress[0]);
        }
    }

    public TransportAddress getInternalAddress() {
        return this._internalAddress;
    }

    public boolean getIsForwarding() {
        return this._isForwarding;
    }

    public int getPort() {
        return this._port;
    }

    boolean keepAlive() {
        if (this._timeout > 0) {
            if (this._timer.stop()) {
                this._timer = new TimeoutTimer((IAction1<Object>)new IActionDelegate1<Object>(){

                    @Override
                    public String getId() {
                        return "fm.icelink.VirtualNatMapping.timerCallback";
                    }

                    @Override
                    public void invoke(Object state) {
                        VirtualNatMapping.this.timerCallback(state);
                    }
                }, null);
                try {
                    this._timer.start(this._timeout);
                }
                catch (Exception exception) {
                    Log.error("Could not start virtual NAT mapping keep-alive timer.", exception);
                }
                return true;
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeExternalPermission(TransportAddress externalAddress, VirtualNatMode natMode) {
        if (!Global.equals((Object)natMode, (Object)VirtualNatMode.FullCone)) {
            Object object = this.__externalAddressesLock;
            synchronized (object) {
                for (int i = 0; i < ArrayListExtensions.getCount(this.__externalAddresses); ++i) {
                    TransportAddress address = ArrayListExtensions.getItem(this.__externalAddresses).get(i);
                    if (Global.equals((Object)natMode, (Object)VirtualNatMode.AddressRestrictedCone)) {
                        if (!Global.equals(address.getIPAddress(), externalAddress.getIPAddress())) continue;
                        ArrayListExtensions.removeAt(this.__externalAddresses, i);
                        return true;
                    }
                    if (!Global.equals(address.getIPAddress(), externalAddress.getIPAddress()) || address.getPort() != externalAddress.getPort()) continue;
                    ArrayListExtensions.removeAt(this.__externalAddresses, i);
                    return true;
                }
            }
        }
        return false;
    }

    public void setInternalAddress(TransportAddress value) {
        this._internalAddress = value;
    }

    public void setIsForwarding(boolean value) {
        this._isForwarding = value;
    }

    public void setPort(int value) {
        this._port = value;
    }

    private void timerCallback(Object state) {
        if (this._timeoutCallback != null) {
            this._timeoutCallback.invoke(this);
        }
    }

    public String toString() {
        String str = StringExtensions.format("{0} -> {1}", this.getInternalAddress().toString(), IntegerExtensions.toString(this.getPort()));
        ArrayList<String> list = new ArrayList<String>();
        for (TransportAddress address : this.getExternalAddresses()) {
            list.add(address.toString());
        }
        if (ArrayListExtensions.getCount(list) > 0) {
            str = StringExtensions.format("{0} ({1})", str, StringExtensions.join(", ", list.toArray(new String[0])));
        }
        return str;
    }

    boolean tryReuse(TransportAddress internalAddress, TransportAddress externalAddress, VirtualNatMode natMode) {
        if (!this.getInternalAddress().equals(internalAddress)) {
            return false;
        }
        if (Global.equals((Object)natMode, (Object)VirtualNatMode.Symmetric) && !this.checkExternalPermission(externalAddress, natMode)) {
            return false;
        }
        boolean flag = this.keepAlive();
        if (flag && !Global.equals((Object)natMode, (Object)VirtualNatMode.Symmetric)) {
            this.addExternalPermission(externalAddress, natMode);
        }
        return flag;
    }

    public VirtualNatMapping(int timeout, IAction1<VirtualNatMapping> timeoutCallback) {
        this._timeout = timeout;
        if (this._timeout > 0) {
            this._timeoutCallback = timeoutCallback;
            this._timer = new TimeoutTimer((IAction1<Object>)new IActionDelegate1<Object>(){

                @Override
                public String getId() {
                    return "fm.icelink.VirtualNatMapping.timerCallback";
                }

                @Override
                public void invoke(Object state) {
                    VirtualNatMapping.this.timerCallback(state);
                }
            }, null);
            try {
                this._timer.start(this._timeout);
            }
            catch (Exception exception) {
                Log.error("Could not create virtual NAT mapping timer.", exception);
            }
        }
    }
}

