/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.BooleanHolder;
import fm.icelink.DataBuffer;
import fm.icelink.DataBufferPool;
import fm.icelink.DatagramSocket;
import fm.icelink.IAction1;
import fm.icelink.IAction3;
import fm.icelink.Log;
import java.net.BindException;
import java.net.DatagramPacket;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class UdpSocket
extends DatagramSocket {
    private ExecutorService execIn = Executors.newFixedThreadPool(1);
    private ExecutorService execOut = Executors.newFixedThreadPool(1);
    private boolean isClosed;
    private Object isClosedLock = new Object();
    private java.net.DatagramSocket socket;
    private byte[] receiveBuffer;
    private int maxQueuedPackets;
    private boolean _ipv6;
    private String _LocalIPAddress;
    private int _LocalPort;

    public UdpSocket(boolean ipv6) {
        this._ipv6 = ipv6;
        this._LocalIPAddress = ipv6 ? "::" : "0.0.0.0";
        this._LocalPort = 9;
        try {
            this.socket = new java.net.DatagramSocket(null);
            if (!(this.setReceiveBufferSize(65536) || this.setReceiveBufferSize(32768) || this.setReceiveBufferSize(16384) || this.setReceiveBufferSize(8192))) {
                Log.debug("Could not set socket receive buffer size.");
            }
            if (!(this.setSendBufferSize(65536) || this.setSendBufferSize(32768) || this.setSendBufferSize(16384) || this.setSendBufferSize(8192))) {
                Log.debug("Could not set socket send buffer size.");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.receiveBuffer = new byte[65535];
    }

    private boolean setReceiveBufferSize(int size) {
        try {
            this.socket.setReceiveBufferSize(size);
            return true;
        }
        catch (Exception ex) {
            Log.debug(String.format(Locale.getDefault(), "Could not set socket receive buffer size to %d.", size));
            return false;
        }
    }

    private boolean setSendBufferSize(int size) {
        try {
            this.socket.setSendBufferSize(size);
            return true;
        }
        catch (Exception ex) {
            Log.debug(String.format(Locale.getDefault(), "Could not set socket send buffer size to %d.", size));
            return false;
        }
    }

    @Override
    public boolean getIPv6() {
        return this._ipv6;
    }

    @Override
    public boolean getIsClosed() {
        return this.isClosed;
    }

    @Override
    public String getLocalIPAddress() {
        java.net.DatagramSocket dSocket = this.socket;
        if (dSocket != null) {
            try {
                this._LocalIPAddress = this.socket.getLocalAddress().getHostAddress();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this._LocalIPAddress;
    }

    @Override
    public int getLocalPort() {
        java.net.DatagramSocket dSocket = this.socket;
        if (dSocket != null) {
            try {
                this._LocalPort = this.socket.getLocalPort();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this._LocalPort;
    }

    @Override
    public void setMaxQueuedPackets(int maxQueuedPackets) {
        this.maxQueuedPackets = maxQueuedPackets;
    }

    @Override
    public int getMaxQueuedPackets() {
        return this.maxQueuedPackets;
    }

    @Override
    public boolean bind(String ipAddress, int port, BooleanHolder addressInUse) {
        addressInUse.setValue(false);
        try {
            InetAddress localAddress = this.getIPv6() ? Inet6Address.getByName(ipAddress) : Inet4Address.getByName(ipAddress);
            this.socket.bind(new InetSocketAddress(localAddress, port));
            return true;
        }
        catch (BindException e) {
            addressInUse.setValue(e.getMessage().contains("in use"));
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void receiveAsync(final IAction3<DataBuffer, String, Integer> onSuccess, final IAction1<Exception> onFailure) {
        try {
            this.execIn.submit(new Runnable(){

                @Override
                public void run() {
                    DataBuffer receiveBuffer = DataBufferPool.getInstance().take(2048);
                    try {
                        DatagramPacket packet = new DatagramPacket(receiveBuffer.getData(), receiveBuffer.getIndex(), receiveBuffer.getLength());
                        UdpSocket.this.socket.receive(packet);
                        UdpSocket.this.raiseReceiveSuccess(onSuccess, receiveBuffer.subset(packet.getOffset() - receiveBuffer.getIndex(), packet.getLength()), packet.getAddress().getHostAddress(), packet.getPort());
                    }
                    catch (Exception e) {
                        UdpSocket.this.raiseReceiveFailure(onFailure, new Exception(String.format("Socket (%s:%d) receive failed.", UdpSocket.this.getLocalIPAddress(), UdpSocket.this.getLocalPort()), e));
                    }
                    finally {
                        receiveBuffer.free();
                    }
                }
            });
        }
        catch (Exception e) {
            this.raiseReceiveFailure(onFailure, new Exception(String.format("Socket (%s:%d) receive failed.", this.getLocalIPAddress(), this.getLocalPort()), e));
        }
    }

    @Override
    public int send(DataBuffer buffer, String ipAddress, int port) {
        try {
            InetAddress remoteAddress = this.getIPv6() ? Inet6Address.getByName(ipAddress) : Inet4Address.getByName(ipAddress);
            this.socket.send(new DatagramPacket(buffer.getData(), buffer.getIndex(), buffer.getLength(), new InetSocketAddress(remoteAddress, port)));
            return buffer.getLength();
        }
        catch (Exception ex) {
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.isClosedLock;
        synchronized (object) {
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
        }
        this.execIn.shutdownNow();
        this.execOut.shutdownNow();
        this.socket.close();
    }
}

