/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum StreamState {
    New(1),
    Connecting(2),
    Connected(3),
    Closing(4),
    Closed(4),
    Failed(5);

    private final int value;
    private static final Map<Integer, StreamState> lookup;

    private StreamState(int value) {
        this.value = value;
    }

    public int getAssignedValue() {
        return this.value;
    }

    public static StreamState getByAssignedValue(int value) {
        return lookup.get(value);
    }

    static {
        lookup = new HashMap<Integer, StreamState>();
        for (StreamState s : EnumSet.allOf(StreamState.class)) {
            lookup.put(s.getAssignedValue(), s);
        }
    }
}

