/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.Binary;
import fm.icelink.ByteCollection;
import fm.icelink.IntegerHolder;
import fm.icelink.Log;
import fm.icelink.SctpErrorCause;
import fm.icelink.SctpTlvParameter;

class SctpUnresolvableAddress
extends SctpErrorCause {
    private SctpTlvParameter _address;

    public SctpTlvParameter getAddress() {
        return this._address;
    }

    @Override
    public byte[] getBytes() {
        return SctpUnresolvableAddress.getBytes(this);
    }

    public static byte[] getBytes(SctpUnresolvableAddress cause) {
        ByteCollection bytes = new ByteCollection();
        bytes.addRange(Binary.toBytes16(cause.getCauseCode(), false));
        byte[] buffer = cause.getAddress().getBytes();
        bytes.addRange(Binary.toBytes16(ArrayExtensions.getLength(buffer) + 4, false));
        bytes.addRange(buffer);
        return bytes.toArray();
    }

    public static SctpUnresolvableAddress parseBytes(byte[] bytes, IntegerHolder offsetPlus) {
        try {
            int startIndex = 4;
            SctpTlvParameter _var0 = SctpTlvParameter.parseBytes(bytes, startIndex, offsetPlus);
            SctpUnresolvableAddress address = new SctpUnresolvableAddress(_var0);
            offsetPlus.setValue(startIndex + offsetPlus.getValue());
            Log.debug("SCTP Error: unresolvable address.");
            return address;
        }
        catch (Exception exception1) {
            offsetPlus.setValue(0);
            return null;
        }
    }

    public SctpUnresolvableAddress(SctpTlvParameter address) {
        super.setCauseCode(5);
        this.setAddress(address);
    }

    public void setAddress(SctpTlvParameter value) {
        this._address = value;
    }
}

