/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.DataBuffer;
import fm.icelink.Global;
import fm.icelink.IntegerExtensions;
import fm.icelink.IntegerHolder;
import fm.icelink.Log;
import fm.icelink.RtpHeaderExtensionElement;
import fm.icelink.RtpHeaderExtensionForm;
import fm.icelink.RtpHeaderExtensionType;
import fm.icelink.StringExtensions;

class RtpUnknownHeaderExtensionElement
extends RtpHeaderExtensionElement {
    private int __length;
    private DataBuffer _payload;

    @Override
    void fillBytes(DataBuffer buffer, int offset, IntegerHolder bytesWritten) {
        if (Global.equals((Object)super.getForm(), (Object)RtpHeaderExtensionForm.OneByte)) {
            buffer.write4(super.getId(), offset, 0);
            buffer.write4(this.__length - 1, offset, 4);
        } else {
            buffer.write8(super.getId(), offset);
            buffer.write8(this.__length - 1, offset + 1);
        }
        buffer.append(this.getPayload());
        bytesWritten.setValue(this.getLength());
    }

    @Override
    public int getLength() {
        return this.__length + (Global.equals((Object)super.getForm(), (Object)RtpHeaderExtensionForm.OneByte) ? 1 : 2);
    }

    public DataBuffer getPayload() {
        return this._payload;
    }

    public static RtpUnknownHeaderExtensionElement parseBytes(DataBuffer buf, int offset, RtpHeaderExtensionForm form, IntegerHolder bytesRead) {
        int num = Global.equals((Object)form, (Object)RtpHeaderExtensionForm.OneByte) ? 1 : 2;
        int id = Global.equals((Object)form, (Object)RtpHeaderExtensionForm.OneByte) ? buf.read4(offset, 0) : buf.read8(offset);
        int num3 = Global.equals((Object)form, (Object)RtpHeaderExtensionForm.OneByte) ? buf.read4(offset, 4) : buf.read8(offset + 1);
        RtpUnknownHeaderExtensionElement element = new RtpUnknownHeaderExtensionElement(form, id, num3 + 1, buf.subset(offset + num, num3 + 1));
        Log.debug(StringExtensions.format("RTP Header Extension processing: encountered not registered RTP extension header type {0}.", IntegerExtensions.toString(id)));
        bytesRead.setValue(num == 1 ? num3 + 1 : num3 + 2);
        return element;
    }

    public RtpUnknownHeaderExtensionElement(RtpHeaderExtensionForm form, int id, int length, DataBuffer payload) {
        super.setType(RtpHeaderExtensionType.Unknown);
        super.setId(id);
        super.setForm(form);
        this.__length = length;
    }

    private void setPayload(DataBuffer value) {
        this._payload = value;
    }
}

