/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayListExtensions;
import fm.icelink.HashMapExtensions;
import fm.icelink.LogLevel;
import fm.icelink.LogProvider;
import java.util.ArrayList;
import java.util.HashMap;

class LogConfiguration {
    private static Object __lock = new Object();
    private static LogProvider[] __logProviders;
    private static int __providerCount;
    private static LogLevel _defaultLogLevel;
    private static HashMap<String, LogLevel> _tagOverrides;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addLogProvider(LogProvider provider) {
        Object object = __lock;
        synchronized (object) {
            ArrayList<LogProvider> list = ArrayListExtensions.createArray(__logProviders);
            list.add(provider);
            ++__providerCount;
            __logProviders = list.toArray(new LogProvider[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearLogProviders() {
        Object object = __lock;
        synchronized (object) {
            __logProviders = new LogProvider[0];
            __providerCount = 0;
        }
    }

    public static LogLevel getDefaultLogLevel() {
        return _defaultLogLevel;
    }

    public static boolean getHaveProviders() {
        return __providerCount > 0;
    }

    public static LogProvider[] getLogProviders() {
        return __logProviders;
    }

    public static LogLevel getTagLogLevel(String tag) {
        LogLevel defaultLogLevel = LogConfiguration.getDefaultLogLevel();
        if (LogConfiguration.getTagOverrides().containsKey(tag)) {
            defaultLogLevel = HashMapExtensions.getItem(LogConfiguration.getTagOverrides()).get(tag);
        }
        return defaultLogLevel;
    }

    public static HashMap<String, LogLevel> getTagOverrides() {
        return _tagOverrides;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeLogProvider(LogProvider provider) {
        Object object = __lock;
        synchronized (object) {
            ArrayList<LogProvider> list = ArrayListExtensions.createArray(__logProviders);
            list.remove(provider);
            --__providerCount;
            __logProviders = list.toArray(new LogProvider[0]);
        }
    }

    public static void setDefaultLogLevel(LogLevel value) {
        _defaultLogLevel = value;
    }

    private static void setTagOverrides(HashMap<String, LogLevel> value) {
        _tagOverrides = value;
    }

    static {
        LogConfiguration.setDefaultLogLevel(LogLevel.Info);
        __logProviders = new LogProvider[0];
        LogConfiguration.setTagOverrides(new HashMap<String, LogLevel>());
    }
}

