/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.Base64;
import fm.icelink.CertificateStats;
import fm.icelink.DataBuffer;
import fm.icelink.DateExtensions;
import fm.icelink.DtlsCertificate;
import fm.icelink.DtlsCipherSuite;
import fm.icelink.DtlsClient;
import fm.icelink.DtlsContentType;
import fm.icelink.DtlsFingerprint;
import fm.icelink.DtlsMessage;
import fm.icelink.DtlsParameters;
import fm.icelink.DtlsProtocolVersion;
import fm.icelink.DtlsRole;
import fm.icelink.DtlsServer;
import fm.icelink.DtlsTransportState;
import fm.icelink.EncryptionMode;
import fm.icelink.Error;
import fm.icelink.ErrorCode;
import fm.icelink.Global;
import fm.icelink.Guid;
import fm.icelink.IAction1;
import fm.icelink.IActionDelegate1;
import fm.icelink.Log;
import fm.icelink.ManagedThread;
import fm.icelink.SrtpProtectionProfile;
import fm.icelink.StringExtensions;
import fm.icelink.Transport;
import fm.icelink.TransportStats;
import fm.icelink.Utility;
import java.util.ArrayList;
import java.util.List;

class DtlsTransport
extends Transport {
    private DtlsCipherSuite[] __cipherSuites;
    private DtlsProtocolVersion __clientVersion;
    private DtlsClient __dtlsClient = null;
    private ManagedThread __dtlsHandshakeThread = null;
    private DtlsServer __dtlsServer = null;
    private DataBuffer __keyingMaterial = null;
    private DtlsCertificate[] __localCertificates;
    private DtlsParameters __localParameters;
    private Object __lock;
    private List<IAction1<DataBuffer>> __onReceive = new ArrayList<IAction1<DataBuffer>>();
    private List<IAction1<DtlsTransport>> __onStateChange = new ArrayList<IAction1<DtlsTransport>>();
    private ArrayList<DtlsCertificate> __remoteCertificates = new ArrayList();
    private DtlsParameters __remoteParameters;
    private int __selectedSrtpProtectionProfile;
    private ArrayList<DataBuffer> __sendQueue = new ArrayList();
    private DtlsProtocolVersion __serverMaxVersion;
    private DtlsProtocolVersion __serverMinVersion;
    private DtlsTransportState __state;
    private boolean _closingShouldNotTriggerGlobalNonGracefulShutdown;
    private EncryptionMode[] _encryptionModes;
    private Error _error;
    private String _id;
    private Transport _innerTransport;
    private DataBuffer _lastDtlsChangeCipherSpec;
    private DataBuffer _lastDtlsFinishedFlight;
    private boolean _nextMessageDtlsFinished;
    private IAction1<DataBuffer> _onReceive = null;
    private IAction1<DtlsTransport> _onStateChange = null;

    @Override
    public void addOnReceive(IAction1<DataBuffer> value) {
        if (value != null) {
            if (this._onReceive == null) {
                this._onReceive = new IAction1<DataBuffer>(){

                    @Override
                    public void invoke(DataBuffer p0) {
                        for (IAction1 action : new ArrayList(DtlsTransport.this.__onReceive)) {
                            action.invoke(p0);
                        }
                    }
                };
            }
            this.__onReceive.add(value);
        }
    }

    public void addOnStateChange(IAction1<DtlsTransport> value) {
        if (value != null) {
            if (this._onStateChange == null) {
                this._onStateChange = new IAction1<DtlsTransport>(){

                    @Override
                    public void invoke(DtlsTransport p0) {
                        for (IAction1 action : new ArrayList(DtlsTransport.this.__onStateChange)) {
                            action.invoke(p0);
                        }
                    }
                };
            }
            this.__onStateChange.add(value);
        }
    }

    public void disableInnerTransport() {
        this.setInnerTransport(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDtls(ManagedThread thread) {
        try {
            int[] protectionProfiles = null;
            EncryptionMode[] encryptionModes = this.getEncryptionModes();
            if (encryptionModes != null) {
                protectionProfiles = new int[ArrayExtensions.getLength((Object[])encryptionModes)];
                for (int i = 0; i < ArrayExtensions.getLength((Object[])encryptionModes); ++i) {
                    protectionProfiles[i] = DtlsTransport.getSrtpProtectionProfile(encryptionModes[i]);
                }
            }
            if (Global.equals((Object)this.getLocalParameters().getRole(), (Object)DtlsRole.Server)) {
                DtlsServer server = new DtlsServer(this.get_LocalCertificate(), this.__cipherSuites, this.__serverMinVersion, this.__serverMaxVersion, this.getRemoteParameters().getFingerprint(), protectionProfiles, null);
                server.setOnError((IAction1<Exception>)new IActionDelegate1<Exception>(){

                    @Override
                    public String getId() {
                        return "fm.icelink.DtlsTransport.processCoreDtlsError";
                    }

                    @Override
                    public void invoke(Exception ex) {
                        DtlsTransport.this.processCoreDtlsError(ex);
                    }
                });
                this.__dtlsServer = server;
            } else {
                if (!Global.equals((Object)this.getLocalParameters().getRole(), (Object)DtlsRole.Client)) {
                    throw new RuntimeException(new Exception("DTLS role has not been set prior to DTLS handshake."));
                }
                DtlsClient client = new DtlsClient(this.get_LocalCertificate(), this.__cipherSuites, this.__clientVersion, this.getRemoteParameters().getFingerprint(), protectionProfiles, null);
                client.setOnError((IAction1<Exception>)new IActionDelegate1<Exception>(){

                    @Override
                    public String getId() {
                        return "fm.icelink.DtlsTransport.processCoreDtlsError";
                    }

                    @Override
                    public void invoke(Exception ex) {
                        DtlsTransport.this.processCoreDtlsError(ex);
                    }
                });
                this.__dtlsClient = client;
            }
            Log.debug("Starting DTLS key exchange.");
            Error error = null;
            if (this.__dtlsServer != null) {
                Log.debug("Accepting DTLS client connection.");
                this.__dtlsServer.setOnDataDecrypted((IAction1<DataBuffer>)new IActionDelegate1<DataBuffer>(){

                    @Override
                    public String getId() {
                        return "fm.icelink.DtlsTransport.processDataDecrypted";
                    }

                    @Override
                    public void invoke(DataBuffer buffer) {
                        DtlsTransport.this.processDataDecrypted(buffer);
                    }
                });
                error = this.__dtlsServer.open((IAction1<DataBuffer>)new IActionDelegate1<DataBuffer>(){

                    @Override
                    public String getId() {
                        return "fm.icelink.DtlsTransport.sendEncryptedData";
                    }

                    @Override
                    public void invoke(DataBuffer data) {
                        DtlsTransport.this.sendEncryptedData(data);
                    }
                });
                if (error == null) {
                    Log.debug("Accepted DTLS client connection.");
                    this.__keyingMaterial = DataBuffer.wrap(this.__dtlsServer.getKeyingMaterial());
                    this.__selectedSrtpProtectionProfile = this.__dtlsServer.getSelectedSrtpProtectionProfile();
                } else {
                    Object obj2;
                    Object object = obj2 = this.__lock;
                    synchronized (object) {
                        this.setError(error);
                        this.setState(DtlsTransportState.Failed);
                    }
                }
            } else {
                Log.debug("Connecting to DTLS server.");
                this.__dtlsClient.setOnDataDecrypted((IAction1<DataBuffer>)new IActionDelegate1<DataBuffer>(){

                    @Override
                    public String getId() {
                        return "fm.icelink.DtlsTransport.processDataDecrypted";
                    }

                    @Override
                    public void invoke(DataBuffer buffer) {
                        DtlsTransport.this.processDataDecrypted(buffer);
                    }
                });
                error = this.__dtlsClient.open((IAction1<DataBuffer>)new IActionDelegate1<DataBuffer>(){

                    @Override
                    public String getId() {
                        return "fm.icelink.DtlsTransport.sendEncryptedData";
                    }

                    @Override
                    public void invoke(DataBuffer data) {
                        DtlsTransport.this.sendEncryptedData(data);
                    }
                });
                if (error == null) {
                    Log.debug("Connected to DTLS server.");
                    this.__keyingMaterial = DataBuffer.wrap(this.__dtlsClient.getKeyingMaterial());
                    this.__selectedSrtpProtectionProfile = this.__dtlsClient.getSelectedSrtpProtectionProfile();
                } else {
                    Object obj2;
                    Object object = obj2 = this.__lock;
                    synchronized (object) {
                        this.setError(error);
                        this.setState(DtlsTransportState.Failed);
                    }
                }
            }
            if (error == null) {
                Log.debug("Completed DTLS key exchange.");
                this.processDtlsFinished();
            }
        }
        catch (Exception exception) {
            Object obj2;
            Object object = obj2 = this.__lock;
            synchronized (object) {
                this.setError(new Error(ErrorCode.DtlsKeyExchangeFailed, exception));
                this.setState(DtlsTransportState.Failed);
            }
        }
    }

    public DtlsTransport(Object lockObject, Transport innerTransport, DtlsCertificate[] localCertificates, DtlsCipherSuite[] cipherSuites, DtlsProtocolVersion serverMinVersion, DtlsProtocolVersion serverMaxVersion, DtlsProtocolVersion clientVersion) {
        this.__lock = lockObject;
        this.setId(Guid.newGuid().toString().replace("-", ""));
        if (innerTransport == null) {
            Log.error("Dtls transport: Null inner transport argument.");
        }
        if (localCertificates == null) {
            Log.error("Dtls transport: Null local certificates argument.");
        }
        this.__state = DtlsTransportState.New;
        this.setInnerTransport(innerTransport);
        this.__localCertificates = localCertificates;
        this.__clientVersion = clientVersion;
        this.__serverMinVersion = serverMinVersion;
        this.__serverMaxVersion = serverMaxVersion;
        this.__cipherSuites = cipherSuites;
    }

    private DtlsCertificate get_LocalCertificate() {
        return Utility.firstOrDefault(this.__localCertificates);
    }

    public boolean getClosingShouldNotTriggerGlobalNonGracefulShutdown() {
        return this._closingShouldNotTriggerGlobalNonGracefulShutdown;
    }

    public EncryptionMode[] getEncryptionModes() {
        return this._encryptionModes;
    }

    public Error getError() {
        return this._error;
    }

    public String getId() {
        return this._id;
    }

    public Transport getInnerTransport() {
        return this._innerTransport;
    }

    @Override
    public boolean getIsClosed() {
        return Global.equals((Object)this.getState(), (Object)DtlsTransportState.Closed);
    }

    public DtlsCertificate[] getLocalCertificates() {
        return this.__localCertificates;
    }

    public DataBuffer getLocalKey() {
        if (this.__keyingMaterial == null) {
            return null;
        }
        if (this.__dtlsServer != null) {
            return this.__keyingMaterial.subset(16, 16);
        }
        return this.__keyingMaterial.subset(0, 16);
    }

    public DtlsParameters getLocalParameters() {
        if (this.__localParameters == null) {
            DtlsFingerprint[] fingerprints = new DtlsFingerprint[ArrayExtensions.getLength(this.__localCertificates)];
            for (int i = 0; i < ArrayExtensions.getLength(this.__localCertificates); ++i) {
                fingerprints[i] = this.__localCertificates[i].calculateFingerprint(DtlsFingerprint.getSha256Algorithm());
            }
            this.__localParameters = new DtlsParameters(DtlsRole.Auto, fingerprints);
        }
        return this.__localParameters;
    }

    public DataBuffer getLocalSalt() {
        if (this.__keyingMaterial == null) {
            return null;
        }
        if (this.__dtlsServer != null) {
            return this.__keyingMaterial.subset(46, 14);
        }
        return this.__keyingMaterial.subset(32, 14);
    }

    DtlsCertificate getRemoteCertificate() {
        return Utility.firstOrDefault(this.__remoteCertificates);
    }

    DtlsCertificate[] getRemoteCertificates() {
        return this.__remoteCertificates.toArray(new DtlsCertificate[0]);
    }

    public DataBuffer getRemoteKey() {
        if (this.__keyingMaterial == null) {
            return null;
        }
        if (this.__dtlsServer != null) {
            return this.__keyingMaterial.subset(0, 16);
        }
        return this.__keyingMaterial.subset(16, 16);
    }

    public DtlsParameters getRemoteParameters() {
        return this.__remoteParameters;
    }

    public DataBuffer getRemoteSalt() {
        if (this.__keyingMaterial == null) {
            return null;
        }
        if (this.__dtlsServer != null) {
            return this.__keyingMaterial.subset(32, 14);
        }
        return this.__keyingMaterial.subset(46, 14);
    }

    public int getSelectedSrtpProtectionProfile() {
        return this.__selectedSrtpProtectionProfile;
    }

    private static int getSrtpProtectionProfile(EncryptionMode encryptionMode) {
        String profileString = StringExtensions.empty;
        if (Global.equals((Object)encryptionMode, (Object)EncryptionMode.Aes128Strong)) {
            profileString = SrtpProtectionProfile.getAes128CmHmacSha180ProtectionProfileString();
        }
        if (Global.equals((Object)encryptionMode, (Object)EncryptionMode.Aes128Weak)) {
            profileString = SrtpProtectionProfile.getAes128CmHmacSha132ProtectionProfileString();
        }
        if (Global.equals((Object)encryptionMode, (Object)EncryptionMode.NullStrong)) {
            profileString = SrtpProtectionProfile.getNullHmacSha180ProtectionProfileString();
        }
        if (Global.equals((Object)encryptionMode, (Object)EncryptionMode.NullWeak)) {
            profileString = SrtpProtectionProfile.getNullHmacSha132ProtectionProfileString();
        }
        return SrtpProtectionProfile.protectionProfileCodeFromString(profileString);
    }

    public DtlsTransportState getState() {
        return this.__state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCoreDtlsError(Exception ex) {
        Object object = this.__lock;
        synchronized (object) {
            this.setError(new Error(ErrorCode.DtlsInternalError, ex));
            this.setState(DtlsTransportState.Failed);
        }
    }

    private void processDataDecrypted(DataBuffer buffer) {
        this.raiseReceive(buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDtlsFinished() {
        Object object = this.__lock;
        synchronized (object) {
            if (!Global.equals((Object)this.getState(), (Object)DtlsTransportState.Closed)) {
                this.setState(DtlsTransportState.Connected);
                for (DataBuffer buffer : this.__sendQueue) {
                    this.send(buffer);
                }
                this.__sendQueue.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processReceive(DataBuffer buffer) {
        if (this.__dtlsServer != null) {
            DtlsMessage[] messageArray;
            for (DtlsMessage message : messageArray = DtlsMessage.parseMultiple(buffer)) {
                DataBuffer lastDtlsFinishedFlight = this._lastDtlsFinishedFlight;
                if (message.getContentType() != DtlsContentType.getChangeCipherSpec() || lastDtlsFinishedFlight == null) continue;
                this.getInnerTransport().send(lastDtlsFinishedFlight);
            }
            this.__dtlsServer.receive(buffer);
        } else if (this.__dtlsClient != null) {
            this.__dtlsClient.receive(buffer);
        } else {
            Object object = this.__lock;
            synchronized (object) {
                this.setError(new Error(ErrorCode.DtlsNotReady, new Exception("Neither DTLS server nor client have been prepared.")));
                Log.debug(this.getError().getDescription());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRemoteCertificate(DtlsCertificate certificate) {
        Object object = this.__lock;
        synchronized (object) {
            this.__remoteCertificates.add(certificate);
        }
    }

    private void raiseReceive(DataBuffer buffer) {
        IAction1<DataBuffer> onReceive = this._onReceive;
        if (onReceive != null) {
            onReceive.invoke(buffer);
        }
    }

    @Override
    public void removeOnReceive(IAction1<DataBuffer> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onReceive, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onReceive.remove(value);
        if (this.__onReceive.size() == 0) {
            this._onReceive = null;
        }
    }

    public void removeOnStateChange(IAction1<DtlsTransport> value) {
        IAction1 match;
        if (value instanceof IActionDelegate1 && (match = Global.findIActionDelegate1WithId(this.__onStateChange, ((IActionDelegate1)value).getId())) != null) {
            value = match;
        }
        this.__onStateChange.remove(value);
        if (this.__onStateChange.size() == 0) {
            this._onStateChange = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(DataBuffer buffer) {
        if (buffer != null) {
            if (Global.equals((Object)this.getState(), (Object)DtlsTransportState.Connected)) {
                this.sendToEncryptor(buffer);
            } else if (Global.equals((Object)this.getState(), (Object)DtlsTransportState.Connecting) || Global.equals((Object)this.getState(), (Object)DtlsTransportState.New)) {
                Object object = this.__lock;
                synchronized (object) {
                    if (Global.equals((Object)this.getState(), (Object)DtlsTransportState.Connecting) || Global.equals((Object)this.getState(), (Object)DtlsTransportState.New)) {
                        this.__sendQueue.add(buffer);
                    } else if (Global.equals((Object)this.getState(), (Object)DtlsTransportState.Connected)) {
                        this.sendToEncryptor(buffer);
                    }
                }
            }
        }
    }

    private void sendEncryptedData(DataBuffer data) {
        Transport innerTransport;
        if (this.__dtlsServer != null) {
            Object[] messageArray;
            for (DtlsMessage dtlsMessage : messageArray = DtlsMessage.parseMultiple(data)) {
                DataBuffer buffer;
                if (this._nextMessageDtlsFinished) {
                    DataBuffer dataBuffer = buffer = dtlsMessage.getContentType() == DtlsContentType.getHandshake() ? dtlsMessage.getRaw() : null;
                    if (buffer != null) {
                        this._lastDtlsChangeCipherSpec.append(buffer);
                        this._lastDtlsFinishedFlight = this._lastDtlsChangeCipherSpec;
                    }
                    this._nextMessageDtlsFinished = false;
                }
                DataBuffer dataBuffer = buffer = dtlsMessage.getContentType() == DtlsContentType.getChangeCipherSpec() ? dtlsMessage.getRaw() : null;
                if (buffer != null) {
                    this._nextMessageDtlsFinished = true;
                    if (ArrayExtensions.getLength(messageArray) > 2) {
                        Log.warn("Outgoing DTLS flight with a Change Cipher Spec message contains more than two messages.");
                    }
                    this._lastDtlsChangeCipherSpec = buffer;
                    continue;
                }
                this._nextMessageDtlsFinished = false;
            }
        }
        if (!(Global.equals((Object)this.getState(), (Object)DtlsTransportState.Closed) || Global.equals((Object)this.getState(), (Object)DtlsTransportState.Failed) || (innerTransport = this.getInnerTransport()) == null || this.getInnerTransport().getIsClosed())) {
            innerTransport.send(data);
        }
    }

    private boolean sendToEncryptor(DataBuffer buffer) {
        if (this.__dtlsServer != null) {
            this.__dtlsServer.send(buffer);
            return true;
        }
        if (this.__dtlsClient != null) {
            this.__dtlsClient.send(buffer);
            return true;
        }
        return false;
    }

    public void setClosingShouldNotTriggerGlobalNonGracefulShutdown(boolean value) {
        this._closingShouldNotTriggerGlobalNonGracefulShutdown = value;
    }

    void setEncryptionModes(EncryptionMode[] value) {
        this._encryptionModes = value;
    }

    private void setError(Error value) {
        this._error = value;
    }

    private void setId(String value) {
        this._id = value;
    }

    private void setInnerTransport(Transport value) {
        this._innerTransport = value;
    }

    void setLocalParameters(DtlsParameters value) {
        this.__localParameters = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setState(DtlsTransportState value) {
        Object object = this.__lock;
        synchronized (object) {
            if (!(Global.equals((Object)value, (Object)this.__state) || Global.equals((Object)this.__state, (Object)DtlsTransportState.Closed) || Global.equals((Object)this.__state, (Object)DtlsTransportState.Failed))) {
                IAction1<DtlsTransport> onStateChange;
                this.__state = value;
                if (Global.equals((Object)value, (Object)DtlsTransportState.Failed) || Global.equals((Object)value, (Object)DtlsTransportState.Closed)) {
                    this.__sendQueue.clear();
                    if (this.__dtlsServer != null) {
                        this.__dtlsServer.close();
                    } else if (this.__dtlsClient != null) {
                        this.__dtlsClient.close();
                    }
                    if (this.getInnerTransport() != null) {
                        this.getInnerTransport().removeOnReceive((IAction1<DataBuffer>)new IActionDelegate1<DataBuffer>(){

                            @Override
                            public String getId() {
                                return "fm.icelink.DtlsTransport.processReceive";
                            }

                            @Override
                            public void invoke(DataBuffer buffer) {
                                DtlsTransport.this.processReceive(buffer);
                            }
                        });
                    }
                    this.setInnerTransport(null);
                    this.__remoteParameters = null;
                }
                if ((onStateChange = this._onStateChange) != null) {
                    onStateChange.invoke(this);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean start(DtlsParameters remoteParameters) {
        Object object = this.__lock;
        synchronized (object) {
            if (!(Global.equals((Object)this.__state, (Object)DtlsTransportState.New) || Global.equals((Object)this.__state, (Object)DtlsTransportState.Closed) || Global.equals((Object)this.__state, (Object)DtlsTransportState.Failed))) {
                return false;
            }
            if (this.getLocalParameters() == null) {
                throw new RuntimeException(new Exception("Cannot start Dtls Transport: local Dtls parameters are not set."));
            }
            this.setState(DtlsTransportState.Connecting);
            this.__remoteParameters = remoteParameters;
            if (Global.equals((Object)this.getLocalParameters().getRole(), (Object)DtlsRole.Auto)) {
                if (Global.equals((Object)this.__remoteParameters.getRole(), (Object)DtlsRole.Server)) {
                    this.getLocalParameters().setRole(DtlsRole.Client);
                } else if (Global.equals((Object)this.__remoteParameters.getRole(), (Object)DtlsRole.Client)) {
                    this.getLocalParameters().setRole(DtlsRole.Server);
                } else if (Global.equals((Object)this.__remoteParameters.getRole(), (Object)DtlsRole.Auto)) {
                    throw new RuntimeException(new Exception(StringExtensions.format("Remote and Local clients assigned incompatible DTLS roles. Local is '{0}', Remote is '{1}'.", this.getLocalParameters().getRole().toString(), remoteParameters.getRole().toString())));
                }
            } else if (Global.equals((Object)this.getLocalParameters().getRole(), (Object)DtlsRole.Server) && Global.equals((Object)remoteParameters.getRole(), (Object)DtlsRole.Server) || Global.equals((Object)this.getLocalParameters().getRole(), (Object)DtlsRole.Client) && Global.equals((Object)remoteParameters.getRole(), (Object)DtlsRole.Client)) {
                throw new RuntimeException(new Exception(StringExtensions.format("Remote and Local clients assigned incompatible DTLS roles. Local is '{0}', Remote is '{1}'.", this.getLocalParameters().getRole().toString(), remoteParameters.getRole().toString())));
            }
            this.getInnerTransport().removeOnReceive((IAction1<DataBuffer>)new IActionDelegate1<DataBuffer>(){

                @Override
                public String getId() {
                    return "fm.icelink.DtlsTransport.processReceive";
                }

                @Override
                public void invoke(DataBuffer buffer) {
                    DtlsTransport.this.processReceive(buffer);
                }
            });
            this.getInnerTransport().addOnReceive((IAction1<DataBuffer>)new IActionDelegate1<DataBuffer>(){

                @Override
                public String getId() {
                    return "fm.icelink.DtlsTransport.processReceive";
                }

                @Override
                public void invoke(DataBuffer buffer) {
                    DtlsTransport.this.processReceive(buffer);
                }
            });
            this.__dtlsHandshakeThread = new ManagedThread((IAction1<ManagedThread>)new IActionDelegate1<ManagedThread>(){

                @Override
                public String getId() {
                    return "fm.icelink.DtlsTransport.doDtls";
                }

                @Override
                public void invoke(ManagedThread thread) {
                    DtlsTransport.this.doDtls(thread);
                }
            });
            this.__dtlsHandshakeThread.start();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stop() {
        Object object = this.__lock;
        synchronized (object) {
            if (Global.equals((Object)this.getState(), (Object)DtlsTransportState.Closed) || Global.equals((Object)this.getState(), (Object)DtlsTransportState.Failed)) {
                return false;
            }
            this.setState(DtlsTransportState.Closed);
            return true;
        }
    }

    public void updateStats(TransportStats stats) {
        DtlsFingerprint fingerprint2;
        DtlsParameters remoteParameters;
        DtlsCertificate remoteCertificate;
        DtlsFingerprint fingerprint;
        DtlsParameters localParameters;
        DtlsCertificate certificate = this.get_LocalCertificate();
        if (certificate != null && (localParameters = this.getLocalParameters()) != null && (fingerprint = localParameters.getFingerprint()) != null) {
            CertificateStats stats2 = new CertificateStats();
            stats2.setId(certificate.getId());
            stats2.setTimestamp(DateExtensions.getUtcNow());
            stats2.setFingerprint(fingerprint.getValue());
            stats2.setFingerprintAlgorithm(fingerprint.getAlgorithm());
            stats2.setCertificateBase64(Base64.encode(certificate.getBytes()));
            stats.setLocalCertificate(stats2);
        }
        if ((remoteCertificate = this.getRemoteCertificate()) != null && (remoteParameters = this.getRemoteParameters()) != null && (fingerprint2 = remoteParameters.getFingerprint()) != null) {
            CertificateStats stats3 = new CertificateStats();
            stats3.setId(remoteCertificate.getId());
            stats3.setTimestamp(DateExtensions.getUtcNow());
            stats3.setFingerprint(fingerprint2.getValue());
            stats3.setFingerprintAlgorithm(fingerprint2.getAlgorithm());
            stats3.setCertificateBase64(Base64.encode(remoteCertificate.getBytes()));
            stats.setRemoteCertificate(stats3);
        }
    }
}

