/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.DataBuffer;
import fm.icelink.DtlsCertificate;
import fm.icelink.DtlsCipherSuite;
import fm.icelink.DtlsContentType;
import fm.icelink.DtlsFingerprint;
import fm.icelink.DtlsHandshakeType;
import fm.icelink.DtlsMessage;
import fm.icelink.DtlsProtocolVersion;
import fm.icelink.DtlsServerProtocol;
import fm.icelink.DtlsUdpTransport;
import fm.icelink.Error;
import fm.icelink.ErrorCode;
import fm.icelink.HashContextBase;
import fm.icelink.HashType;
import fm.icelink.IAction1;
import fm.icelink.Log;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import org.bouncycastle.crypto.tls.CertificateRequest;
import org.bouncycastle.crypto.tls.DTLSTransport;
import org.bouncycastle.crypto.tls.DefaultTlsEncryptionCredentials;
import org.bouncycastle.crypto.tls.DefaultTlsServer;
import org.bouncycastle.crypto.tls.DefaultTlsSignerCredentials;
import org.bouncycastle.crypto.tls.ProtocolVersion;
import org.bouncycastle.crypto.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.crypto.tls.TlsEncryptionCredentials;
import org.bouncycastle.crypto.tls.TlsExtensionsUtils;
import org.bouncycastle.crypto.tls.TlsFatalAlert;
import org.bouncycastle.crypto.tls.TlsSRTPUtils;
import org.bouncycastle.crypto.tls.TlsSignerCredentials;
import org.bouncycastle.crypto.tls.TlsUtils;
import org.bouncycastle.crypto.tls.UseSRTPData;

class DtlsServer
extends DefaultTlsServer {
    private boolean closed;
    private int[] supportedSrtpProtectionProfiles;
    private int[] clientSrtpProtectionProfiles;
    private int selectedSrtpProtectionProfile;
    public String remoteFingerprintAlgorithm;
    public String remoteFingerprint;
    private IAction1<DtlsCertificate> onRemoteCertificate;
    private byte[] receiveBuffer;
    private IAction1<DataBuffer> onDataDecrypted;
    private IAction1<Exception> onError;
    private DtlsCertificate certificate;
    private DtlsCipherSuite[] preferredCipherSuites;
    private DtlsProtocolVersion minVersion;
    private DtlsProtocolVersion maxVersion;
    private DtlsUdpTransport transport;
    private DtlsServerProtocol protocol;
    private DTLSTransport connection;
    private Object connectionLock;
    private List<DtlsMessage> handshakeFlight = new ArrayList<DtlsMessage>();

    public boolean getClosed() {
        return this.closed;
    }

    public int[] getSupportedSrtpProtectionProfiles() {
        return this.supportedSrtpProtectionProfiles;
    }

    public int[] getClientSrtpProtectionProfiles() {
        return this.clientSrtpProtectionProfiles;
    }

    public void setClientSrtpProtectionProfiles(int[] clientSrtpProtectionProfiles) {
        this.clientSrtpProtectionProfiles = clientSrtpProtectionProfiles;
    }

    public int getSelectedSrtpProtectionProfile() {
        return this.selectedSrtpProtectionProfile;
    }

    public String getRemoteFingerprintAlgorithm() {
        return this.remoteFingerprintAlgorithm;
    }

    public String getRemoteFingerprint() {
        return this.remoteFingerprint;
    }

    public IAction1<DtlsCertificate> getOnRemoteCertificate() {
        return this.onRemoteCertificate;
    }

    public void setOnDataDecrypted(IAction1<DataBuffer> callback) {
        this.onDataDecrypted = callback;
    }

    public void setOnError(IAction1<Exception> onError) {
        this.onError = onError;
    }

    public DtlsCertificate getCertificate() {
        return this.certificate;
    }

    public DtlsCipherSuite[] getPreferredCipherSuites() {
        return this.preferredCipherSuites;
    }

    public DtlsProtocolVersion getMinVersion() {
        return this.minVersion;
    }

    public DtlsProtocolVersion getMaxVersion() {
        return this.maxVersion;
    }

    public DtlsServer(DtlsCertificate certificate, DtlsCipherSuite[] cipherSuites, DtlsProtocolVersion minVersion, DtlsProtocolVersion maxVersion, DtlsFingerprint remoteFingerprint, int[] protectionProfiles, IAction1<DtlsCertificate> onRemoteCertificate) {
        this.certificate = certificate;
        this.preferredCipherSuites = cipherSuites;
        this.minVersion = minVersion;
        this.maxVersion = maxVersion;
        this.remoteFingerprintAlgorithm = remoteFingerprint.getAlgorithm();
        this.remoteFingerprint = remoteFingerprint.getValue();
        this.supportedSrtpProtectionProfiles = protectionProfiles;
        this.selectedSrtpProtectionProfile = -1;
        this.connectionLock = new Object();
        this.onRemoteCertificate = onRemoteCertificate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Error open(final IAction1<DataBuffer> sendCallback) {
        try {
            this.protocol = new DtlsServerProtocol();
            this.transport = new DtlsUdpTransport(new IAction1<byte[]>(){

                @Override
                public void invoke(byte[] packet) {
                    if (!DtlsServer.this.getClosed()) {
                        if (DtlsServer.this.connection == null) {
                            Log.debug(String.format(Locale.getDefault(), "Sending DTLS packet (%d bytes).", packet.length));
                            DtlsMessage[] messages = DtlsMessage.parseMultiple(DataBuffer.wrap(packet));
                            if (messages != null) {
                                for (DtlsMessage message : messages) {
                                    DtlsServer.this.handshakeFlight.add(message);
                                }
                            }
                            if (DtlsServer.this.handshakeFlight.size() >= 1) {
                                DtlsMessage secondLastMessage;
                                DtlsMessage lastMessage = (DtlsMessage)DtlsServer.this.handshakeFlight.get(DtlsServer.this.handshakeFlight.size() - 1);
                                if (lastMessage.getContentType() == DtlsContentType.getHandshake() && (lastMessage.getHandshakeType() == DtlsHandshakeType.getServerHelloDone() || lastMessage.getHandshakeType() == DtlsHandshakeType.getHelloRequest() || lastMessage.getHandshakeType() == DtlsHandshakeType.getHelloVerifyRequest())) {
                                    DtlsServer.this.sendHandshakeFlight(sendCallback);
                                } else if (DtlsServer.this.handshakeFlight.size() >= 2 && (secondLastMessage = (DtlsMessage)DtlsServer.this.handshakeFlight.get(DtlsServer.this.handshakeFlight.size() - 2)).getContentType() == DtlsContentType.getChangeCipherSpec() && lastMessage.getContentType() == DtlsContentType.getHandshake()) {
                                    DtlsServer.this.sendHandshakeFlight(sendCallback);
                                }
                            }
                        } else {
                            sendCallback.invoke(DataBuffer.wrap(packet));
                        }
                    }
                }
            });
            this.connection = this.protocol.accept(this, this.transport);
            Object object = this.connectionLock;
            synchronized (object) {
                this.receiveBuffer = new byte[this.connection.getReceiveLimit()];
                this.processReceived();
            }
            Error error = null;
            if (this.closed) {
                error = new Error(ErrorCode.DtlsKeyExchangeFailed, new Exception("Could not accept DTLS client connection."));
            }
            return error;
        }
        catch (Exception ex) {
            Error error = new Error(ErrorCode.DtlsKeyExchangeFailed, ex);
            return error;
        }
    }

    private void sendHandshakeFlight(IAction1<DataBuffer> sendCallback) {
        DataBuffer data = this.handshakeFlight.get(0).getRaw();
        for (int i = 1; i < this.handshakeFlight.size(); ++i) {
            data.append(this.handshakeFlight.get(i).getRaw());
        }
        this.handshakeFlight.clear();
        sendCallback.invoke(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(DataBuffer packet) {
        if (this.connection == null) {
            Log.debug(String.format(Locale.getDefault(), "Received DTLS packet (%d bytes).", packet.getLength()));
        }
        Object object = this.connectionLock;
        synchronized (object) {
            if (this.transport != null) {
                this.transport.push(packet);
            }
            this.processReceived();
        }
    }

    private void processReceived() {
        block4: {
            if (this.connection != null && this.receiveBuffer != null) {
                try {
                    int dataLength = 0;
                    while (dataLength != -1) {
                        dataLength = this.connection.receive(this.receiveBuffer, 0, this.receiveBuffer.length, 0);
                        if (dataLength <= 0) continue;
                        this.onDataDecrypted.invoke(DataBuffer.wrap(this.receiveBuffer, 0, dataLength));
                    }
                }
                catch (Exception ex) {
                    IAction1<Exception> handler = this.onError;
                    if (handler == null) break block4;
                    handler.invoke(new Exception(String.format("DTLS server could not process incoming message.", ex.getMessage())));
                }
            }
        }
    }

    public void send(DataBuffer packet) {
        block3: {
            if (this.connection != null) {
                try {
                    this.connection.send(packet.getData(), packet.getIndex(), packet.getLength());
                }
                catch (Exception ex) {
                    IAction1<Exception> handler = this.onError;
                    if (handler == null) break block3;
                    handler.invoke(new Exception(String.format("DTLS server could not process outgoing message.", ex.getMessage())));
                }
            }
        }
    }

    public void close() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.connection = null;
        }
        if (this.protocol != null) {
            try {
                this.protocol.cancel();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.protocol = null;
        }
        if (this.transport != null) {
            try {
                this.transport.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.transport = null;
        }
        this.closed = true;
    }

    public byte[] getKeyingMaterial() {
        return this.context.exportKeyingMaterial("EXTRACTOR-dtls_srtp", null, 60);
    }

    public void notifyAlertRaised(byte alertLevel, byte alertDescription, String message, Exception cause) {
        if (!this.closed) {
            IAction1<Exception> handler;
            boolean raiseError = false;
            String causeText = cause == null ? "" : String.format(", Inner exception: %s", cause.getMessage());
            String text = String.format(Locale.getDefault(), "DTLS server raised alert. (Level: %s, Description: %s, Message: '%s'%s)", String.valueOf(alertLevel), String.valueOf(alertDescription), message, causeText);
            if (alertLevel == 1) {
                if (alertDescription == 0) {
                    text = "Local DTLS server closed connection.";
                    if (cause == null) {
                        Log.debug(text);
                    } else {
                        Log.debug(text, cause);
                    }
                    raiseError = false;
                } else if (cause == null) {
                    Log.warn(text);
                } else {
                    Log.warn(text, cause);
                }
            } else if (alertLevel == 2) {
                raiseError = true;
            } else if (cause == null) {
                Log.debug(text);
            } else {
                Log.debug(text, cause);
            }
            if (raiseError && (handler = this.onError) != null) {
                handler.invoke(new Exception(text));
            }
        }
    }

    public void notifyAlertReceived(byte alertLevel, byte alertDescription) {
        if (!this.closed) {
            IAction1<Exception> handler;
            boolean raiseError = false;
            String text = String.format(Locale.getDefault(), "DTLS server received alert. (Level: %s, Description: %s)", String.valueOf(alertLevel), String.valueOf(alertDescription));
            if (alertLevel == 1) {
                if (alertDescription == 0) {
                    text = "Remote DTLS client closed connection.";
                    Log.debug(text);
                    raiseError = false;
                } else {
                    Log.warn(text);
                }
            } else if (alertLevel == 2) {
                raiseError = true;
            } else {
                Log.debug(text);
            }
            if (raiseError && (handler = this.onError) != null) {
                this.onError.invoke(new Exception(text));
            }
        }
    }

    @Override
    protected int[] getCipherSuites() {
        int count = this.getPreferredCipherSuites().length;
        int[] cipherSuites = new int[count];
        for (int i = 0; i < count; ++i) {
            cipherSuites[i] = DtlsServer.convertCipherSuite(this.getPreferredCipherSuites()[i]);
        }
        return cipherSuites;
    }

    private static int convertCipherSuite(DtlsCipherSuite cipherSuite) {
        if (cipherSuite == DtlsCipherSuite.Aes128Sha) {
            return 47;
        }
        if (cipherSuite == DtlsCipherSuite.DhRsaAes128Sha) {
            return 49;
        }
        if (cipherSuite == DtlsCipherSuite.EcdhRsaAes128Sha) {
            return 49166;
        }
        if (cipherSuite == DtlsCipherSuite.DheRsaAes128Sha) {
            return 51;
        }
        if (cipherSuite == DtlsCipherSuite.EcdheRsaAes128Sha) {
            return 49171;
        }
        if (cipherSuite == DtlsCipherSuite.EcdheEcdsaAes128Sha) {
            return 49161;
        }
        if (cipherSuite == DtlsCipherSuite.Aes128GcmSha256) {
            return 156;
        }
        if (cipherSuite == DtlsCipherSuite.DhRsaAes128GcmSha256) {
            return 160;
        }
        if (cipherSuite == DtlsCipherSuite.EcdhRsaAes128GcmSha256) {
            return 49201;
        }
        if (cipherSuite == DtlsCipherSuite.DheRsaAes128GcmSha256) {
            return 158;
        }
        if (cipherSuite == DtlsCipherSuite.EcdheRsaAes128GcmSha256) {
            return 49199;
        }
        if (cipherSuite == DtlsCipherSuite.EcdheEcdsaAes128GcmSha256) {
            return 49195;
        }
        return -1;
    }

    @Override
    public CertificateRequest getCertificateRequest() {
        short[] certificateTypes = new short[]{1};
        Vector serverSigAlgs = null;
        if (TlsUtils.isSignatureAlgorithmsExtensionAllowed(this.serverVersion)) {
            serverSigAlgs = TlsUtils.getDefaultSupportedSignatureAlgorithms();
        }
        return new CertificateRequest(certificateTypes, serverSigAlgs, null);
    }

    @Override
    public void notifyClientCertificate(org.bouncycastle.crypto.tls.Certificate clientCertificate) throws IOException {
        if (clientCertificate == null) {
            throw new TlsFatalAlert(42);
        }
        Certificate[] certificates = clientCertificate.getCertificateList();
        if (certificates == null || certificates.length == 0) {
            throw new TlsFatalAlert(42);
        }
        Certificate cert = certificates[0];
        String fingerprint = null;
        if (this.remoteFingerprintAlgorithm.toLowerCase().equals("sha2") || this.remoteFingerprintAlgorithm.toLowerCase().equals("sha256") || this.remoteFingerprintAlgorithm.toLowerCase().equals("sha-256")) {
            fingerprint = HashContextBase.compute(HashType.Sha256, DataBuffer.wrap(cert.getEncoded())).toHexString();
        } else if (this.remoteFingerprintAlgorithm.toLowerCase().equals("sha") || this.remoteFingerprintAlgorithm.toLowerCase().equals("sha1") || this.remoteFingerprintAlgorithm.toLowerCase().equals("sha-1")) {
            fingerprint = HashContextBase.compute(HashType.Sha1, DataBuffer.wrap(cert.getEncoded())).toHexString();
        } else {
            throw new TlsFatalAlert(49);
        }
        if (!fingerprint.toLowerCase().equals(this.remoteFingerprint.replace(":", "").toLowerCase())) {
            throw new TlsFatalAlert(49);
        }
    }

    @Override
    public void processClientExtensions(Hashtable clientExtensions) throws IOException {
        UseSRTPData useSrtp;
        super.processClientExtensions(clientExtensions);
        if (clientExtensions != null && this.supportedSrtpProtectionProfiles != null && (useSrtp = TlsSRTPUtils.getUseSRTPExtension(clientExtensions)) != null) {
            IAction1<Exception> handler;
            if (useSrtp.getProtectionProfiles() == null || useSrtp.getProtectionProfiles().length == 0) {
                throw new TlsFatalAlert(50);
            }
            this.clientSrtpProtectionProfiles = useSrtp.getProtectionProfiles();
            if (!this.selectSrtpProtectionProfile() && (handler = this.onError) != null) {
                handler.invoke(new Exception("DTLS server could not select an SRTP protection profile."));
            }
        }
    }

    private boolean selectSrtpProtectionProfile() {
        for (int supportedSrtpProtectionProfile : this.supportedSrtpProtectionProfiles) {
            for (int clientSrtpProtectionProfile : this.clientSrtpProtectionProfiles) {
                if (clientSrtpProtectionProfile != supportedSrtpProtectionProfile) continue;
                this.selectedSrtpProtectionProfile = clientSrtpProtectionProfile;
                return true;
            }
        }
        return false;
    }

    @Override
    public Hashtable getServerExtensions() throws IOException {
        Hashtable serverExtensions = TlsExtensionsUtils.ensureExtensionsInitialised(super.getServerExtensions());
        if (this.selectedSrtpProtectionProfile >= 0 && this.supportedSrtpProtectionProfiles != null) {
            TlsSRTPUtils.addUseSRTPExtension(serverExtensions, new UseSRTPData(new int[]{this.selectedSrtpProtectionProfile}, new byte[0]));
        }
        return serverExtensions;
    }

    @Override
    protected ProtocolVersion getMaximumVersion() {
        if (this.maxVersion == DtlsProtocolVersion.Dtls10) {
            return ProtocolVersion.DTLSv10;
        }
        return ProtocolVersion.DTLSv12;
    }

    @Override
    protected ProtocolVersion getMinimumVersion() {
        if (this.minVersion == DtlsProtocolVersion.Dtls12) {
            return ProtocolVersion.DTLSv12;
        }
        return ProtocolVersion.DTLSv10;
    }

    @Override
    protected TlsEncryptionCredentials getRSAEncryptionCredentials() {
        RSAPrivateCrtKeyParameters privateKey = new RSAPrivateCrtKeyParameters(new BigInteger(1, this.certificate.getKey().getModulus()), new BigInteger(1, this.certificate.getKey().getPublicExponent()), new BigInteger(1, this.certificate.getKey().getPrivateExponent()), new BigInteger(1, this.certificate.getKey().getPrime1()), new BigInteger(1, this.certificate.getKey().getPrime2()), new BigInteger(1, this.certificate.getKey().getExponent1()), new BigInteger(1, this.certificate.getKey().getExponent2()), new BigInteger(1, this.certificate.getKey().getCoefficient()));
        try {
            byte[] certificateBytes = this.certificate.getBytes();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            int length = certificateBytes.length;
            TlsUtils.writeUint24(length + 3, bos);
            TlsUtils.writeUint24(length, bos);
            bos.write(certificateBytes, 0, certificateBytes.length);
            org.bouncycastle.crypto.tls.Certificate certificate = org.bouncycastle.crypto.tls.Certificate.parse(new ByteArrayInputStream(bos.toByteArray()));
            return new DefaultTlsEncryptionCredentials(this.context, certificate, privateKey);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    protected TlsSignerCredentials getRSASignerCredentials() {
        SignatureAndHashAlgorithm signatureAndHashAlgorithm = null;
        if (this.supportedSignatureAlgorithms != null) {
            for (SignatureAndHashAlgorithm alg : this.supportedSignatureAlgorithms) {
                if (alg.getSignature() != 1) continue;
                signatureAndHashAlgorithm = alg;
                break;
            }
            if (signatureAndHashAlgorithm == null) {
                return null;
            }
        }
        RSAPrivateCrtKeyParameters privateKey = new RSAPrivateCrtKeyParameters(new BigInteger(1, this.certificate.getKey().getModulus()), new BigInteger(1, this.certificate.getKey().getPublicExponent()), new BigInteger(1, this.certificate.getKey().getPrivateExponent()), new BigInteger(1, this.certificate.getKey().getPrime1()), new BigInteger(1, this.certificate.getKey().getPrime2()), new BigInteger(1, this.certificate.getKey().getExponent1()), new BigInteger(1, this.certificate.getKey().getExponent2()), new BigInteger(1, this.certificate.getKey().getCoefficient()));
        try {
            byte[] certificateBytes = this.certificate.getBytes();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            int length = certificateBytes.length;
            TlsUtils.writeUint24(length + 3, bos);
            TlsUtils.writeUint24(length, bos);
            bos.write(certificateBytes, 0, certificateBytes.length);
            org.bouncycastle.crypto.tls.Certificate certificate = org.bouncycastle.crypto.tls.Certificate.parse(new ByteArrayInputStream(bos.toByteArray()));
            return new DefaultTlsSignerCredentials(this.context, certificate, privateKey, signatureAndHashAlgorithm);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

