/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.BitAssistant;
import fm.icelink.DataBuffer;
import fm.icelink.DataBufferPool;

public class CircularDataBuffer
extends DataBuffer {
    private DataBuffer __innerPooledBuffer;
    private int __lastWriteSize;
    private boolean __writeFlag;

    public void appendDataBuffer(DataBuffer buffer) {
        int destinationIndex = this.beginWrite(buffer.getLength());
        BitAssistant.copy(buffer.getData(), buffer.getIndex(), this.getData(), destinationIndex, buffer.getLength());
        this.endWrite(buffer.getLength());
    }

    public int beginWrite(int maxWriteSize) {
        if (this.__writeFlag) {
            throw new RuntimeException(new Exception("Must call EndWrite before calling BeginWrite again."));
        }
        if (maxWriteSize < 1) {
            throw new RuntimeException(new Exception("Must be a positive number greater than 1."));
        }
        int size = super.getLength() + maxWriteSize;
        if (size > ArrayExtensions.getLength(this.getData())) {
            DataBuffer buffer = this.__innerPooledBuffer;
            DataBuffer buffer2 = DataBufferPool.getInstance().take(size);
            BitAssistant.copy(this.__innerPooledBuffer.getData(), super.getIndex(), buffer2.getData(), 0, super.getLength());
            this.__innerPooledBuffer = buffer2;
            buffer.free();
            super.setIndex(0);
        }
        this.__writeFlag = true;
        this.__lastWriteSize = maxWriteSize;
        if (size + super.getIndex() > ArrayExtensions.getLength(this.getData())) {
            BitAssistant.copy(this.__innerPooledBuffer.getData(), super.getIndex(), this.__innerPooledBuffer.getData(), 0, super.getLength());
            super.setIndex(0);
        }
        int num2 = super.getLength() + super.getIndex();
        super.setLength(size);
        return num2;
    }

    CircularDataBuffer(DataBuffer innerBuffer) {
        super(null, 0, 0, false);
        this.__innerPooledBuffer = innerBuffer;
    }

    public static CircularDataBuffer create(int initialSize) {
        return new CircularDataBuffer(DataBufferPool.getInstance().take(initialSize));
    }

    public void discard(int amount) {
        if (this.__writeFlag) {
            throw new RuntimeException(new Exception("Cannot discard in the middle of a write."));
        }
        if (amount < 0) {
            throw new RuntimeException(new Exception("Amount must be greater or equal to 0."));
        }
        int num = super.getIndex() + amount;
        if (amount > super.getLength()) {
            throw new RuntimeException(new Exception("Amount is greater than the amount of remaining data."));
        }
        super.setIndex(num);
        super.setLength(super.getLength() - amount);
    }

    public void endWrite(int actuallyWrittenSize) {
        if (!this.__writeFlag) {
            throw new RuntimeException(new Exception("Must call BeginWrite before calling EndWrite."));
        }
        if (actuallyWrittenSize < 0) {
            throw new RuntimeException(new Exception("Value must be greater or equal to 0."));
        }
        this.__writeFlag = false;
        int num = this.__lastWriteSize - actuallyWrittenSize;
        super.setLength(super.getLength() - num);
    }

    @Override
    public void free() {
        this.__innerPooledBuffer.free();
        this.__innerPooledBuffer = null;
    }

    public int getCapacity() {
        return ArrayExtensions.getLength(this.getData());
    }

    @Override
    public byte[] getData() {
        return this.__innerPooledBuffer.getData();
    }
}

