/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.AtomicLong;
import fm.icelink.AudioFormat;
import fm.icelink.AudioFrame;
import fm.icelink.AudioPipe;
import fm.icelink.Global;
import fm.icelink.IAudioOutput;
import fm.icelink.MediaTrackStats;

public abstract class AudioPacketizer
extends AudioPipe {
    private AtomicLong __framesSent = new AtomicLong();

    public AudioPacketizer(AudioFormat inputFormat, AudioFormat outputFormat) {
        super(inputFormat == null ? inputFormat : AudioPacketizer.cloneFormat(inputFormat, false, inputFormat.getLittleEndian()), outputFormat == null ? null : AudioPacketizer.cloneFormat(outputFormat, true, !Global.equals(inputFormat, outputFormat) && outputFormat.getLittleEndian()));
    }

    public AudioPacketizer(AudioFormat format) {
        this(format, format);
    }

    public AudioPacketizer(IAudioOutput input) {
        this((AudioFormat)input.getOutputFormat());
        super.addInput(input);
    }

    private static AudioFormat cloneFormat(AudioFormat format, boolean isPacketized, boolean littleEndian) {
        AudioFormat format2 = format.clone();
        format2.setIsPacketized(isPacketized);
        format2.setLittleEndian(littleEndian);
        return format2;
    }

    @Override
    protected void doProcessStatsFromOutput(MediaTrackStats stats) {
        super.doProcessStatsFromOutput(stats);
        stats.setFramesSent(this.getFramesSent());
    }

    public long getFramesSent() {
        return this.__framesSent.getValue();
    }

    @Override
    public boolean processFrame(AudioFrame frame) {
        this.__framesSent.increment();
        return super.processFrame(frame);
    }
}

