/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.AudioFormat;
import fm.icelink.DataBuffer;
import fm.icelink.Global;
import fm.icelink.Log;
import fm.icelink.MathAssistant;
import fm.icelink.MediaBuffer;
import fm.icelink.SoundUtility;
import fm.icelink.StringExtensions;

public class AudioBuffer
extends MediaBuffer<AudioFormat, AudioBuffer> {
    private double __gain = 1.0;
    private boolean __isMuted;
    private boolean _generatedByPlc;

    public void applyGain(double gain) {
        if (!this.getIsPcm()) {
            throw new RuntimeException(new Exception("Only PCM audio buffers can have their gain adjusted."));
        }
        if (gain != 1.0) {
            for (DataBuffer buffer : super.getDataBuffers()) {
                for (int i = 0; i < buffer.getLength(); i += 2) {
                    double num2 = buffer.read16Signed(i);
                    if ((num2 *= gain) > 32767.0) {
                        num2 = 32767.0;
                    }
                    if (num2 < -32768.0) {
                        num2 = -32768.0;
                    }
                    buffer.write16((short)num2, i);
                }
            }
            this.__gain *= gain;
        }
    }

    public AudioBuffer(DataBuffer dataBuffer, AudioFormat format) {
        super(dataBuffer, format);
        this.initBuffer();
    }

    public AudioBuffer(DataBuffer[] dataBuffers, AudioFormat format) {
        super(dataBuffers, format);
        this.initBuffer();
    }

    private AudioBuffer() {
    }

    public double calculateLevel() {
        if (!Global.equals(((AudioFormat)super.getFormat()).getName(), AudioFormat.getPcmName())) {
            throw new RuntimeException(new Exception("Only PCM audio buffers can have their level calculated."));
        }
        double num = 0.0;
        int num2 = 0;
        for (DataBuffer buffer : super.getDataBuffers()) {
            num2 += buffer.getLength() / 2;
            for (int i = 0; i < buffer.getLength(); i += 2) {
                short num4 = (short)buffer.read16Signed(i);
                num += MathAssistant.pow(SoundUtility.floatFromShort(num4), 2.0);
            }
        }
        return MathAssistant.sqrt(num / (double)num2);
    }

    @Override
    public AudioBuffer clone() {
        AudioBuffer buffer = (AudioBuffer)super.clone();
        buffer.__gain = this.__gain;
        buffer.__isMuted = this.__isMuted;
        return buffer;
    }

    @Override
    protected AudioBuffer createInstance() {
        return new AudioBuffer();
    }

    public double getGain() {
        return this.__gain;
    }

    public boolean getGeneratedByPlc() {
        return this._generatedByPlc;
    }

    @Override
    public boolean getIsMuted() {
        return this.__isMuted;
    }

    public boolean getIsOpus() {
        AudioFormat format = (AudioFormat)super.getFormat();
        return format != null && format.getIsOpus();
    }

    public boolean getIsPcm() {
        AudioFormat format = (AudioFormat)super.getFormat();
        return format != null && format.getIsPcm();
    }

    public boolean getIsPcma() {
        AudioFormat format = (AudioFormat)super.getFormat();
        return format != null && format.getIsPcma();
    }

    public boolean getIsPcmu() {
        AudioFormat format = (AudioFormat)super.getFormat();
        return format != null && format.getIsPcmu();
    }

    private void initBuffer() {
        for (DataBuffer buffer : super.getDataBuffers()) {
            if (((AudioFormat)super.getFormat()).getLittleEndian() && !buffer.getLittleEndian()) {
                Log.warn(StringExtensions.format("Format ({0}) requires little endian, but data buffer is big endian. Will switch data buffer to little endian.", ((AudioFormat)super.getFormat()).getFullName()));
            }
            if (!((AudioFormat)super.getFormat()).getLittleEndian() && buffer.getLittleEndian()) {
                Log.warn(StringExtensions.format("Format ({0}) requires big endian, but data buffer is little endian. Will switch data buffer to big endian.", ((AudioFormat)super.getFormat()).getFullName()));
            }
            buffer.setLittleEndian(((AudioFormat)super.getFormat()).getLittleEndian());
        }
    }

    @Override
    public boolean mute() {
        if (!this.__isMuted) {
            if (Global.equals(((AudioFormat)super.getFormat()).getName(), AudioFormat.getPcmName())) {
                for (DataBuffer buffer : super.getDataBuffers()) {
                    buffer.set((byte)0);
                }
            } else {
                return false;
            }
            this.__isMuted = true;
        }
        return true;
    }

    public void setGeneratedByPlc(boolean value) {
        this._generatedByPlc = value;
    }
}

