/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.android;

import android.bluetooth.BluetoothAdapter;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioManager;
import android.media.AudioRecord;
import android.media.audiofx.AcousticEchoCanceler;
import android.media.audiofx.AutomaticGainControl;
import android.media.audiofx.NoiseSuppressor;
import android.os.Build;
import android.os.Process;
import fm.icelink.AudioBuffer;
import fm.icelink.AudioConfig;
import fm.icelink.AudioFormat;
import fm.icelink.AudioFrame;
import fm.icelink.AudioSource;
import fm.icelink.DataBuffer;
import fm.icelink.DataBufferPool;
import fm.icelink.Future;
import fm.icelink.IAction0;
import fm.icelink.IAction1;
import fm.icelink.Log;
import fm.icelink.ManagedThread;
import fm.icelink.Promise;
import fm.icelink.SourceInput;
import fm.icelink.pcm.Format;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public class AudioRecordSource
extends AudioSource {
    private int audioSource = 7;
    private boolean useAcousticEchoCanceler = false;
    private boolean useAutomaticGainControl = true;
    private boolean useNoiseSuppressor = true;
    private AudioManager audioManager;
    private HeadSetReceiver myReceiver;
    private static final int phoneSpeaker = 0;
    private static final int wiredHeadSet = 1;
    private int localAudioOutlet = 0;
    private static Set<String> voiceCommunicationBlackList = new HashSet<String>(Arrays.asList("Nexus 5", "Nexus 9", "SC-04E", "GT-I9500", "SCH-I959", "SHV-E300K", "SHV-E300L", "SHV-E300S", "GT-I9505", "GT-I9508", "GT-I9508C", "SGH-M919N", "SAMSUNG-SGH-I337Z", "SAMSUNG-SGH-I337", "SGH-I337M", "SGH-M919V", "SCH-R970C", "SCH-R970X", "SCH-I545L", "SPH-L720T", "SPH-L720", "SM-S975L", "SGH-S970G", "SGH-M919", "SCH-R970", "SCH-I545", "SCH-I545PP", "GT-I9507", "GT-I9507V", "GT-I9515", "GT-I9515L", "GT-I9505X", "GT-I9508V", "GT-I9506", "SHV-E330K", "SHV-E330L", "SC-04F", "SCL23", "SM-G900H", "SM-G9008W", "SM-G9009W", "SM-G900F", "SM-G900FQ", "SM-G900I", "SM-G900M", "SM-G900MD", "SM-G900T1", "SM-G900T4", "SM-G900R7", "SAMSUNG-SM-G900AZ", "SAMSUNG-SM-G900A", "SM-G900W8", "SM-G9006W", "SM-G900K", "SM-G900L", "SM-G900R6", "SM-G900S", "SM-G900P", "SM-S903VL", "SM-G900T", "SM-G900T3", "SM-G900R4", "SM-G900V", "SM-G900X", "SM-G906K", "SM-G906L", "SM-G906S", "HUAWEI Y530-U051"));
    private Context context;
    private HeadsetStateReceiver headsetStateReceiver;
    private AudioRecord audioRecord = null;
    private AcousticEchoCanceler aec = null;
    private AutomaticGainControl agc = null;
    private NoiseSuppressor ns = null;
    private int bufferLength = 0;
    private volatile boolean isCapturing;
    private volatile boolean isStopped;

    public static void addDeviceToVoiceCommunicationBlackList(String deviceModel) {
        voiceCommunicationBlackList.add(deviceModel);
    }

    public static void removeDeviceFromVoiceCommunicationBlackList(String deviceModel) {
        voiceCommunicationBlackList.remove(deviceModel);
    }

    public static String[] getVoiceCommunicationBlackList() {
        return voiceCommunicationBlackList.toArray(new String[voiceCommunicationBlackList.size()]);
    }

    public int getAudioSource() {
        return this.audioSource;
    }

    public void setAudioSource(int audioSource) {
        this.audioSource = audioSource;
    }

    public boolean getUseAcousticEchoCanceler() {
        return this.useAcousticEchoCanceler;
    }

    public void setUseAcousticEchoCanceler(boolean useAcousticEchoCanceler) {
        this.useAcousticEchoCanceler = useAcousticEchoCanceler;
    }

    public boolean getUseAutomaticGainControl() {
        return this.useAutomaticGainControl;
    }

    public void setUseAutomaticGainControl(boolean useAutomaticGainControl) {
        this.useAutomaticGainControl = useAutomaticGainControl;
    }

    public boolean getUseNoiseSuppressor() {
        return this.useNoiseSuppressor;
    }

    public void setUseNoiseSuppressor(boolean useNoiseSuppressor) {
        this.useNoiseSuppressor = useNoiseSuppressor;
    }

    public static int getBufferDelay(AudioConfig config) {
        int clockRate = config.getClockRate();
        int channelCount = config.getChannelCount();
        int channelConfig = channelCount == 1 ? 16 : 12;
        int minBufferSizeInBytes = AudioRecord.getMinBufferSize((int)clockRate, (int)channelConfig, (int)2);
        int bytesPerMilli = clockRate * channelCount * 2 / 1000;
        return minBufferSizeInBytes / bytesPerMilli;
    }

    public Future<SourceInput[]> getInputs() {
        Promise promise = new Promise();
        promise.resolve((Object)new SourceInput[0]);
        return promise;
    }

    public String getLabel() {
        return "Android AudioRecord Source";
    }

    public AudioRecordSource(Context context, AudioConfig config) {
        super((AudioFormat)new Format(config));
        if (context == null) {
            throw new RuntimeException("Context cannot be null.");
        }
        if (context.checkCallingOrSelfPermission("android.permission.RECORD_AUDIO") != 0) {
            throw new RuntimeException("Audio capture permission has not been granted. Please add android.permission.RECORD_AUDIO to your application manifest.");
        }
        if (voiceCommunicationBlackList.contains(Build.MODEL)) {
            this.audioSource = 1;
            Log.info((String)"MIC mode is being used.");
        }
        this.context = context.getApplicationContext();
        if (this.getAudioSource() == 7) {
            this.audioManager = (AudioManager)this.context.getSystemService("audio");
            this.audioManager.setMode(3);
            this.audioManager.setSpeakerphoneOn(true);
            this.audioManager.setWiredHeadsetOn(false);
            this.localAudioOutlet = 0;
            this.myReceiver = new HeadSetReceiver();
            IntentFilter filter = new IntentFilter();
            filter.addAction("android.intent.action.HEADSET_PLUG");
            filter.addAction("android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED");
            this.context.registerReceiver((BroadcastReceiver)this.myReceiver, filter);
            if (this.isBluetoothHeadsetConnected()) {
                this.routeToBluetoothHeadset();
            }
        } else {
            this.headsetStateReceiver = new HeadsetStateReceiver(this);
            this.context.registerReceiver((BroadcastReceiver)this.headsetStateReceiver, new IntentFilter("android.intent.action.HEADSET_PLUG"));
        }
    }

    public boolean destroy() {
        if (this.headsetStateReceiver != null) {
            this.context.unregisterReceiver((BroadcastReceiver)this.headsetStateReceiver);
            this.headsetStateReceiver = null;
        }
        if (this.myReceiver != null) {
            this.context.unregisterReceiver((BroadcastReceiver)this.myReceiver);
            this.myReceiver = null;
        }
        return super.destroy();
    }

    public boolean isBluetoothHeadsetConnected() {
        BluetoothAdapter mBluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        return mBluetoothAdapter != null && mBluetoothAdapter.isEnabled() && mBluetoothAdapter.getProfileConnectionState(1) == 2;
    }

    public void routeToBluetoothHeadset() {
        this.audioManager.setSpeakerphoneOn(false);
        this.audioManager.setWiredHeadsetOn(false);
        this.audioManager.setBluetoothScoOn(true);
        this.audioManager.startBluetoothSco();
    }

    protected Future<Object> doStart() {
        final Promise promise = new Promise();
        ManagedThread.dispatch((IAction0)new IAction0(){

            public void invoke() {
                try {
                    int clockRate = ((AudioFormat)AudioRecordSource.this.getOutputFormat()).getClockRate();
                    int channelCount = ((AudioFormat)AudioRecordSource.this.getOutputFormat()).getChannelCount();
                    int channelConfig = channelCount == 1 ? 16 : 12;
                    int minBufferSizeInBytes = AudioRecord.getMinBufferSize((int)clockRate, (int)channelConfig, (int)2);
                    if (minBufferSizeInBytes == 0) {
                        throw new Exception("Audio capture min buffer size must be greater than 0.");
                    }
                    AudioRecordSource.this.bufferLength = minBufferSizeInBytes;
                    AudioRecordSource.this.audioRecord = new AudioRecord(AudioRecordSource.this.getAudioSource(), clockRate, channelConfig, 2, AudioRecordSource.this.bufferLength);
                    if (AudioRecordSource.this.audioRecord.getState() != 1) {
                        throw new Exception("Could not start audio capture using specified configuration.");
                    }
                    if (Build.VERSION.SDK_INT >= 16) {
                        try {
                            if (AudioRecordSource.this.getUseAcousticEchoCanceler() && AcousticEchoCanceler.isAvailable()) {
                                AudioRecordSource.this.aec = AcousticEchoCanceler.create((int)AudioRecordSource.this.audioRecord.getAudioSessionId());
                                if (AudioRecordSource.this.aec != null) {
                                    if (!AudioRecordSource.this.aec.getEnabled()) {
                                        AudioRecordSource.this.aec.setEnabled(true);
                                    }
                                    if (AudioRecordSource.this.aec.getEnabled()) {
                                        Log.info((String)"Acoustic echo canceler is active.");
                                    } else {
                                        Log.warn((String)"Acoustic echo canceler was created, but could not be enabled.");
                                    }
                                } else {
                                    Log.warn((String)"Acoustic echo canceler is available, but could not be created.");
                                }
                            } else {
                                Log.info((String)"Acoustic echo canceler is not available.");
                            }
                        }
                        catch (Exception ex) {
                            Log.error((String)String.format(Locale.getDefault(), "Acoustic echo canceler could not be enabled. %s", ex.getMessage()));
                        }
                        try {
                            if (AudioRecordSource.this.getUseAutomaticGainControl() && AutomaticGainControl.isAvailable()) {
                                AudioRecordSource.this.agc = AutomaticGainControl.create((int)AudioRecordSource.this.audioRecord.getAudioSessionId());
                                if (AudioRecordSource.this.agc != null) {
                                    if (!AudioRecordSource.this.agc.getEnabled()) {
                                        AudioRecordSource.this.agc.setEnabled(true);
                                    }
                                    if (AudioRecordSource.this.agc.getEnabled()) {
                                        Log.info((String)"Automatic gain control is active.");
                                    } else {
                                        Log.warn((String)"Automatic gain control was created, but could not be enabled.");
                                    }
                                } else {
                                    Log.warn((String)"Automatic gain control is available, but could not be created.");
                                }
                            } else {
                                Log.info((String)"Automatic gain control is not available.");
                            }
                        }
                        catch (Exception ex) {
                            Log.error((String)String.format(Locale.getDefault(), "Automatic gain control could not be enabled. %s", ex.getMessage()));
                        }
                        try {
                            if (AudioRecordSource.this.getUseNoiseSuppressor() && NoiseSuppressor.isAvailable()) {
                                AudioRecordSource.this.ns = NoiseSuppressor.create((int)AudioRecordSource.this.audioRecord.getAudioSessionId());
                                if (AudioRecordSource.this.ns != null) {
                                    if (!AudioRecordSource.this.ns.getEnabled()) {
                                        AudioRecordSource.this.ns.setEnabled(true);
                                    }
                                    if (AudioRecordSource.this.ns.getEnabled()) {
                                        Log.info((String)"Noise suppressor is active.");
                                    } else {
                                        Log.warn((String)"Noise suppressor was created, but could not be enabled.");
                                    }
                                } else {
                                    Log.warn((String)"Noise suppressor is available, but could not be created.");
                                }
                            } else {
                                Log.info((String)"Noise suppressor is not available.");
                            }
                        }
                        catch (Exception ex) {
                            Log.error((String)String.format(Locale.getDefault(), "Noise suppressor could not be enabled. %s", ex.getMessage()));
                        }
                    }
                    AudioRecordSource.this.audioRecord.startRecording();
                    AudioRecordSource.this.isCapturing = true;
                    AudioRecordSource.this.isStopped = false;
                    ManagedThread thread = new ManagedThread((IAction1)new IAction1<ManagedThread>(){

                        public void invoke(ManagedThread thread) {
                            AudioRecordSource.this.captureLoop();
                        }
                    });
                    thread.start();
                    promise.resolve(null);
                }
                catch (Exception ex) {
                    promise.reject(ex);
                }
            }
        });
        return promise;
    }

    protected Future<Object> doStop() {
        final Promise promise = new Promise();
        ManagedThread.dispatch((IAction0)new IAction0(){

            public void invoke() {
                try {
                    AudioRecordSource.this.isCapturing = false;
                    while (!AudioRecordSource.this.isStopped) {
                        ManagedThread.sleep((int)10);
                    }
                    if (AudioRecordSource.this.audioRecord != null) {
                        AudioRecordSource.this.audioRecord.stop();
                    }
                    try {
                        if (AudioRecordSource.this.aec != null) {
                            AudioRecordSource.this.aec.release();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        if (AudioRecordSource.this.agc != null) {
                            AudioRecordSource.this.agc.release();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        if (AudioRecordSource.this.ns != null) {
                            AudioRecordSource.this.ns.release();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (AudioRecordSource.this.audioRecord != null) {
                        AudioRecordSource.this.audioRecord.release();
                    }
                    promise.resolve(null);
                }
                catch (Exception ex) {
                    promise.reject(ex);
                }
            }
        });
        return promise;
    }

    private void captureLoop() {
        int byteLength;
        int clockRate = ((AudioFormat)this.getOutputFormat()).getClockRate();
        int channelCount = ((AudioFormat)this.getOutputFormat()).getChannelCount();
        if (Process.getThreadPriority((int)Process.myTid()) != -19) {
            Process.setThreadPriority((int)-19);
        }
        if ((byteLength = (int)((float)(channelCount * clockRate) * 0.1f * 2.0f)) < this.bufferLength) {
            byteLength = this.bufferLength;
        }
        while (this.isCapturing) {
            DataBuffer dataBuffer = DataBufferPool.getInstance().take(byteLength);
            int count1 = this.audioRecord.read(dataBuffer.getData(), dataBuffer.getIndex(), byteLength);
            if (count1 > 0) {
                try {
                    dataBuffer.setLittleEndian(true);
                    AudioBuffer ex = new AudioBuffer(dataBuffer.subset(0, count1), (AudioFormat)this.getOutputFormat());
                    this.raiseFrame(new AudioFrame((double)this.calculateDuration(dataBuffer.getLength()), ex));
                }
                catch (Exception var8) {
                    Log.error((String)"Could not raise frame from AudioRecordSource.", (Exception)var8);
                }
            }
            dataBuffer.free();
        }
        this.isStopped = true;
    }

    class HeadsetStateReceiver
    extends BroadcastReceiver {
        private AudioSource source;

        public HeadsetStateReceiver(AudioSource source) {
            this.source = source;
        }

        public void onReceive(Context arg0, Intent arg1) {
            this.source.setForceTimestampReset(true);
        }
    }

    private class HeadSetReceiver
    extends BroadcastReceiver {
        private HeadSetReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            int state;
            AudioRecordSource.this.setForceTimestampReset(true);
            if (intent.getAction().equals("android.intent.action.HEADSET_PLUG")) {
                state = intent.getIntExtra("state", -1);
                switch (state) {
                    case 0: {
                        AudioRecordSource.this.audioManager.setSpeakerphoneOn(true);
                        AudioRecordSource.this.audioManager.setWiredHeadsetOn(false);
                        AudioRecordSource.this.localAudioOutlet = 0;
                        if (!AudioRecordSource.this.isBluetoothHeadsetConnected()) break;
                        AudioRecordSource.this.routeToBluetoothHeadset();
                        break;
                    }
                    case 1: {
                        AudioRecordSource.this.audioManager.setSpeakerphoneOn(false);
                        AudioRecordSource.this.audioManager.setWiredHeadsetOn(true);
                        AudioRecordSource.this.localAudioOutlet = 1;
                        if (!AudioRecordSource.this.isBluetoothHeadsetConnected()) break;
                        AudioRecordSource.this.routeToBluetoothHeadset();
                        break;
                    }
                }
            }
            if (intent.getAction().equals("android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED")) {
                state = intent.getIntExtra("android.bluetooth.profile.extra.STATE", 0);
                switch (state) {
                    case 2: {
                        AudioRecordSource.this.routeToBluetoothHeadset();
                        break;
                    }
                    case 0: {
                        AudioRecordSource.this.audioManager.setBluetoothScoOn(false);
                        AudioRecordSource.this.audioManager.stopBluetoothSco();
                        if (AudioRecordSource.this.localAudioOutlet == 0) {
                            AudioRecordSource.this.audioManager.setSpeakerphoneOn(true);
                            AudioRecordSource.this.audioManager.setWiredHeadsetOn(false);
                            break;
                        }
                        if (AudioRecordSource.this.localAudioOutlet != 1) break;
                        AudioRecordSource.this.audioManager.setSpeakerphoneOn(false);
                        AudioRecordSource.this.audioManager.setWiredHeadsetOn(true);
                        break;
                    }
                }
            }
        }
    }
}

