/*
 * Decompiled with CFR 0.152.
 */
package fm.websync;

import fm.HashMapExtensions;
import fm.HttpMethod;
import fm.HttpRequestArgs;
import fm.HttpResponseArgs;
import fm.SingleAction;
import fm.StringExtensions;
import fm.websync.Message;
import fm.websync.MessageRequestArgs;
import fm.websync.MessageRequestCreatedArgs;
import fm.websync.MessageResponseArgs;
import fm.websync.MessageResponseReceivedArgs;
import java.util.HashMap;

public abstract class MessageTransfer {
    private String _messageTransferCallbackKey = "fm.websync.messageTransfer.callback";
    private String _requestArgsKey = "fm.websync.messageTransfer.requestArgs";

    public MessageResponseArgs httpResponseArgsToMessageResponseArgs(HttpResponseArgs httpResponseArgs) throws Exception {
        MessageRequestArgs dynamicValue = (MessageRequestArgs)((Object)httpResponseArgs.getRequestArgs().getDynamicValue(this._requestArgsKey));
        MessageResponseArgs args3 = new MessageResponseArgs(dynamicValue);
        args3.setException(httpResponseArgs.getException());
        args3.setHeaders(httpResponseArgs.getHeaders());
        MessageResponseArgs args2 = args3;
        if (!StringExtensions.isNullOrEmpty((String)httpResponseArgs.getTextContent())) {
            args2.setMessages(Message.fromJsonMultiple(httpResponseArgs.getTextContent()));
            return args2;
        }
        if (httpResponseArgs.getBinaryContent() != null) {
            args2.setMessages(Message.fromBinaryMultiple(httpResponseArgs.getBinaryContent()));
        }
        return args2;
    }

    public HttpRequestArgs messageRequestArgsToHttpRequestArgs(MessageRequestArgs requestArgs) throws Exception {
        HttpRequestArgs args2 = new HttpRequestArgs();
        args2.setMethod(HttpMethod.Post);
        args2.setOnRequestCreated(requestArgs.getOnHttpRequestCreated());
        args2.setOnResponseReceived(requestArgs.getOnHttpResponseReceived());
        args2.setSender(requestArgs.getSender());
        args2.setTimeout(requestArgs.getTimeout());
        args2.setUrl(requestArgs.getUrl());
        args2.setDynamicProperties(requestArgs.getDynamicProperties());
        HttpRequestArgs args = args2;
        args.setDynamicValue(this._requestArgsKey, (Object)requestArgs);
        for (String str : HashMapExtensions.getAllKeys(requestArgs.getHeaders())) {
            HashMapExtensions.getItem((HashMap)args.getHeaders()).put(str, HashMapExtensions.getItem(requestArgs.getHeaders()).get(str));
        }
        args.setTextContent(Message.toJsonMultiple(requestArgs.getMessages()));
        HashMapExtensions.getItem((HashMap)args.getHeaders()).put("Content-Type", "application/json");
        if (requestArgs.getIsBinary()) {
            args.setBinaryContent(Message.toBinaryMultiple(requestArgs.getMessages()));
            HashMapExtensions.getItem((HashMap)args.getHeaders()).put("Content-Type", "application/octet-stream");
        }
        return args;
    }

    protected MessageTransfer() {
    }

    private static void raiseRequestCreated(MessageRequestArgs requestArgs) {
        if (requestArgs.getOnRequestCreated() != null) {
            MessageRequestCreatedArgs p = new MessageRequestCreatedArgs();
            p.setRequests(requestArgs.getMessages());
            p.setSender(requestArgs.getSender());
            requestArgs.getOnRequestCreated().invoke((Object)p);
        }
    }

    private static void raiseResponseReceived(MessageResponseArgs responseArgs) {
        if (responseArgs.getException() == null && responseArgs.getRequestArgs().getOnResponseReceived() != null) {
            MessageResponseReceivedArgs p = new MessageResponseReceivedArgs();
            p.setResponses(responseArgs.getMessages());
            p.setSender(responseArgs.getRequestArgs().getSender());
            responseArgs.getRequestArgs().getOnResponseReceived().invoke((Object)p);
        }
    }

    public MessageResponseArgs send(MessageRequestArgs requestArgs) {
        MessageResponseArgs args;
        MessageTransfer.raiseRequestCreated(requestArgs);
        try {
            args = this.sendMessages(requestArgs);
            MessageTransfer.raiseResponseReceived(args);
        }
        catch (Exception exception) {
            MessageResponseArgs args2 = new MessageResponseArgs(requestArgs);
            args2.setException(exception);
            args = args2;
        }
        return args;
    }

    public void sendAsync(MessageRequestArgs requestArgs, SingleAction<MessageResponseArgs> callback) {
        MessageTransfer.raiseRequestCreated(requestArgs);
        requestArgs.setDynamicValue(this._messageTransferCallbackKey, callback);
        try {
            final MessageTransfer _var0 = this;
            this.sendMessagesAsync(requestArgs, new SingleAction<MessageResponseArgs>(){

                public void invoke(MessageResponseArgs responseArgs) {
                    try {
                        _var0.sendAsyncCallback(responseArgs);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
        catch (Exception exception) {
            MessageResponseArgs p = new MessageResponseArgs(requestArgs);
            p.setException(exception);
            callback.invoke((Object)p);
        }
    }

    private void sendAsyncCallback(MessageResponseArgs responseArgs) {
        SingleAction dynamicValue = (SingleAction)responseArgs.getRequestArgs().getDynamicValue(this._messageTransferCallbackKey);
        responseArgs.getRequestArgs().unsetDynamicValue(this._messageTransferCallbackKey);
        MessageTransfer.raiseResponseReceived(responseArgs);
        dynamicValue.invoke((Object)responseArgs);
    }

    public abstract MessageResponseArgs sendMessages(MessageRequestArgs var1) throws Exception;

    public abstract void sendMessagesAsync(MessageRequestArgs var1, SingleAction<MessageResponseArgs> var2) throws Exception;

    public abstract void shutdown();
}

