/*
 * Decompiled with CFR 0.152.
 */
package fm.websync;

import fm.ArrayExtensions;
import fm.ArrayListExtensions;
import fm.BitAssistant;
import fm.Encoding;
import fm.Global;
import fm.Holder;
import fm.NullableBoolean;
import fm.NullableGuid;
import fm.NullableInteger;
import fm.Serializer;
import fm.StringExtensions;
import fm.websync.Advice;
import fm.websync.BaseMessage;
import fm.websync.ConnectionType;
import fm.websync.Extensible;
import fm.websync.MessageType;
import fm.websync.MetaChannels;
import fm.websync.NotifyingClient;
import fm.websync.NullableConnectionType;
import fm.websync.PublishingClient;
import fm.websync.Record;
import java.util.ArrayList;

public class Message
extends BaseMessage {
    private Advice __advice;
    private String __bayeuxChannel;
    private String[] __channels;
    private NullableGuid __clientId = new NullableGuid();
    private NullableConnectionType __connectionType = new NullableConnectionType();
    private String __id;
    private String __minimumVersion;
    private Record[] __records;
    private ConnectionType[] __supportedConnectionTypes;
    private String __version;
    private Object _toJsonNoDataLock = new Object();

    private static int bytesToInt(byte[] bytes, int index) {
        if (ArrayExtensions.getLength((byte[])bytes) < index + 4) {
            return -1;
        }
        return BitAssistant.toIntegerNetwork((byte[])bytes, (int)index);
    }

    public static Message fromBinary(byte[] bytes, int offset) throws Exception {
        int count = Message.bytesToInt(bytes, offset);
        if (count < 0) {
            return null;
        }
        int num2 = Message.bytesToInt(bytes, offset += 4);
        if (num2 < 0) {
            return null;
        }
        byte[] buffer = BitAssistant.subArray((byte[])bytes, (int)(offset += 4), (int)count);
        byte[] buffer2 = BitAssistant.subArray((byte[])bytes, (int)(offset += count), (int)num2);
        offset += num2;
        Message message = Message.fromJson(Encoding.getUTF8().getString(buffer, 0, ArrayExtensions.getLength((byte[])buffer)));
        message.setDataBytes(buffer2);
        return message;
    }

    public static Message fromBinary(byte[] bytes) throws Exception {
        return Message.fromBinary(bytes, 0);
    }

    public static Message[] fromBinaryMultiple(byte[] bytes) throws Exception {
        int index = 0;
        int num2 = Message.bytesToInt(bytes, index);
        if (num2 < 0) {
            return new Message[0];
        }
        index += 4;
        Message[] messageArray = new Message[num2];
        for (int i = 0; i < num2; ++i) {
            int num4 = Message.bytesToInt(bytes, index);
            if (num4 < 0) {
                return new Message[0];
            }
            Message message = Message.fromBinary(bytes, index += 4);
            if (message == null) {
                return new Message[0];
            }
            index += num4;
            messageArray[i] = message;
        }
        return messageArray;
    }

    public static Message fromJson(String messageJson) throws Exception {
        return fm.websync.Serializer.deserializeMessage(messageJson);
    }

    public static Message[] fromJsonMultiple(String messagesJson) throws Exception {
        return fm.websync.Serializer.deserializeMessageArray(messagesJson);
    }

    public NullableBoolean getAcknowledgement() {
        return Serializer.deserializeBoolean((String)super.getExtensionValueJson("fm.ack"));
    }

    public Advice getAdvice() {
        return this.__advice;
    }

    public String getBayeuxChannel() {
        return this.__bayeuxChannel;
    }

    public String getChannel() {
        return Extensible.sharedGetChannel(this.__channels);
    }

    public String[] getChannels() {
        return Extensible.sharedGetChannels(this.__channels);
    }

    public NullableGuid getClientId() {
        return this.__clientId;
    }

    public NullableConnectionType getConnectionType() {
        return this.__connectionType;
    }

    public NullableBoolean getDisableBinary() {
        return Serializer.deserializeBoolean((String)super.getExtensionValueJson("fm.dbin"));
    }

    public String getId() {
        return this.__id;
    }

    public String getKey() {
        return Extensible.sharedGetKey(this.__records);
    }

    public String[] getKeys() {
        return Extensible.sharedGetKeys(this.__records);
    }

    public NullableGuid getLastClientId() throws Exception {
        return Serializer.deserializeGuid((String)super.getExtensionValueJson("fm.lcid"));
    }

    public NullableGuid getLastSessionId() throws Exception {
        return Serializer.deserializeGuid((String)super.getExtensionValueJson("fm.lsid"));
    }

    public String getMinimumVersion() {
        return this.__minimumVersion;
    }

    public NullableGuid getNotifyClientId() throws Exception {
        return Serializer.deserializeGuid((String)super.getExtensionValueJson("fm.notify"));
    }

    public NotifyingClient getNotifyingClient() throws Exception {
        return fm.websync.Serializer.deserializeNotifyingClient(super.getExtensionValueJson("fm.notifying"));
    }

    public PublishingClient getPublishingClient() throws Exception {
        return fm.websync.Serializer.deserializePublishingClient(super.getExtensionValueJson("fm.publishing"));
    }

    public Record getRecord() {
        return Extensible.sharedGetRecord(this.__records);
    }

    public Record[] getRecords() {
        return Extensible.sharedGetRecords(this.__records);
    }

    public Message[] getServerActions() throws Exception {
        Message[] messageArray;
        String extensionValueJson = super.getExtensionValueJson("fm.server");
        if (!StringExtensions.isNullOrEmpty((String)extensionValueJson) && (messageArray = Message.fromJsonMultiple(extensionValueJson)) != null) {
            return messageArray;
        }
        return null;
    }

    public NullableInteger getServerTimeout() {
        return Serializer.deserializeInteger((String)super.getExtensionValueJson("fm.timeout"));
    }

    public NullableGuid getSessionId() throws Exception {
        return Serializer.deserializeGuid((String)super.getExtensionValueJson("fm.sessionId"));
    }

    public ConnectionType[] getSupportedConnectionTypes() {
        return this.__supportedConnectionTypes;
    }

    public String getTag() throws Exception {
        return Serializer.deserializeString((String)super.getExtensionValueJson("fm.tag")) != null ? Serializer.deserializeString((String)super.getExtensionValueJson("fm.tag")) : StringExtensions.empty;
    }

    public MessageType getType() {
        return MetaChannels.getMessageType(this.getBayeuxChannel());
    }

    public String getVersion() {
        return this.__version;
    }

    private static byte[] intToBytes(int i) {
        return BitAssistant.getIntegerBytesNetwork((int)i);
    }

    public boolean isBind() {
        return Global.equals((Object)((Object)this.getType()), (Object)((Object)MessageType.Bind));
    }

    public boolean isBindingTo(String key) {
        if (Global.equals((Object)((Object)this.getType()), (Object)((Object)MessageType.Bind))) {
            if (this.getRecords() == null) {
                return false;
            }
            for (Record record : this.getRecords()) {
                if (!Global.equals((Object)record.getKey(), (Object)key)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isConnect() {
        return Global.equals((Object)((Object)this.getType()), (Object)((Object)MessageType.Connect));
    }

    public boolean isDisconnect() {
        return Global.equals((Object)((Object)this.getType()), (Object)((Object)MessageType.Disconnect));
    }

    public boolean isNotify() {
        return Global.equals((Object)((Object)this.getType()), (Object)((Object)MessageType.Notify));
    }

    public boolean isPublish() {
        return Global.equals((Object)((Object)this.getType()), (Object)((Object)MessageType.Publish));
    }

    public boolean isService() {
        return Global.equals((Object)((Object)this.getType()), (Object)((Object)MessageType.Service));
    }

    public boolean isStream() {
        return Global.equals((Object)((Object)this.getType()), (Object)((Object)MessageType.Stream));
    }

    public boolean isSubscribe() {
        return Global.equals((Object)((Object)this.getType()), (Object)((Object)MessageType.Subscribe));
    }

    public boolean isSubscribingTo(String channel) {
        if (Global.equals((Object)((Object)this.getType()), (Object)((Object)MessageType.Subscribe))) {
            if (this.getChannels() == null) {
                return false;
            }
            for (String str : this.getChannels()) {
                if (!Global.equals((Object)str, (Object)channel)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isUnbind() {
        return Global.equals((Object)((Object)this.getType()), (Object)((Object)MessageType.Unbind));
    }

    public boolean isUnbindingFrom(String key) {
        if (Global.equals((Object)((Object)this.getType()), (Object)((Object)MessageType.Unbind))) {
            if (this.getRecords() == null) {
                return false;
            }
            for (Record record : this.getRecords()) {
                if (!Global.equals((Object)record.getKey(), (Object)key)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isUnsubscribe() {
        return Global.equals((Object)((Object)this.getType()), (Object)((Object)MessageType.Unsubscribe));
    }

    public boolean isUnsubscribingFrom(String channel) {
        if (Global.equals((Object)((Object)this.getType()), (Object)((Object)MessageType.Unsubscribe))) {
            if (this.getChannels() == null) {
                return false;
            }
            for (String str : this.getChannels()) {
                if (!Global.equals((Object)str, (Object)channel)) continue;
                return true;
            }
        }
        return false;
    }

    public Message(String bayeuxChannel) throws Exception {
        super.setValidate(false);
        this.setBayeuxChannel(bayeuxChannel);
        super.setValidate(true);
    }

    Message() {
    }

    public void setAcknowledgement(NullableBoolean value) throws Exception {
        super.setExtensionValueJson("fm.ack", Serializer.serializeBoolean((NullableBoolean)value), false);
        super.setIsDirty(true);
    }

    public void setAdvice(Advice value) {
        this.__advice = value;
        super.setIsDirty(true);
    }

    public void setBayeuxChannel(String value) throws Exception {
        this.__bayeuxChannel = value;
        if (MetaChannels.isServiceChannel(value)) {
            this.setChannel(MetaChannels.convertChannelFromServiced(value));
        } else if (!MetaChannels.isMetaChannel(value)) {
            this.setChannel(value);
        }
        super.setIsDirty(true);
    }

    public void setChannel(String value) throws Exception {
        this.__channels = Extensible.sharedSetChannel(value, super.getValidate());
        super.setIsDirty(true);
    }

    public void setChannels(String[] value) throws Exception {
        this.__channels = Extensible.sharedSetChannels(value, super.getValidate());
        super.setIsDirty(true);
    }

    public void setClientId(NullableGuid value) {
        this.__clientId = value;
        super.setIsDirty(true);
    }

    public void setConnectionType(NullableConnectionType value) {
        this.__connectionType = value;
        super.setIsDirty(true);
    }

    public void setDisableBinary(NullableBoolean value) throws Exception {
        super.setExtensionValueJson("fm.dbin", Serializer.serializeBoolean((NullableBoolean)value), false);
        super.setIsDirty(true);
    }

    public void setId(String value) {
        this.__id = value;
        super.setIsDirty(true);
    }

    public void setKey(String value) throws Exception {
        this.__records = Extensible.sharedSetKey(value, super.getValidate());
        super.setIsDirty(true);
    }

    public void setKeys(String[] value) throws Exception {
        this.__records = Extensible.sharedSetKeys(value, super.getValidate());
        super.setIsDirty(true);
    }

    public void setLastClientId(NullableGuid value) throws Exception {
        super.setExtensionValueJson("fm.lcid", Serializer.serializeGuid((NullableGuid)value), false);
        super.setIsDirty(true);
    }

    public void setLastSessionId(NullableGuid value) throws Exception {
        super.setExtensionValueJson("fm.lsid", Serializer.serializeGuid((NullableGuid)value), false);
        super.setIsDirty(true);
    }

    public void setMinimumVersion(String value) {
        this.__minimumVersion = value;
        super.setIsDirty(true);
    }

    public void setNotifyClientId(NullableGuid value) throws Exception {
        super.setExtensionValueJson("fm.notify", Serializer.serializeGuid((NullableGuid)value), false);
        super.setIsDirty(true);
    }

    public void setNotifyingClient(NotifyingClient value) throws Exception {
        super.setExtensionValueJson("fm.notifying", fm.websync.Serializer.serializeNotifyingClient(value), false);
        super.setIsDirty(true);
    }

    public void setPublishingClient(PublishingClient value) throws Exception {
        super.setExtensionValueJson("fm.publishing", fm.websync.Serializer.serializePublishingClient(value), false);
        super.setIsDirty(true);
    }

    public void setRecord(Record value) throws Exception {
        this.__records = Extensible.sharedSetRecord(value, super.getValidate());
        super.setIsDirty(true);
    }

    public void setRecords(Record[] value) throws Exception {
        this.__records = Extensible.sharedSetRecords(value, super.getValidate());
        super.setIsDirty(true);
    }

    public void setServerActions(Message[] value) throws Exception {
        super.setExtensionValueJson("fm.server", Message.toJsonMultiple(value), false);
        super.setIsDirty(true);
    }

    public void setServerTimeout(NullableInteger value) throws Exception {
        super.setExtensionValueJson("fm.timeout", Serializer.serializeInteger((NullableInteger)value), false);
        super.setIsDirty(true);
    }

    public void setSessionId(NullableGuid value) throws Exception {
        super.setExtensionValueJson("fm.sessionId", Serializer.serializeGuid((NullableGuid)value), false);
        super.setIsDirty(true);
    }

    public void setSupportedConnectionTypes(ConnectionType[] value) {
        this.__supportedConnectionTypes = value;
        super.setIsDirty(true);
    }

    public void setTag(String value) throws Exception {
        super.setExtensionValueJson("fm.tag", Serializer.serializeString((String)(value != null ? value : StringExtensions.empty)), false);
        super.setIsDirty(true);
    }

    public void setVersion(String value) {
        this.__version = value;
        super.setIsDirty(true);
    }

    public static byte[] toBinary(Message message) throws Exception {
        byte[] dataBytes = null;
        String dataJson = null;
        Holder _var0 = new Holder(dataBytes);
        Holder _var1 = new Holder(dataJson);
        String _var2 = message.toJsonNoData((Holder<byte[]>)_var0, (Holder<String>)_var1);
        dataBytes = (byte[])_var0.getValue();
        dataJson = (String)_var1.getValue();
        String s = _var2;
        if (dataBytes == null) {
            if (dataJson == null) {
                throw new Exception("Message data bytes cannot be null.");
            }
            throw new Exception(StringExtensions.format((String)"Message data bytes cannot be null (JSON: {0}).", (Object)dataJson));
        }
        if (s == null) {
            throw new Exception("Message JSON cannot be null.");
        }
        byte[] bytes = Encoding.getUTF8().getBytes(s);
        byte[] destination = new byte[8 + ArrayExtensions.getLength((byte[])bytes) + ArrayExtensions.getLength((byte[])dataBytes)];
        int destinationIndex = 0;
        BitAssistant.copy((byte[])Message.intToBytes(ArrayExtensions.getLength((byte[])bytes)), (int)0, (byte[])destination, (int)destinationIndex, (int)4);
        BitAssistant.copy((byte[])Message.intToBytes(ArrayExtensions.getLength((byte[])dataBytes)), (int)0, (byte[])destination, (int)(destinationIndex += 4), (int)4);
        BitAssistant.copy((byte[])bytes, (int)0, (byte[])destination, (int)(destinationIndex += 4), (int)ArrayExtensions.getLength((byte[])bytes));
        BitAssistant.copy((byte[])dataBytes, (int)0, (byte[])destination, (int)(destinationIndex += ArrayExtensions.getLength((byte[])bytes)), (int)ArrayExtensions.getLength((byte[])dataBytes));
        destinationIndex += ArrayExtensions.getLength((byte[])dataBytes);
        return destination;
    }

    public byte[] toBinary() throws Exception {
        return Message.toBinary(this);
    }

    public static byte[] toBinaryMultiple(Message[] messages) throws Exception {
        int num = 4;
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        for (Message message : messages) {
            byte[] item = Message.toBinary(message);
            list.add(item);
            num += 4 + ArrayExtensions.getLength((byte[])item);
        }
        byte[] destination = new byte[num];
        int destinationIndex = 0;
        BitAssistant.copy((byte[])Message.intToBytes(ArrayListExtensions.getCount(list)), (int)0, (byte[])destination, (int)destinationIndex, (int)4);
        destinationIndex += 4;
        for (byte[] buffer : list) {
            BitAssistant.copy((byte[])Message.intToBytes(ArrayExtensions.getLength((byte[])buffer)), (int)0, (byte[])destination, (int)destinationIndex, (int)4);
            BitAssistant.copy((byte[])buffer, (int)0, (byte[])destination, (int)(destinationIndex += 4), (int)ArrayExtensions.getLength((byte[])buffer));
            destinationIndex += ArrayExtensions.getLength((byte[])buffer);
        }
        return destination;
    }

    public static String toJson(Message message) {
        return fm.websync.Serializer.serializeMessage(message);
    }

    public String toJson() {
        return Message.toJson(this);
    }

    public static String toJsonMultiple(Message[] messages) {
        return fm.websync.Serializer.serializeMessageArray(messages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String toJsonNoData(Holder<byte[]> dataBytes, Holder<String> dataJson) throws Exception {
        String str;
        Object object = this._toJsonNoDataLock;
        synchronized (object) {
            if (super.getIsBinary()) {
                dataBytes.setValue((Object)super.getDataBytes());
                dataJson.setValue(null);
                super.setDataBytes(null);
                String str2 = this.toJson();
                super.setDataBytes((byte[])dataBytes.getValue());
                return str2;
            }
            dataBytes.setValue(null);
            dataJson.setValue((Object)super.getDataJson());
            super.setDataJson(null);
            str = this.toJson();
            super.setDataJson((String)dataJson.getValue());
        }
        return str;
    }
}

