/*
 * Decompiled with CFR 0.152.
 */
package fm;

import fm.Convert;
import fm.DoubleHolder;
import fm.Global;
import fm.Holder;
import fm.JsonCheckerMode;
import fm.LongExtensions;
import fm.ParseAssistant;
import fm.StackExtensions;
import fm.StringExtensions;
import java.math.BigDecimal;
import java.util.Stack;

class JsonChecker {
    private int __depth;
    private long __offset;
    private Stack<JsonCheckerMode> __stack;
    private int __state;
    private static int[] _ascii_class = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, 1, 1, -1, -1, 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 30, 8, 30, 30, 30, 30, 30, 30, 30, 30, 11, 7, 12, 13, 10, 14, 15, 15, 15, 15, 15, 15, 15, 15, 15, 6, 30, 30, 30, 30, 30, 30, 28, 28, 28, 28, 29, 28, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 30, 4, 9, 5, 30, 30, 30, 16, 17, 18, 19, 20, 21, 30, 30, 30, 30, 30, 22, 30, 23, 30, 30, 30, 24, 25, 26, 27, 30, 30, 30, 30, 30, 2, 30, 3, 30, 30};
    private static int[][] _state_transition_table = new int[][]{{0, 0, -6, -1, -5, -1, -1, -1, -4, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {1, 1, -1, -8, -1, -7, -1, -3, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {2, 2, -1, -9, -1, -1, -1, -1, 7, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {3, 3, -1, -1, -1, -1, -1, -1, 7, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {4, 4, -1, -1, -1, -1, -2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {5, 5, -6, -1, -5, -1, -1, -1, 7, -1, -1, -1, 13, -1, 14, 15, -1, -1, -1, -1, -1, 23, -1, 27, -1, -1, 20, -1, -1, -1, -1}, {6, 6, -6, -1, -5, -7, -1, -1, 7, -1, -1, -1, 13, -1, 14, 15, -1, -1, -1, -1, -1, 23, -1, 27, -1, -1, 20, -1, -1, -1, -1}, {7, -1, 7, 7, 7, 7, 7, 7, -4, 8, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7}, {-1, -1, -1, -1, -1, -1, -1, -1, 7, 7, 7, -1, -1, -1, -1, -1, -1, 7, -1, -1, -1, 7, -1, 7, 7, -1, 7, 9, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, 10, 10, 10, 10, 10, 10, 10, -1, -1, -1, -1, -1, -1, 10, 10, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 11, 11, 11, 11, 11, 11, 11, 11, -1, -1, -1, -1, -1, -1, 11, 11, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 12, 12, 12, 12, 12, 12, 12, 12, -1, -1, -1, -1, -1, -1, 12, 12, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 7, 7, 7, 7, 7, 7, 7, 7, -1, -1, -1, -1, -1, -1, 7, 7, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {1, 1, -1, -8, -1, -7, -1, -3, -1, -1, -1, -1, -1, 16, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {1, 1, -1, -8, -1, -7, -1, -3, -1, -1, -1, -1, -1, 16, 15, 15, -1, -1, -1, -1, 17, -1, -1, -1, -1, -1, -1, -1, -1, 17, -1}, {1, 1, -1, -8, -1, -7, -1, -3, -1, -1, -1, -1, -1, -1, 16, 16, -1, -1, -1, -1, 17, -1, -1, -1, -1, -1, -1, -1, -1, 17, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 18, 18, -1, 19, 19, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 19, 19, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {1, 1, -1, -8, -1, -7, -1, -3, -1, -1, -1, -1, -1, -1, 19, 19, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 21, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 22, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 24, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 25, -1, -1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 26, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 28, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 29, -1, -1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1, -1, -1, -1, -1, -1, -1, -1, -1}};

    private void check(int ch) throws Exception {
        int num;
        if (ch < 0) {
            this.onError();
        }
        if (ch >= 128) {
            num = 30;
        } else {
            num = _ascii_class[ch];
            if (num <= -1) {
                this.onError();
            }
        }
        int num2 = _state_transition_table[this.__state][num];
        if (num2 >= 0) {
            this.__state = num2;
            ++this.__offset;
        } else {
            if (num2 == -9) {
                this.pop(JsonCheckerMode.Key);
                this.__state = 1;
            } else if (num2 == -8) {
                this.pop(JsonCheckerMode.Object);
                this.__state = 1;
            } else if (num2 == -7) {
                this.pop(JsonCheckerMode.Array);
                this.__state = 1;
            } else if (num2 == -6) {
                this.push(JsonCheckerMode.Key);
                this.__state = 2;
            } else if (num2 == -5) {
                this.push(JsonCheckerMode.Array);
                this.__state = 6;
            } else if (num2 == -4) {
                JsonCheckerMode mode = this.__stack.peek();
                if (Global.equals((Object)mode, (Object)JsonCheckerMode.Key)) {
                    this.__state = 4;
                } else if (Global.equals((Object)mode, (Object)JsonCheckerMode.Array) || Global.equals((Object)mode, (Object)JsonCheckerMode.Object)) {
                    this.__state = 1;
                } else if (Global.equals((Object)mode, (Object)JsonCheckerMode.Done)) {
                    this.push(JsonCheckerMode.String);
                    this.__state = 7;
                } else if (Global.equals((Object)mode, (Object)JsonCheckerMode.String)) {
                    this.pop(JsonCheckerMode.String);
                    this.__state = 1;
                } else {
                    this.onError();
                }
            } else if (num2 == -3) {
                JsonCheckerMode mode = this.__stack.peek();
                if (Global.equals((Object)mode, (Object)JsonCheckerMode.Object)) {
                    this.pop(JsonCheckerMode.Object);
                    this.push(JsonCheckerMode.Key);
                    this.__state = 3;
                } else if (Global.equals((Object)mode, (Object)JsonCheckerMode.Array)) {
                    this.__state = 5;
                } else {
                    this.onError();
                }
            } else if (num2 == -2) {
                this.pop(JsonCheckerMode.Key);
                this.push(JsonCheckerMode.Object);
                this.__state = 5;
            } else {
                this.onError();
            }
            ++this.__offset;
        }
    }

    public boolean checkString(String str) throws Exception {
        double doubleResult = 0.0;
        BigDecimal decimalResult = new BigDecimal("0");
        DoubleHolder _var0 = new DoubleHolder(doubleResult);
        boolean _var1 = ParseAssistant.tryParseDoubleValue(str, _var0);
        doubleResult = _var0.getValue();
        Holder<BigDecimal> _var2 = new Holder<BigDecimal>(decimalResult);
        boolean _var3 = ParseAssistant.tryParseDecimalValue(str, _var2);
        decimalResult = _var2.getValue();
        if (Global.equals(str, "true") || Global.equals(str, "false") || Global.equals(str, "null") || _var1 || _var3) {
            return true;
        }
        try {
            for (int i = 0; i < StringExtensions.getLength(str); ++i) {
                this.check(Convert.toInt32(str.charAt(i)));
            }
            this.finalCheck();
            return true;
        }
        catch (Exception exception1) {
            return false;
        }
    }

    private void finalCheck() throws Exception {
        if (this.__state != 1) {
            this.onError();
        }
        this.pop(JsonCheckerMode.Done);
    }

    public JsonChecker() throws Exception {
        this(0);
    }

    public JsonChecker(int depth) throws Exception {
        if (depth < 0) {
            throw new Exception("Invalid depth.");
        }
        this.__state = 0;
        this.__depth = depth;
        this.__stack = StackExtensions.createStack(depth);
        this.push(JsonCheckerMode.Done);
    }

    private void onError() throws Exception {
        throw new Exception(StringExtensions.format("Invalid JSON text at character offset {0}.", LongExtensions.toString(this.__offset, "N0")));
    }

    private void pop(JsonCheckerMode mode) throws Exception {
        if (!Global.equals((Object)this.__stack.pop(), (Object)mode)) {
            this.onError();
        }
    }

    private void push(JsonCheckerMode mode) throws Exception {
        if (this.__depth > 0 && StackExtensions.getCount(this.__stack) >= this.__depth) {
            this.onError();
        }
        this.__stack.push(mode);
    }
}

