/*
 * Decompiled with CFR 0.152.
 */
package fm;

import fm.ArrayExtensions;
import fm.BitAssistant;
import fm.MathAssistant;

public class ByteInputStream {
    private byte[] _bytes;
    private int _markedPosition = 0;
    private int _position = 0;

    public ByteInputStream(byte[] bytes, int offset) {
        this._bytes = bytes;
        this._position = offset;
        this._markedPosition = offset;
    }

    public ByteInputStream(byte[] bytes) {
        this(bytes, 0);
    }

    public int getAvailable() {
        return ArrayExtensions.getLength(this._bytes) - this._position;
    }

    public void mark() {
        this._markedPosition = this._position;
    }

    public int read(byte[] buffer, int offset, int length) {
        if (length >= this.getAvailable()) {
            length = this.getAvailable();
        }
        BitAssistant.copy(this._bytes, this._position, buffer, offset, length);
        this._position += length;
        return length;
    }

    public int read() {
        if (this.getAvailable() >= 1) {
            byte num;
            if ((num = this._bytes[this._position++]) < 0) {
                return 256 + num;
            }
            return num;
        }
        return -1;
    }

    public void reset() {
        this._position = this._markedPosition;
    }

    public int skip(int n) {
        int num = MathAssistant.min(ArrayExtensions.getLength(this._bytes), this._position + n);
        int num2 = num - this._position;
        this._position = num;
        return num2;
    }
}

