/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.Asn1Any;
import fm.icelink.Asn1Sequence;
import fm.icelink.Global;
import fm.icelink.X509Extension;
import java.util.ArrayList;

class X509Extensions {
    private X509Extension[] _values;

    public static X509Extensions fromAsn1(Asn1Any any) {
        Asn1Sequence sequence = Global.tryCast(any, Asn1Sequence.class);
        if (sequence == null) {
            return null;
        }
        X509Extensions extensions = new X509Extensions();
        ArrayList<X509Extension> list = new ArrayList<X509Extension>();
        for (Asn1Any any2 : sequence.getValues()) {
            list.add(X509Extension.fromAsn1(any2));
        }
        extensions.setValues(list.toArray(new X509Extension[0]));
        return extensions;
    }

    public X509Extension[] getValues() {
        return this._values;
    }

    public void setValues(X509Extension[] value) {
        this._values = value;
    }

    public Asn1Sequence toAsn1() {
        ArrayList<Asn1Sequence> list = new ArrayList<Asn1Sequence>();
        for (X509Extension extension : this.getValues()) {
            list.add(extension.toAsn1());
        }
        return new Asn1Sequence(list.toArray(new Asn1Any[0]));
    }

    public X509Extensions() {
    }

    public X509Extensions(X509Extension[] values) {
        this.setValues(values);
    }
}

