/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.ArrayExtensions;
import fm.icelink.Global;
import fm.icelink.HashMapExtensions;
import fm.icelink.Holder;
import fm.icelink.IAction1;
import fm.icelink.IActionDelegate1;
import fm.icelink.IntegerExtensions;
import fm.icelink.IntegerHolder;
import fm.icelink.Log;
import fm.icelink.StringExtensions;
import fm.icelink.VirtualDevice;
import fm.icelink.VirtualNat;
import fm.icelink.VirtualNatMode;
import fm.icelink.VirtualPacket;
import fm.icelink.VirtualPacketDeliveredArgs;
import java.util.ArrayList;
import java.util.HashMap;

public class VirtualNetwork
extends VirtualDevice {
    private ArrayList<VirtualDevice> __devices = new ArrayList();
    private Object __devicesLock = new Object();
    private HashMap<String, VirtualDevice> __routes = new HashMap();
    private Object __routesLock = new Object();
    private int _dhcpIPAddress1;
    private int _dhcpIPAddress2;
    private int _dhcpIPAddress3;
    private int _dhcpIPAddress4End;
    private int _dhcpIPAddress4Start;
    private int _internalIPAddress1;
    private int _internalIPAddress2;
    private int _internalIPAddress3;
    private int _internalIPAddress4;
    private VirtualNat _nat;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDevice(VirtualDevice device) {
        if (device.getNetwork() != null) {
            throw new RuntimeException(new Exception("Device is currently attached to a network."));
        }
        Object object = this.__devicesLock;
        synchronized (object) {
            this.__devices.add(device);
        }
        this.maybeAssignIP(device);
    }

    public void addForwarding(int port, String ipAddress) {
        this.getNat().addForwarding(port, ipAddress);
    }

    private boolean deliverToDevice(VirtualPacket packet, String destinationIPAddress, int destinationPort) {
        for (VirtualDevice device : this.getDevices()) {
            if (!Global.equals(device.getIPAddress(), destinationIPAddress)) continue;
            device.deliver(packet, destinationPort);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VirtualDevice[] getDevices() {
        Object object = this.__devicesLock;
        synchronized (object) {
            return this.__devices.toArray(new VirtualDevice[0]);
        }
    }

    public int getDhcpIPAddress1() {
        return this._dhcpIPAddress1;
    }

    public int getDhcpIPAddress2() {
        return this._dhcpIPAddress2;
    }

    public int getDhcpIPAddress3() {
        return this._dhcpIPAddress3;
    }

    public int getDhcpIPAddress4End() {
        return this._dhcpIPAddress4End;
    }

    public int getDhcpIPAddress4Start() {
        return this._dhcpIPAddress4Start;
    }

    public int getInternalIPAddress1() {
        return this._internalIPAddress1;
    }

    public int getInternalIPAddress2() {
        return this._internalIPAddress2;
    }

    public int getInternalIPAddress3() {
        return this._internalIPAddress3;
    }

    public int getInternalIPAddress4() {
        return this._internalIPAddress4;
    }

    public VirtualNat getNat() {
        return this._nat;
    }

    public VirtualNatMode getNatMode() {
        return this.getNat().getMode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeAssignIP(VirtualDevice device) {
        Object object = this.__routesLock;
        synchronized (object) {
            if (device.getUseDhcp()) {
                int num = 0;
                int num2 = this.getDhcpIPAddress4Start();
                while (num == 0 && num2 <= this.getDhcpIPAddress4End()) {
                    if (this.__routes.containsKey(IntegerExtensions.toString(num2))) {
                        ++num2;
                        continue;
                    }
                    num = num2;
                }
                if (num == 0) {
                    throw new RuntimeException(new Exception("No more DHCP addresses are available."));
                }
                device.setAddressAndNetwork(this.getDhcpIPAddress1(), this.getDhcpIPAddress2(), this.getDhcpIPAddress3(), num, this);
                HashMapExtensions.set(HashMapExtensions.getItem(this.__routes), IntegerExtensions.toString(num), device);
            } else if (device.getIPAddress1() == this.getDhcpIPAddress1() && device.getIPAddress2() == this.getDhcpIPAddress2() && device.getIPAddress3() == this.getDhcpIPAddress3()) {
                if (this.__routes.containsKey(IntegerExtensions.toString(device.getIPAddress4()))) {
                    throw new RuntimeException(new Exception("Device IP address is already in use."));
                }
                device.setNetwork(this);
                HashMapExtensions.set(HashMapExtensions.getItem(this.__routes), IntegerExtensions.toString(device.getIPAddress4()), device);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeUnassignIP(VirtualDevice device) {
        Object object = this.__routesLock;
        synchronized (object) {
            HashMapExtensions.remove(this.__routes, IntegerExtensions.toString(device.getIPAddress4()));
            if (device.getUseDhcp()) {
                device.setAddressAndNetwork(0, 0, 0, 0, null);
            } else {
                device.setNetwork(null);
            }
        }
    }

    private void onPacketDelivered(VirtualPacketDeliveredArgs e) {
        VirtualPacket delivery = super.getDelivery(e.getPort());
        if (delivery != null) {
            String internalIPAddress = null;
            int internalPort = 0;
            Holder<Object> _var0 = new Holder<Object>(internalIPAddress);
            IntegerHolder _var1 = new IntegerHolder(internalPort);
            boolean _var2 = this.getNat().getMapping(e.getPort(), _var0, _var1, delivery.getSourceIPAddress(), delivery.getSourcePort());
            internalIPAddress = _var0.getValue();
            internalPort = _var1.getValue();
            if (_var2) {
                if (!this.deliverToDevice(delivery, internalIPAddress, internalPort)) {
                    Log.warn(StringExtensions.format("Device {0}:{1} disconnected before packet could be delivered.", internalIPAddress, IntegerExtensions.toString(internalPort)));
                }
            } else if (Global.equals((Object)this.getNatMode(), (Object)VirtualNatMode.AddressRestrictedCone)) {
                int length = ArrayExtensions.getLength(this.getNat().getMappings());
                Log.debug(StringExtensions.format("COULD NOT GET MAPPING - {0} mappings", IntegerExtensions.toString(length)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeDevice(VirtualDevice device) {
        Object object = this.__devicesLock;
        synchronized (object) {
            if (!this.__devices.remove(device)) {
                return false;
            }
        }
        this.maybeUnassignIP(device);
        return true;
    }

    public void removeForwarding(int port) {
        this.getNat().removeForwarding(port);
    }

    boolean send(VirtualPacket packet, String destinationIPAddress, int destinationPort) {
        if (this.deliverToDevice(packet, destinationIPAddress, destinationPort)) {
            return true;
        }
        if (super.getNetwork() != null) {
            int port = 0;
            IntegerHolder _var0 = new IntegerHolder(port);
            this.getNat().addMapping(_var0, packet.getSourceIPAddress(), packet.getSourcePort(), destinationIPAddress, destinationPort);
            port = _var0.getValue();
            packet.setSourceIPAddress(super.getIPAddress());
            packet.setSourcePort(port);
            return super.getNetwork().send(packet, destinationIPAddress, destinationPort);
        }
        return false;
    }

    private void setDhcpIPAddress1(int value) {
        this._dhcpIPAddress1 = value;
    }

    private void setDhcpIPAddress2(int value) {
        this._dhcpIPAddress2 = value;
    }

    private void setDhcpIPAddress3(int value) {
        this._dhcpIPAddress3 = value;
    }

    private void setDhcpIPAddress4End(int value) {
        this._dhcpIPAddress4End = value;
    }

    private void setDhcpIPAddress4Start(int value) {
        this._dhcpIPAddress4Start = value;
    }

    void setInternalIPAddress1(int value) {
        this._internalIPAddress1 = value;
    }

    void setInternalIPAddress2(int value) {
        this._internalIPAddress2 = value;
    }

    void setInternalIPAddress3(int value) {
        this._internalIPAddress3 = value;
    }

    void setInternalIPAddress4(int value) {
        this._internalIPAddress4 = value;
    }

    private void setNat(VirtualNat value) {
        this._nat = value;
    }

    public VirtualNetwork(VirtualNatMode natMode, int dhcpAddress1, int dhcpAddress2, int dhcpAddress3) {
        this.setNat(new VirtualNat(natMode));
        this.setDhcpIPAddress1(dhcpAddress1);
        this.setDhcpIPAddress2(dhcpAddress2);
        this.setDhcpIPAddress3(dhcpAddress3);
        this.setDhcpIPAddress4Start(100);
        this.setDhcpIPAddress4End(199);
        this.setInternalIPAddress1(dhcpAddress1);
        this.setInternalIPAddress2(dhcpAddress2);
        this.setInternalIPAddress3(dhcpAddress3);
        this.setInternalIPAddress4(1);
        super.removePacketDelivered((IAction1<VirtualPacketDeliveredArgs>)new IActionDelegate1<VirtualPacketDeliveredArgs>(){

            @Override
            public String getId() {
                return "fm.icelink.VirtualNetwork.onPacketDelivered";
            }

            @Override
            public void invoke(VirtualPacketDeliveredArgs e) {
                VirtualNetwork.this.onPacketDelivered(e);
            }
        });
        super.addPacketDelivered((IAction1<VirtualPacketDeliveredArgs>)new IActionDelegate1<VirtualPacketDeliveredArgs>(){

            @Override
            public String getId() {
                return "fm.icelink.VirtualNetwork.onPacketDelivered";
            }

            @Override
            public void invoke(VirtualPacketDeliveredArgs e) {
                VirtualNetwork.this.onPacketDelivered(e);
            }
        });
    }
}

