/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink;

import fm.icelink.AudioBuffer;
import fm.icelink.AudioBufferCollection;
import fm.icelink.AudioConfig;
import fm.icelink.AudioFormat;
import fm.icelink.AudioFrame;
import fm.icelink.DataBuffer;
import fm.icelink.IAudioElement;
import fm.icelink.IAudioInput;
import fm.icelink.IAudioOutput;
import fm.icelink.IAudioOutputCollection;
import fm.icelink.IElement;
import fm.icelink.IInput;
import fm.icelink.IMediaElement;
import fm.icelink.IMediaInput;
import fm.icelink.MathAssistant;
import fm.icelink.MediaSink;

public abstract class AudioSink
extends MediaSink<IAudioOutput, IAudioOutputCollection, IAudioInput, AudioSink, AudioFrame, AudioBuffer, AudioBufferCollection, AudioFormat>
implements IAudioInput,
IMediaInput<IAudioOutput, IAudioInput, AudioFrame, AudioBuffer, AudioBufferCollection, AudioFormat>,
IInput<IAudioOutput, IAudioInput, AudioFrame, AudioBuffer, AudioBufferCollection, AudioFormat>,
IAudioElement,
IMediaElement,
IElement {
    private double __gain = 1.0;

    public AudioSink() {
    }

    public AudioSink(AudioFormat inputFormat) {
        super(inputFormat);
    }

    @Override
    protected IAudioOutputCollection createOutputCollection(IAudioInput input) {
        return new IAudioOutputCollection(input);
    }

    @Override
    public AudioConfig getConfig() {
        AudioFormat inputFormat = (AudioFormat)super.getInputFormat();
        if (inputFormat != null) {
            return inputFormat.getConfig();
        }
        return null;
    }

    @Override
    public double getGain() {
        return this.__gain;
    }

    private static AudioBuffer getPcmBuffer(AudioFrame frame, AudioFormat format) {
        if (format != null && format.getIsPcm()) {
            return (AudioBuffer)frame.getBuffer(format);
        }
        return null;
    }

    @Override
    public boolean processFrame(AudioFrame frame) {
        AudioBuffer pcmBuffer = AudioSink.getPcmBuffer(frame, (AudioFormat)super.getInputFormat());
        if (pcmBuffer != null) {
            if (this.getGain() != 1.0) {
                pcmBuffer.applyGain(this.getGain());
            }
            AudioSink.setDuration(frame, pcmBuffer, (AudioFormat)super.getInputFormat());
        }
        return super.processFrame(frame);
    }

    private static void setDuration(AudioFrame frame, AudioBuffer pcmBuffer, AudioFormat format) {
        DataBuffer dataBuffer;
        if (frame.getDuration() == -1.0 && format != null && format.getIsPcm() && (dataBuffer = pcmBuffer.getDataBuffer()) != null) {
            frame.setDuration((double)dataBuffer.getLength() * 1000.0 / (double)(format.getClockRate() * format.getChannelCount() * 2));
        }
    }

    @Override
    public void setGain(double value) {
        this.__gain = MathAssistant.max(value, 0.0);
    }
}

