/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.java.sarxos;

import com.github.sarxos.webcam.Webcam;
import com.github.sarxos.webcam.WebcamEvent;
import com.github.sarxos.webcam.WebcamListener;
import com.github.sarxos.webcam.WebcamPanel;
import fm.icelink.Future;
import fm.icelink.IAction0;
import fm.icelink.IAction1;
import fm.icelink.Log;
import fm.icelink.ManagedThread;
import fm.icelink.Promise;
import fm.icelink.SourceInput;
import fm.icelink.VideoBuffer;
import fm.icelink.VideoConfig;
import fm.icelink.VideoFormat;
import fm.icelink.VideoFrame;
import fm.icelink.java.ImageUtility;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.util.ArrayList;

public class VideoSource
extends fm.icelink.VideoSource
implements WebcamListener {
    private VideoConfig config;
    private Webcam webcam = null;
    private WebcamPanel panel = null;
    private volatile boolean isCapturing;
    private volatile boolean isStopped;
    private Object threadLock = new Object();
    private BufferedImage threadData = null;
    private long lastTimestamp;

    public VideoConfig getConfig() {
        return this.config;
    }

    public void setConfig(VideoConfig videoConfig) {
        this.config = videoConfig;
    }

    public Future<SourceInput[]> getInputs() {
        Promise promise = new Promise();
        ArrayList<SourceInput> inputs = new ArrayList<SourceInput>();
        for (Webcam webcam : Webcam.getWebcams()) {
            inputs.add(new SourceInput(webcam.getName(), webcam.getName()));
        }
        promise.resolve((Object)inputs.toArray(new SourceInput[inputs.size()]));
        return promise;
    }

    public String getLabel() {
        return "Sarxos Webcam Source";
    }

    public VideoSource(VideoConfig config) {
        super(VideoFormat.getRgb());
        this.config = config;
    }

    protected Future<Object> doStart() {
        final Promise promise = new Promise();
        final VideoSource self = this;
        ManagedThread.dispatch((IAction0)new IAction0(){

            public void invoke() {
                try {
                    VideoSource.this.webcam = null;
                    SourceInput input = VideoSource.this.getInput();
                    if (input != null) {
                        for (Webcam wc : Webcam.getWebcams()) {
                            if (!input.getId().equals(wc.getName())) continue;
                            VideoSource.this.webcam = wc;
                        }
                    }
                    if (VideoSource.this.webcam == null) {
                        VideoSource.this.webcam = Webcam.getDefault();
                    }
                    VideoSource.this.setInput(new SourceInput(VideoSource.this.webcam.getName(), VideoSource.this.webcam.getName()));
                    Dimension closestSize = null;
                    int closestSizeDistance = -1;
                    for (Dimension size : VideoSource.this.webcam.getViewSizes()) {
                        int sizeDistance = self.getSizeDistance(VideoSource.this.config.getWidth(), VideoSource.this.config.getHeight(), size.width, size.height);
                        if (closestSize != null && sizeDistance >= closestSizeDistance) continue;
                        closestSize = size;
                        closestSizeDistance = sizeDistance;
                    }
                    if (closestSize != null) {
                        VideoSource.this.webcam.setViewSize(closestSize);
                        Log.info((String)("Video capture: " + closestSize.width + "x" + closestSize.height + ", " + VideoSource.this.config.getFrameRate() + " fps"));
                    } else {
                        Log.info((String)("Video capture: " + VideoSource.this.config.getFrameRate() + " fps"));
                    }
                    VideoSource.this.webcam.addWebcamListener(self);
                    VideoSource.this.isCapturing = true;
                    VideoSource.this.isStopped = false;
                    ManagedThread thread = new ManagedThread((IAction1)new IAction1<ManagedThread>(){

                        public void invoke(ManagedThread thread) {
                            VideoSource.this.captureLoop(thread);
                        }
                    });
                    thread.start();
                    Log.debug((String)("Checking if camera (" + VideoSource.this.getInput().getName() + ") is open."));
                    if (VideoSource.this.webcam.isOpen()) {
                        Log.debug((String)("Closing camera (" + VideoSource.this.getInput().getName() + ")."));
                        VideoSource.this.webcam.close();
                    }
                    for (int i = 0; i < 10; ++i) {
                        Log.debug((String)("Checking if camera (" + VideoSource.this.getInput().getName() + ") is locked."));
                        if (!VideoSource.this.webcam.getLock().isLocked()) break;
                        Log.debug((String)String.format("Waiting for camera (" + VideoSource.this.getInput().getName() + ") to be released (attempt #%d).", i + 1));
                        try {
                            Thread.sleep(100L);
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (VideoSource.this.webcam.getLock().isLocked()) {
                        throw new RuntimeException("Camera (" + VideoSource.this.getInput().getName() + ") is locked.");
                    }
                    Log.debug((String)"Opening camera.");
                    VideoSource.this.webcam.open(true);
                    Log.debug((String)"Camera is ready.");
                    promise.resolve(null);
                }
                catch (Exception ex) {
                    Log.error((String)"Error starting VideoSource.", (Exception)ex);
                    promise.reject(ex);
                }
            }
        });
        return promise;
    }

    protected Future<Object> doStop() {
        final Promise promise = new Promise();
        final VideoSource self = this;
        ManagedThread.dispatch((IAction0)new IAction0(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void invoke() {
                try {
                    VideoSource.this.webcam.removeWebcamListener(self);
                    VideoSource.this.isCapturing = false;
                    while (!VideoSource.this.isStopped) {
                        Object object = VideoSource.this.threadLock;
                        synchronized (object) {
                            VideoSource.this.threadLock.notify();
                        }
                        try {
                            ManagedThread.sleep((int)10);
                        }
                        catch (Exception exception) {}
                    }
                    if (VideoSource.this.panel != null) {
                        VideoSource.this.panel.stop();
                        VideoSource.this.panel = null;
                    }
                    if (VideoSource.this.webcam != null) {
                        VideoSource.this.webcam.close();
                        VideoSource.this.webcam = null;
                    }
                    promise.resolve(null);
                }
                catch (Exception ex) {
                    promise.reject(ex);
                }
            }
        });
        return promise;
    }

    @Override
    public void webcamOpen(WebcamEvent e) {
    }

    @Override
    public void webcamClosed(WebcamEvent e) {
    }

    @Override
    public void webcamDisposed(WebcamEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void webcamImageObtained(WebcamEvent e) {
        float desiredFrameDurationInNanos = 1000.0f / (float)this.config.getFrameRate() * 1000000.0f;
        long timestamp = System.nanoTime();
        if (this.lastTimestamp != -1L && (float)(timestamp - this.lastTimestamp) < desiredFrameDurationInNanos) {
            return;
        }
        this.lastTimestamp = timestamp;
        Object object = this.threadLock;
        synchronized (object) {
            this.threadData = e.getImage();
            this.threadLock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void captureLoop(ManagedThread thread) {
        BufferedImage data = null;
        while (this.isCapturing) {
            if (data != null) {
                try {
                    VideoBuffer buffer = ImageUtility.bufferedImageToBuffer(data);
                    this.raiseFrame(new VideoFrame(buffer));
                }
                catch (Exception ex) {
                    Log.error((String)"Could not raise frame from VideoSource.", (Exception)ex);
                }
            }
            Object object = this.threadLock;
            synchronized (object) {
                if (this.threadData == null) {
                    try {
                        this.threadLock.wait();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                data = this.threadData;
                this.threadData = null;
            }
        }
        this.isStopped = true;
    }
}

