/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.android;

import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.RelativeLayout;
import fm.icelink.IAction0;
import fm.icelink.IAction2;
import fm.icelink.Layout;
import fm.icelink.LayoutFrame;
import fm.icelink.LayoutMode;
import fm.icelink.LayoutPreset;
import fm.icelink.Log;
import fm.icelink.android.Utility;
import java.util.ArrayList;

public class LayoutManager
extends fm.icelink.LayoutManager<View> {
    private ViewGroup container;
    private ViewGroup innerContainer;

    public ViewGroup getContainer() {
        return this.container;
    }

    public LayoutManager(ViewGroup container) {
        this(container, null);
    }

    public LayoutManager(ViewGroup container, LayoutPreset preset) {
        super(preset);
        this.container = container;
        this.innerContainer = new RelativeLayout(container.getContext());
        this.innerContainer.setBackgroundColor(0);
        container.addView((View)this.innerContainer);
        container.addOnLayoutChangeListener(new View.OnLayoutChangeListener(){

            public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                if (left != oldLeft || top != oldTop || right != oldRight || bottom != oldBottom) {
                    LayoutManager.this.layout();
                }
            }
        });
        this.initializeOnGlobalLayout();
    }

    protected void addView(View view) {
        this.innerContainer.addView(view);
    }

    protected void removeView(View view) {
        this.innerContainer.removeView(view);
    }

    protected void dispatchToMainThread(final IAction2<Object, Object> action, final Object arg1, final Object arg2) {
        Utility.dispatchToMainThread(new IAction0(){

            public void invoke() {
                action.invoke(arg1, arg2);
            }
        });
    }

    public void layout() {
        this.initializeLayout();
        ViewGroup.LayoutParams params = this.innerContainer.getLayoutParams();
        int width = params.width;
        int height = params.height;
        if (width > 0 && height > 0) {
            Layout layout;
            View localView = (View)this.getLocalView();
            ArrayList remoteViews = this.getRemoteViews();
            try {
                layout = this.getLayout(width, height, remoteViews.size());
            }
            catch (Exception ex) {
                Log.error((String)"Could not get layout.", (Exception)ex);
                return;
            }
            if (localView != null) {
                LayoutFrame localFrame = layout.getLocalFrame();
                localView.setX((float)localFrame.getX());
                localView.setY((float)localFrame.getY());
                ViewGroup.LayoutParams localParams = localView.getLayoutParams();
                localParams.width = localFrame.getWidth();
                localParams.height = localFrame.getHeight();
                localView.setLayoutParams(localParams);
                if (this.getMode() == LayoutMode.FloatLocal) {
                    localView.bringToFront();
                }
            }
            LayoutFrame[] remoteFrames = layout.getRemoteFrames();
            for (int i = 0; i < remoteFrames.length; ++i) {
                LayoutFrame remoteFrame = remoteFrames[i];
                View remoteView = (View)remoteViews.get(i);
                remoteView.setX((float)remoteFrame.getX());
                remoteView.setY((float)remoteFrame.getY());
                ViewGroup.LayoutParams remoteParams = remoteView.getLayoutParams();
                remoteParams.width = remoteFrame.getWidth();
                remoteParams.height = remoteFrame.getHeight();
                remoteView.setLayoutParams(remoteParams);
                if (this.getMode() != LayoutMode.FloatRemote) continue;
                remoteView.bringToFront();
            }
            this.innerContainer.invalidate();
        }
    }

    protected void initializeOnGlobalLayout() {
        this.container.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                if (LayoutManager.this.initializeLayout()) {
                    ViewTreeObserver vto = LayoutManager.this.container.getViewTreeObserver();
                    try {
                        if (Build.VERSION.SDK_INT < 16) {
                            vto.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                        } else {
                            try {
                                vto.removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                            }
                            catch (NoSuchMethodError nsme) {
                                vto.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                            }
                        }
                    }
                    catch (Exception e) {
                        Log.error((String)"Could not remove global layout listener.", (Exception)e);
                    }
                }
            }
        });
    }

    protected boolean initializeLayout() {
        int width = this.container.getWidth();
        int height = this.container.getHeight();
        if (width > 0 && height > 0) {
            ViewGroup.LayoutParams params = this.innerContainer.getLayoutParams();
            if (width != params.width || height != params.height) {
                params.width = width;
                params.height = height;
                this.innerContainer.setLayoutParams(params);
            }
            if (this.innerContainer.getX() != 0.0f || this.innerContainer.getY() != 0.0f) {
                this.innerContainer.setX(0.0f);
                this.innerContainer.setY(0.0f);
            }
            return true;
        }
        return false;
    }
}

