/*
 * Decompiled with CFR 0.152.
 */
package fm.icelink.stun;

import fm.icelink.ErrorCode;
import fm.icelink.StringExtensions;
import fm.icelink.stun.Error;
import fm.icelink.stun.NonceAttribute;
import fm.icelink.stun.RealmAttribute;

public class UnauthorizedStunError
extends Error {
    private NonceAttribute _nonce;
    private RealmAttribute _realm;

    @Override
    public String getDescription() {
        String str = super.getErrorCode().toString();
        if (super.getMessage() == null) {
            super.setMessage("Server responded with 401 Unauthorized.");
        }
        String message = super.getMessage();
        return StringExtensions.concat(StringExtensions.concat(StringExtensions.concat(str, " ", message.trim()), " Nonce: ", this.getNonce() != null ? this.getNonce().getValue() : "missing"), " Realm: ", this.getRealm() != null ? this.getRealm().getValue() : "missing");
    }

    public NonceAttribute getNonce() {
        return this._nonce;
    }

    public RealmAttribute getRealm() {
        return this._realm;
    }

    private void setNonce(NonceAttribute value) {
        this._nonce = value;
    }

    private void setRealm(RealmAttribute value) {
        this._realm = value;
    }

    public UnauthorizedStunError(NonceAttribute nonce, RealmAttribute realm, String message) {
        super(ErrorCode.StunUnauthorized, "Server responded with 401 Unauthorized.");
        this.setNonce(nonce);
        this.setRealm(realm);
    }

    public UnauthorizedStunError(String message) {
        this(null, null, message);
    }

    public UnauthorizedStunError() {
        this((String)null);
    }
}

